<?php
/*
* ARTURO: FACTURA A TRES COLUMNAS 
* v1.1 - 2024.10.21 - Uso de template. El template se copia desde el plugin hacia el tema hijo si no existe.
* Se debe seleccionar el template conPrecioUnitario en la configuracion de PDF Invoices
*/

defined( 'ABSPATH' ) || exit;


add_action( 'after_setup_theme', 'copy_pdf_template_folder_to_child_theme' );

function copy_pdf_template_folder_to_child_theme() {
    $destination = get_stylesheet_directory() . '/woocommerce/pdf/conPrecioUnitario';
    $source = str_replace('/classes', '', plugin_dir_path(__FILE__)) . 'templates/pdf/conPrecioUnitario';

    // Verificar si la carpeta ya existe en el tema hijo
    if (!file_exists($destination)) {
        // Crear la carpeta destino si no existe
        if (wp_mkdir_p($destination)){
			recurse_copy($source, $destination);
		}else{
			add_action('admin_notices', function() {
				$destination = get_stylesheet_directory() . '/woocommerce/pdf/conPrecioUnitario';
				echo '<div class="notice notice-error"><p>WAO TIENDAS: Debe conceder permisos de escritura a la carpeta <code>'.$destination.'</code>.</p></div>';
			});
		}
    } else {
        // Copiar solo si los archivos en el plugin son más recientes
        recurse_copy_if_newer($source, $destination);
    }
}

function recurse_copy_if_newer($source, $destination) { 
    $dir = opendir($source);
    @mkdir($destination);

    while (false !== ($file = readdir($dir))) {
        if ($file != '.' && $file != '..') {
            $source_path = $source . '/' . $file;
            $dest_path = $destination . '/' . $file;

            if (is_dir($source_path)) {
                recurse_copy_if_newer($source_path, $dest_path);
            } else {
                // Comprobar si el archivo destino no existe o si el archivo origen es más reciente
                if (!file_exists($dest_path) || filemtime($source_path) > filemtime($dest_path)) {
                    copy($source_path, $dest_path);
                }
            }
        }
    }
    closedir($dir);
}

function recurse_copy($source, $destination) {
    $dir = opendir($source);
    @mkdir($destination);

    while(false !== ($file = readdir($dir))) {
        if (($file != '.') && ($file != '..')) {
            if (is_dir($source . '/' . $file)) {
                recurse_copy($source . '/' . $file, $destination . '/' . $file);
            } else {
                copy($source . '/' . $file, $destination . '/' . $file);
            }
        }
    }
    closedir($dir);
}
///////// FIN: FACTURA A TRES COLUMNAS 
