<?php
// Agregar un menú en la sección de ajustes
// Version 2.3: Configuracion de mautic, hooks se borran cuando no hay filas
//				Menu waotiendas en network. Mantiene menu por subsite
//				Links a customers y reporte en pestaña activar api
defined( 'ABSPATH' ) || exit;
 
// Hook para agregar el menú de administración
add_action('admin_menu', 'wao_tiendas_menu');

function wao_tiendas_menu() {
    add_menu_page(
        'WAO Tiendas',
        'WAO Tiendas',
        'manage_options',
        'wao_tiendas',
        'wao_tiendas_page_content',
        'dashicons-store',
        6
    );
}

// Función para mostrar el contenido del menú subsite
function wao_tiendas_page_content() {
    // Tabs
    $active_tab = isset($_GET['tab']) ? $_GET['tab'] : 'parametros_factura';
    ?>
    <div class="wrap">
        <h2>WAO Tiendas</h2>
        <h2 class="nav-tab-wrapper">
            <a href="?page=wao_tiendas&tab=parametros_factura" class="nav-tab <?php echo $active_tab == 'parametros_factura' ? 'nav-tab-active' : ''; ?>">Parámetros Factura</a>

            <?php if(!is_multisite()){// MOSTRAR AQUI SI NO ES MULTISITE?>
			<a href="?page=wao_tiendas&tab=mailtrain_tracking" class="nav-tab <?php echo $active_tab == 'mailtrain_tracking' ? 'nav-tab-active' : ''; ?>">Email Marketing</a>
            <a href="?page=wao_tiendas&tab=configurar_widgets" class="nav-tab <?php echo $active_tab == 'configurar_widgets' ? 'nav-tab-active' : ''; ?>">Configurar Widgets de Red</a>
            <a href="?page=wao_tiendas&tab=activar_api" class="nav-tab <?php echo $active_tab == 'activar_api' ? 'nav-tab-active' : ''; ?>">Activar API</a>
			<?php } ?>

            <a href="?page=wao_tiendas&tab=textos_anadidos" class="nav-tab <?php echo $active_tab == 'textos_anadidos' ? 'nav-tab-active' : ''; ?>">Hooks</a>

        </h2>
        <?php
        switch ($active_tab) {
            case 'parametros_factura':
                wao_parametros_factura_content();
                break;
            case 'mailtrain_tracking':
                wao_mailtrain_tracking_content();
                break;
            case 'configurar_widgets':
                wao_configurar_widgets_content();
                break;
            case 'textos_anadidos':
                wao_textos_anadidos_content();
                break;
            case 'activar_api':
                waotiendas_render_activar_api_tab();
                break;
        }
	?>
    </div>
<?php
}

// Función para mostrar el contenido de 'Parámetros Factura'
// SIEMPRE EN SUBSITE (NO IMPORTA SI ES MULTISITE O NO)
function wao_parametros_factura_content() {
    $options = get_option('_invoices_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        // Guardar los valores en la opción
        $options = [
            'ustidnr' => sanitize_text_field($_POST['ustidnr']),
            'correo_factura' => sanitize_text_field($_POST['correo_factura']),
            'direccion_factura' => sanitize_text_field($_POST['direccion_factura']),
            'direccion2_factura' => sanitize_text_field($_POST['direccion2_factura']),
            'mspartner' => sanitize_text_field($_POST['mspartner']),
            'telefono' => sanitize_text_field($_POST['telefono']),
            'hra' => sanitize_text_field($_POST['hra']),
            'propietario' => stripslashes($_POST['propietario']),
            'empresa' => stripslashes($_POST['empresa']),
            'vertrag' => sanitize_text_field($_POST['vertrag']),
            'lizenzgeber' => sanitize_text_field($_POST['lizenzgeber']),
            'mostrar2factura' => sanitize_text_field($_POST['mostrar2factura']),
            'genverliz' => sanitize_text_field($_POST['genverliz'])
        ];
        update_option('_invoices_options', $options);
        echo '<div class="updated"><p>Parámetros guardados correctamente.</p></div>';
    }

    ?>
    <form method="post">
        <table class="form-table">
            <tr>
                <th><label for="ustidnr">USt-IdNr</label></th>
                <td><input type="text" name="ustidnr" id="ustidnr" value="<?php echo esc_attr($options['ustidnr'] ?? ''); ?>" /> Shortcode: [ustidnr]</td>
            </tr>
            <tr>
                <th><label for="correo_factura">Correo Factura</label></th>
                <td><input type="text" name="correo_factura" id="correo_factura" value="<?php echo esc_attr($options['correo_factura'] ?? ''); ?>" /> Shortcode: [correo]</td>
            </tr>
            <tr>
                <th><label for="direccion_factura">Dirección Factura</label></th>
                <td><textarea name="direccion_factura" id="direccion_factura"><?php echo esc_textarea($options['direccion_factura'] ?? ''); ?></textarea> Shortcode: [direccion]</td>
            </tr>
            <tr>
                <th><label for="direccion2_factura">Dirección 2 Factura</label></th>
                <td><textarea name="direccion2_factura" id="direccion2_factura"><?php echo esc_textarea($options['direccion2_factura'] ?? ''); ?></textarea> Shortcode: [direccion2]</td>
            </tr>
            <tr>
                <th><label for="mspartner">MS Partner</label></th>
                <td><input type="text" name="mspartner" id="mspartner" value="<?php echo esc_attr($options['mspartner'] ?? ''); ?>" /> Shortcode: [mspartner]</td>
            </tr>
            <tr>
                <th><label for="telefono">Teléfono</label></th>
                <td><input type="text" name="telefono" id="telefono" value="<?php echo esc_attr($options['telefono'] ?? ''); ?>" /> Shortcode: [telefono]</td>
            </tr>
            <tr>
                <th><label for="hra">HRA</label></th>
                <td><input type="text" name="hra" id="hra" value="<?php echo esc_attr($options['hra'] ?? ''); ?>" /> Shortcode: [hra]</td>
            </tr>
            <tr>
                <th><label for="propietario">Propietario</label></th>
                <td><input type="text" name="propietario" id="propietario" value="<?php echo esc_attr($options['propietario'] ?? ''); ?>" /> Shortcode: [propietario]</td>
            </tr>
            <tr>
                <th><label for="propietario">Empresa</label></th>
                <td><input type="text" name="empresa" id="empresa" value="<?php echo esc_attr($options['empresa'] ?? ''); ?>" /> Shortcode: [empresa]</td>
            </tr>
            <tr>
                <th><label for="vertrag">Vertrag</label></th>
                <td><input type="text" name="vertrag" id="vertrag" value="<?php echo esc_attr($options['vertrag'] ?? ''); ?>" /> Shortcode: [vertrag]</td>
            </tr>
            <tr>
                <th><label for="lizenzgeber">Lizenzgeber</label></th>
                <td><input type="text" name="lizenzgeber" id="lizenzgeber" value="<?php echo esc_attr($options['lizenzgeber'] ?? ''); ?>" /> Shortcode: [lizenzgeber]</td>
            </tr>
            <tr>
                <th><label for="mostrar2factura">Mostrar la hoja 2 factura?</label></th>
                <td>
                    <input type="radio" name="mostrar2factura" value="S" <?php checked($options['mostrar2factura'] ?? '', 'S'); ?> /> Sí
                    <input type="radio" name="mostrar2factura" value="N" <?php checked($options['mostrar2factura'] ?? '', 'N'); ?> /> No
                </td>
            </tr>
            <tr>
                <th><label for="genverliz">Generar versión de licencia?</label></th>
                <td>
                    <input type="radio" name="genverliz" value="S" <?php checked($options['genverliz'] ?? '', 'S'); ?> /> Sí
                    <input type="radio" name="genverliz" value="N" <?php checked($options['genverliz'] ?? '', 'N'); ?> /> No
                </td>
            </tr>
        </table>
        <p><input type="submit" class="button button-primary" value="Guardar Cambios"></p>
    </form>
    <?php
}

// Manejo de peticion ajax para test de conexion
add_action('wp_ajax_load_ajax_content', 'wao_handle_ajax');
add_action('wp_ajax_nopriv_load_ajax_content', 'wao_handle_ajax');

function wao_handle_ajax() {
    //echo "Contenido generado por PHP dinámicamente 2";
	if (function_exists('mautic_test_page')) {
		echo mautic_test_page();  // Llamar a la función si existe
	} else {
		echo 'La función mautic_test_page() no está definida.';  // Mensaje de error si no existe
	}
    wp_die(); // Termina correctamente la solicitud
}

// Función para 'Mailtrain Tracking'
// En multisite se muestra en network
function wao_mailtrain_tracking_content() {

	//$options = get_option('_mtt_options', array());
	$options = is_multisite()?get_blog_option(1,'_mtt_options', array()):get_option('_mtt_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
		$msg = 'Configuración guardada correctamente.';
		$options['mautic_url'] = normalize_url(sanitize_text_field($_POST['mautic_url']));
        $options['mautic_client_id'] = sanitize_text_field($_POST['mautic_client_id']);
        $options['mautic_client_secret'] = sanitize_text_field($_POST['mautic_client_secret']);
        $mautic_master_config = sanitize_text_field($_POST['mautic_master_config']);
		/*if(is_multisite()){
			if($mautic_master_config=='mc'){
				$sites = get_sites(); // Devuelve un array con todos los sitios en la red multisite
				foreach ($sites as $site) {
					switch_to_blog($site->blog_id);
					$options1=get_option('_mtt_options');
					$options1['mautic_url']=$options['mautic_url'];
					$options1['mautic_client_id']=$options['mautic_client_id'];
					$options1['mautic_client_secret']=$options['mautic_client_secret'];
					update_option('_mtt_options', $options1);
					restore_current_blog();
				}
				$msg = 'Configuración guardada correctamente para todos los sitios del multisite.';
			}
		}*/
        $options['mailtraintracking'] = sanitize_text_field($_POST['mailtraintracking']);
        $options['mautictracking'] = sanitize_text_field($_POST['mautictracking']);
		//update_option('_mtt_options', $options);
		is_multisite()?update_blog_option(1,'_mtt_options', $options):update_option('_mtt_options', $options);

        echo '<div class="updated"><p>'.$msg.'</p></div>';
    }
    ?>
	<div style="padding:40px 20px 40px 20px;">
    <form method="post">
        <table class="form-table">
            <tr>
				<th>
					<label for="mailtraintracking">Activar Mailtrain Tracking (Obsoleto)</label>
				</th>
				<td>
					<input type="checkbox" id="mailtraintracking" name="mailtraintracking" value="S" <?php checked($options['mailtraintracking'] ?? '', 'S'); ?>><small><i> (Mejor usar <b>utm_source</b> y <b>utm_campaign</b> de mautic)</i></small>
				</td>
					
            <tr>
            <tr>
				<th>
					<label for="mautictracking">Activar Filtros de Mautic Tracking</label>
				</th>
				<td>
					<input type="checkbox" id="mautictracking" name="mautictracking" value="S" <?php checked($options['mautictracking'] ?? '', 'S'); ?>>
					<small><i> (En ordenes woocommerce)</i></small>
				</td>
            <tr>
			<tr><th>Configurar api mautic</th><td></td></tr>
            <tr>
                <th style="border-left:solid 1px green;"><label style="padding-left:30px;font-style:italic;" for="mautic_url">Mautic URL</label></th>
                <td><input style="width:420px" type="text" name="mautic_url" id="mautic_url" value="<?php echo esc_attr($options['mautic_url'] ?? ''); ?>" /> </td>
            </tr>
            <tr>
                <th style="border-left:solid 1px green;"><label style="padding-left:30px;font-style:italic;" for="mautic_client_id">Mautic Client ID</label></th>
                <td><input style="width:420px"  type="text" name="mautic_client_id" id="mautic_client_id" value="<?php echo esc_attr($options['mautic_client_id'] ?? ''); ?>" /> </td>
            </tr>
            <tr>
                <th style="border-left:solid 1px green;"><label style="padding-left:30px;font-style:italic;" for="mautic_client_secret">Mautic Client Secret</label></th>
                <td><input style="width:420px"  type="text" name="mautic_client_secret" id="mautic_client_secret" value="<?php echo esc_attr($options['mautic_client_secret'] ?? ''); ?>" /> </td>
            </tr>
            <tr>
                <th style="border-left:solid 1px green;">
					<button type="button" style="margin-left:30px;font-style:italic;" onclick="loadContent()">Test connection</button>
				</th>
                <td>
					<div id="dynamic-content" style="margin-top: 20px; border: 1px solid #ccc; padding: 10px;">
						<p>Test result.</p>
					</div>
				</td>
            </tr>
            <!--<tr>
                <th style="border-left:solid 1px green;"><label style="padding-left:30px;font-style:italic;" for="mautic_client_id">Master config</label></th>
                <td><input type="checkbox" name="mautic_master_config" id="mautic_master_config" value="mc"> <small><i> (Guardar para todos los subshops)</i></small> </td>
            </tr>-->

		</table>
        <p style="padding-top:20px;"><input type="submit" class="button button-primary" value="Save Changes"></p>
    </form>

	</div>
     <script>
        function loadContent() {
            // Crear la solicitud Fetch
			fetch(ajaxurl, {
				method: 'POST',
				headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
				body: new URLSearchParams({ action: 'load_ajax_content' })
			})
			.then(response => response.text())
			.then(html => {
				document.getElementById('dynamic-content').innerHTML = html;
			})
			.catch(error => console.error('Error:', error));
					}
    </script>   <?php
}

// Función para 'Configurar Widgets de Red'
// En multisite se muestra en network
function wao_configurar_widgets_content() {
	$options = is_multisite()?get_blog_option(1,'_waotiendas_options', array()):get_option('_waotiendas_options', array());
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $options['excluidos'] = sanitize_text_field($_POST['excluidos']);

        $ventas_enabled = isset($_POST['widget_ventas']) ? 1 : 0;
        $options['widget_ventas'] = $ventas_enabled;

        $bancos_enabled = isset($_POST['widget_bancos']) ? 1 : 0;
        $options['widget_bancos'] = $bancos_enabled;


		is_multisite()?update_blog_option(1, '_waotiendas_options', $options):update_option('_waotiendas_options', $options);
        echo '<div class="updated"><p>Configuración guardada correctamente.</p></div>';


    }
    $ventas_enabled = isset($options['widget_ventas']) ? (bool) $options['widget_ventas'] : false;
    $bancos_enabled = isset($options['widget_bancos']) ? (bool) $options['widget_bancos'] : false;

    ?>
	<div style="padding:40px 20px 40px 20px;">
    <form method="post">
		<table>
			<tr>
				<td><label for="excluidos">Excluidos</label></td>
				<td><input type="text" name="excluidos" id="excluidos" style="width:500px" value="<?php echo esc_attr($options['excluidos'] ?? ''); ?>" placeholder="Excluir sitios como manuals, etc." /><i>Excluir sitios como <b>manuals</b>, etc</i></td>
			</tr>
			<tr>
				<td><label style="display:block;margin-top:5px;">Activar Widget Red Ventas Diarias</label></td>
				<td><input type="checkbox" name="widget_ventas" value="1" <?php checked($ventas_enabled, true); ?>></td>
			</tr>
			<tr>
				<td><label style="display:block;margin-top:5px;">Activar Widget Red Bancos</label></td>
				<td><input type="checkbox" name="widget_bancos" value="1" <?php checked($bancos_enabled, true); ?>></td>
			</tr>
		</table>

       <p style="padding-top:20px;"><input type="submit" class="button button-primary" value="Save Changes"></p>

    </form>
	</div>
    <?php
}

// Función para 'Textos Añadidos'
// En subsite.
function wao_textos_anadidos_content() {
    $options = get_option('_textos_options', array());

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['textos'])) {
        $options = array_map(function($texto) {
            return [
                'texto' => $texto['texto'],
                'ubicacion' => sanitize_text_field($texto['ubicacion']),
                'prioridad' => sanitize_text_field($texto['prioridad']),
                'activo' => sanitize_text_field($texto['activo'])
            ];
        }, $_POST['textos']);
		update_option('_textos_options', $options);
		echo '<div class="updated"><p>Textos guardados correctamente.</p></div>';
    }else{
		if(isset($_POST['guardar'])&&$_POST['guardar']=='Guardar'){
			delete_option('_textos_options');
			echo '<div class="updated"><p>No hay mas textos.</p></div>';
			unset($options);
		}
	}

    ?>
    <form method="post">
        <table class="form-table" style="width:70%">
            <thead>
                <tr style="border-bottom:solid 1px gray">
                    <th style="width:40%">Texto</th>
                    <th style="width:30%">Ubicación</th>
                    <th style="width:10%">Prioridad</th>
                    <th style="width:10%">Activo</th>
                    <th style="width:10%">Acciones</th>
                </tr>
            </thead>
            <tbody id="textos-rows">
                <?php foreach ($options as $index => $texto_data): ?>
                    <tr>
                        <td style="width:40%"><textarea cols="70" name="textos[<?php echo $index; ?>][texto]"><?php echo stripslashes($texto_data['texto']); ?></textarea></td>
                        <td style="width:30%"><input style="width:100%;" type="text" name="textos[<?php echo $index; ?>][ubicacion]" value="<?php echo esc_attr($texto_data['ubicacion']); ?>"></td>
						<td style="width:10%"><input style="width:100%;" type="text" name="textos[<?php echo $index; ?>][prioridad]" value="<?php echo esc_attr($texto_data['prioridad']); ?>"></td>
                        <td style="width:10%">
							<input style="width:10px;" type="checkbox" name="textos[<?php echo $index; ?>][activo]" value="S" <?php checked($texto_data['activo'], 'S'); ?>> Sí
                        </td>
                        <td style="width:10%"><button type="button" class="button button-secondary delete-row">Borrar fila</button></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <p><button type="button" class="button button-secondary" id="add-row">Incrementar fila</button></p>
        <p><input type="submit" class="button button-primary" id="guardar" name="guardar" value="Guardar"></p>
    </form>

	<hr><br>
	<div style="border:solid 1px gray;border-radius:3px;padding:7px;vertical-align:middle;">
		<form method="post" action="admin-post.php" style="display:inline-block">
			<input type="hidden" name="action" value="wao_hooks_export">
			<button type="submit" name="wao_hooks_export" class="button">Exportar</button>
		</form>

		<form style="display:inline-block;" method="post" action="admin-post.php" enctype="multipart/form-data">
			<input type="hidden" name="action" value="wao_hooks_import">
			<span style="border:solid 1px gray;border-radius:3px;padding:7px;margin-left:55px;background-color:#dfdfdf;">
			<input type="file" name="wao_hooks_import_file" style="margin-left: 10px;" />
			<button type="submit" name="wao_hooks_import" class="button">Importar</button>
			</span>
		</form>
	</div>


    <script>
        document.getElementById('add-row').addEventListener('click', function() {
            const table = document.getElementById('textos-rows');
            const rowCount = table.rows.length;
            const newRow = table.insertRow();
            newRow.innerHTML = `
                <td style="width:40%"><textarea cols="70" name="textos[${rowCount}][texto]"></textarea></td>
                <td style="width:30%"><input style="width:100%;" type="text" name="textos[${rowCount}][ubicacion]"></td>
				<td style="width:10%"><input style="width:100%;" type="text" name="textos[${rowCount}][prioridad]"></td>
                <td style="width:10%">
					<input style="width:10px;" type="checkbox" name="textos[${rowCount}][activo]" value="S"> Sí
                </td>
                <td style="width:10%"><button type="button" class="button button-secondary delete-row">Borrar fila</button></td>
            `;
            addDeleteFunctionality();
        });

        function addDeleteFunctionality() {
            document.querySelectorAll('.delete-row').forEach(button => {
                button.addEventListener('click', function() {
                    this.closest('tr').remove();
                });
            });
        }

        addDeleteFunctionality();
    </script>
    <?php
}


	add_shortcode( 'nombreshop', 'agreganombreshop' );
	//CARGA EL LA INFORMACIÓN COMO SHORTCODE
	add_shortcode( 'ustidnr', 'agregaustidnr' );
	add_shortcode( 'correo', 'agregacorreo' );
	add_shortcode( 'direccion', 'agregadireccion' );
	add_shortcode( 'direccion2', 'agregadireccion2' );
	add_shortcode( 'hra', 'agregahra' );
	add_shortcode( 'propietario', 'agregapropietario' );
	add_shortcode( 'empresa', 'agregaempresa' );
	add_shortcode( 'mspartner', 'agregamspartner' );
	add_shortcode( 'telefono', 'agregatelefono' );
	add_action('woocommerce_admin_order_data_after_order_details','paypal1');//sale en edit de order
	add_shortcode( 'urltienda', 'urlTienda' );
	add_shortcode( 'vertrag', 'agregavertrag' );
	add_shortcode( 'lizenzgeber', 'agregalizenzgeber' );
	function agregaustidnr_init(){
		function agregaustidnr() {
		  $options = get_option( '_invoices_options');
		  return is_bool($options)?"none":$options['ustidnr'];
		}
		function agregacorreo($attr) {
			$args = shortcode_atts( array(
					'eslink' => 's',
				), $attr );
			$options = get_option( '_invoices_options');
			if (!is_bool($options)) {
				if ($args['eslink']=="s"){
					return "<a href='mailto:".$options['correo_factura']."'>".$options['correo_factura']."</a>"; 
				}else{
					return $options['correo_factura'];
				}
			}else{return "none";}
		}
		function agregadireccion() {
		  $options = get_option( '_invoices_options');
		  return is_bool($options)?"none":$options['direccion_factura'];
		}
		function agregadireccion2() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['direccion2_factura'];
		}
		function agregamspartner() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['mspartner'];
		}
		function agregatelefono() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['telefono'];
		}
		function agregahra() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['hra'];
		}
		function agregapropietario() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['propietario'];
		}
		function agregaempresa() {
		  $options = get_option( '_invoices_options' );
		  return is_bool($options)?"none":$options['empresa'];
		}
		function agreganombreshop() {
		  $options = get_option( 'wpo_wcpdf_settings_general' );
		  return is_bool($options)?"none":$options['shop_name']['default'];
		}
		function urlTienda($attr){
			$args = shortcode_atts( array(
					'eslink' => 's',
					'prtcl'  => 's',
				), $attr );
			$home = get_option( 'siteurl' );
			if ($args['prtcl']<>"s"){
				$home=str_replace("https://", "", $home);
				$home=str_replace("http://", "", $home);
				$home=str_replace("https//", "", $home);
				$home=str_replace("http//", "", $home);
			}
			
			if ($args['eslink']=="s"){
				return "<a href='$home'>$home</a>";
			}else{
				return $home;
			}
		}
		function agregavertrag() {
		  $options = get_option( '_invoices_options' );
		  return $options['vertrag'];
		}
		function agregalizenzgeber() {
		  $options = get_option( '_invoices_options' );
		  return $options['lizenzgeber'];
		}
	}
	add_action('init', 'agregaustidnr_init');

function estilo_icono() {
    // Define el código CSS
    $css_personalizado = '
		.toplevel_page_my_custom_settings>.dashicons-admin-settings:before{color:#83A2FF!important;}
		//.toplevel_page_my_custom_settings div.dashicons-admin-settings:before{color:yellow!important;}
		//.dashicons-admin-settings{color:yellow!important;background-color:white!important;}
    ';

    // Registra el estilo
    wp_register_style('estilo-personalizado-admin', false); // El segundo parámetro es la URL, que es falso en este caso

    // Agrega el código CSS personalizado al estilo registrado
    wp_add_inline_style('estilo-personalizado-admin', $css_personalizado);

    // Enqueue the style
    wp_enqueue_style('estilo-personalizado-admin');
}

// Engancha la función a la acción 'admin_enqueue_scripts'
//add_action('admin_enqueue_scripts', 'estilo_icono');

function paypal1($post){//sale en edit de order PAYPAL RECEIVER
	$id=$post->get_id();
	$tt=get_post_meta( $id,'_payment_method' );
	if ($tt[0]=='paypal'||$tt[0]=='ppec_paypal'||$tt[0]=='ppcp-gateway'||$tt[0]=='ppcp'){
		$options1 = get_post_meta( $id,'paypal_receiver' );
		echo "<p class='form-field form-field-wide wc-customer-user' style='color:blue;padding-top:190px;border:solid 1px gray;border-radius:3px;'>Paypal receiver: ".$options1[0]."</p>"; 
	}	
}

function get_waotiendas1_option($indice="nothing"){
	$options = is_multisite()?get_blog_option(1,'_waotiendas_options', array()):get_option('_waotiendas_options', array());
	if(!isset($option[$indice])){
		$retorno = FALSE;
	}else{
		$retorno = $option[$indice];
	}
	return $retorno;
}

function update_waotiendas1_option($indice,$valor){
	if(is_multisite()){
		$thissite = get_current_blog_id();
		switch_to_blog(1);
	}
	$option = get_option('_waotiendas_options');
	if(!is_bool($option[$indice])){
		$option[$indice]=$valor;
		if (update_option('_waotiendas_options',$option)){
			$retorno = TRUE;
		}else{
			$retorno = FALSE;
		}
	}else{
		$retorno = FALSE;
	}
	if(is_multisite()){
		restore_current_blog();
	}
	return $retorno;
}

function normalize_url($url) {
    // Asegúrate de que la URL tenga el prefijo "https://"
    if (strpos($url, 'https://') !== 0) {
        $url = 'https://' . $url;
    }
    
    // Analiza la URL y obtén solo el host
    $parsed_url = parse_url($url);
    if (isset($parsed_url['host'])) {
        $host = $parsed_url['host'];
    } else {
        // Si no hay host, asume que toda la cadena es el host
        $host = $parsed_url['path'] ?? '';
    }
    
    // Devuelve la URL normalizada
    return 'https://' . $host;
}

// MENU DE CONFIGURACION EN NETWORK (CUANDO ES MULTISITE)
if(is_multisite()){
	add_action('network_admin_menu', 'waotiendas_add_network_menu');
}

function waotiendas_add_network_menu() {
	add_menu_page(
		'Configuración de WAOTiendas',
		'WAOTiendas',
		'manage_network_options',
		'waotiendas-network-settings',
		'waotiendas_network_settings_page',
		'dashicons-store',
		6
	);
}

function waotiendas_network_settings_page() {
    $active_tab = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'activar_api';
    ?>
    <div class="wrap">
        <h1>Configuración de WAOTiendas RED</h1>
        <h2 class="nav-tab-wrapper">
            <a href="?page=waotiendas-network-settings&tab=activar_api" class="nav-tab <?php echo $active_tab == 'activar_api' ? 'nav-tab-active' : ''; ?>">Activar API</a>
            <a href="?page=waotiendas-network-settings&tab=email_marketing" class="nav-tab <?php echo $active_tab == 'email_marketing' ? 'nav-tab-active' : ''; ?>">Email Marketing</a>
            <a href="?page=waotiendas-network-settings&tab=configurar_widgets" class="nav-tab <?php echo $active_tab == 'configurar_widgets' ? 'nav-tab-active' : ''; ?>">Configurar Widgets de Red</a>
            <!--<a href="?page=waotiendas-network-settings&tab=en_desarrollo" class="nav-tab <?php echo $active_tab == 'en_desarrollo' ? 'nav-tab-active' : ''; ?>">En desarrollo</a>-->
        </h2>
        
        <form method="post" action="">
            <?php
            if ($active_tab == 'activar_api') {
                waotiendas_render_activar_api_tab();
            } elseif ($active_tab == 'email_marketing') {
				wao_mailtrain_tracking_content();
            } elseif ($active_tab == 'configurar_widgets') {
				wao_configurar_widgets_content();
            } elseif ($active_tab == 'en_desarrollo') {
                echo '<p>En desarrollo...</p>';
            }
            ?>
        </form>
    </div>
    <?php
}

function waotiendas_render_activar_api_tab() {
    if (isset($_POST['waotiendas_save_api'])) {
        check_admin_referer('waotiendas_save_api_nonce');
        $api_enabled = isset($_POST['activar_api']) ? 1 : 0;
		$options = is_multisite()?get_blog_option(1,'_waotiendas_options', array()):get_option('_waotiendas_options', array());
        $options['activar_api'] = $api_enabled;
		is_multisite()?update_blog_option(1, '_waotiendas_options', $options):update_option('_waotiendas_options', $options);
        echo '<div class="updated"><p>Configuración guardada.</p></div>';
    }

    $subsite_1_id = 1;
    //$options = get_blog_option($subsite_1_id, '_waotiendas_options', []);
	$options = is_multisite()?get_blog_option(1,'_waotiendas_options', array()):get_option('_waotiendas_options', array());
    $api_enabled = isset($options['activar_api']) ? (bool) $options['activar_api'] : false;
    ?>
    <h2>Activar API</h2>
    <div style="background-color:#dfdfdf;border-left:solid 2px gray;padding:0px 5px 0px 8px;">
	<p>Se tiene una API para 2 cosas:</p>
	<ol><li>Generar reporte de clientes para Stephan (shortcode [reporte])</li><li>Descargar clientes por pais. (API /wp-json/custom/v1/reporte y shortcode [customers])</li></ol>
    <p>Activar esto solo cuando sea necesario</p>
    </div>
    <label>
        <input type="checkbox" name="activar_api" value="1" <?php checked($api_enabled, true); ?>> Activar API
    </label>
    <br><br>
    <input type="hidden" name="waotiendas_save_api" value="1">
    <?php wp_nonce_field('waotiendas_save_api_nonce'); ?>
    <input type="submit" class="button button-primary" value="Guardar cambios">
	<?php if ($options['activar_api']==1){ ?>
	<hr>
	<span><a href="/customers" target="_blank">Descargar emails Clientes</a></span>
	<span><a href="/reporte" target="_blank">Reporte potenciales</a></span>
    <?php
	}// fin de if
}


add_action('admin_post_wao_hooks_export', function() {
    if (isset($_POST['wao_hooks_export'])) {
        $data = get_option('_textos_options', []);
        header('Content-Disposition: attachment; filename="wao-data.json"');
        echo json_encode($data);
        exit;
    }
});

add_action('admin_post_wao_hooks_import', function() {
    if (isset($_POST['wao_hooks_import']) && isset($_FILES['wao_hooks_import_file'])) {
        $file = $_FILES['wao_hooks_import_file']['tmp_name'];
        if ($file) {
            $data = json_decode(file_get_contents($file), true);
            update_option('_textos_options', isset($data) ? stripslashes_deep($data) : []);
        }
        exit;
    }
});