<?php
/**
 * @package Woocomerce-Rest-A AMAZON
 */
/*
Plugin Name: WAO Amazon
Plugin URI: https://rusland.rojas.com/
Description: Redirect woocommerce order data to another website b.
Version: 1.0.1
Author: Rusland Rojas
Author URI: https://rusland.rojas.com/
*/

if (!defined('ABSPATH')) {
    exit;
}

add_action('plugins_loaded', 'init_highriskshop_rest_api_gateway_amazon');

function init_highriskshop_rest_api_gateway_amazon() {
    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

    class WC_highriskshop_rest_api_Gateway_A extends WC_Payment_Gateway {
        public function __construct() {
            $this->id = 'highriskshop_rest_api_amazon';
            $this->has_fields = false;
            $this->method_title = 'WAO AMAZON';
            $this->method_description = 'This payment method will basically redirect the customer anonymously to your front shop allowing you to receive the payment using another Woocommerce installation using REST API';
            $this->init_form_fields();
            $this->init_settings();

            $this->title = $this->get_option('title');
            $this->description = $this->get_option('description');
           
			$this->lowrisk_shop_url = $this->get_option('lowrisk_shop_url');
			

            // Set payment method icon
            $this->icon = plugin_dir_url(__FILE__) . 'amazon.svg';

            add_action('woocommerce_update_options_payment_gateways_' . $this->id, array($this, 'process_admin_options'));
            add_action('woocommerce_api_highriskshop_rest_api_callback', array($this, 'check_callback_response'));
        }

        public function init_form_fields() {
            $this->form_fields = array(
                'enabled' => array(
                    'title' => 'Enable/Disable',
                    'type' => 'checkbox',
                    'label' => 'Enable highriskshop_rest_api_amazon Gateway',
                    'default' => 'yes',
                ),
                'title' => array(
                    'title' => 'Title',
                    'type' => 'text',
                    'description' => 'This controls the title which the user sees during checkout.',
                    'default' => 'Amazon',
                    'desc_tip' => true,
                ),
                'description' => array(
                    'title' => 'Description',
                    'type' => 'textarea',
                    'description' => 'This controls the description which the user sees during checkout.',
                    'default' => 'Pay using your Amazon account',
                ),
				'lowrisk_shop_url' => array(
                    'title' => 'Low Risk Shop URL',
                    'type' => 'text',
                    'description' => 'Insert low risk shop URL',
                    'default' => '',
                    'desc_tip' => true,
                ),
            );
        }

        public function process_payment($order_id) {
            $order = wc_get_order($order_id);
			$myordernow = $order->get_id();
			$myaffiliateurl = home_url();

            // Add parameters to the array with the selected fee amount
            $params = array(
		  'total_amount' => urlencode($order->get_total()),
        'billing_first_name' => urlencode($order->get_billing_first_name()),
        'billing_last_name' => urlencode($order->get_billing_last_name()),
        'billing_email' => urlencode($order->get_billing_email()),
        'billing_company' => urlencode($order->get_billing_company()),
        'billing_address_1' => urlencode($order->get_billing_address_1()),
        'billing_address_2' => urlencode($order->get_billing_address_2()),
        'billing_city' => urlencode($order->get_billing_city()),
        'billing_state' => urlencode($order->get_billing_state()),
        'billing_postcode' => urlencode($order->get_billing_postcode()),
        'billing_country' => urlencode($order->get_billing_country()),
        'billing_phone' => urlencode($order->get_billing_phone()),
        'currency' => urlencode($order->get_currency()),
		'myordernow' => urlencode($myordernow),
		'myaffiliateurl' => urlencode($myaffiliateurl),
            );

            $strtozmdjdjnjdn = rtrim($this->lowrisk_shop_url, '/');
			$djndndkjndkjndee = $strtozmdjdjnjdn . '/wp-content/plugins/woocommerce-rest-b/paynow-checkout.php';
            $tozawyredirect_url = add_query_arg($params, $djndndkjndkjndee);
header("Referrer-Policy: no-referrer");
            return array(
                'result' => 'success',
                'redirect' => $tozawyredirect_url,
            );
        }
    }

    function add_highriskshop_rest_api_gateway_a($methods) {
        $methods[] = 'WC_highriskshop_rest_api_Gateway_A';
        return $methods;
    }

    add_filter('woocommerce_payment_gateways', 'add_highriskshop_rest_api_gateway_a');
}

if (!class_exists("WC_Rest_API_A")) {
    class WC_Rest_API_A {

        public function __construct() {
            add_action('rest_api_init', array(
                $this,
                'init_rest_api'
            ));
        }

        public function init_rest_api() {
            register_rest_route('api/v2', '/wcwcwcwcwcw837378373773-order-completed', array(
                'methods' => 'POST',
                'callback' => array(
                    $this,
                    'wcwcwcwcwcwcw82828282844_change_order_to_completed'
                ),
                'permission_callback' => '__return_true', // Add this line
            ));

            register_rest_route('api/v2', '/wcwcwcwcwcw837378373773-order-refunded', array(
                'methods' => 'POST',
                'callback' => array(
                    $this,
                    'wcwcwcwcwcwcw82828282844_change_order_to_refunded'
                ),
                'permission_callback' => '__return_true', // Add this line
            ));

            register_rest_route('api/v2', '/wcwcwcwcwcw837378373773-order-cancelled', array(
                'methods' => 'POST',
                'callback' => array(
                    $this,
                    'wcwcwcwcwcwcw82828282844_change_order_to_cancelled'
                ),
                'permission_callback' => '__return_true', // Add this line
            ));

            register_rest_route('api/v2', '/wcwcwcwcwcw837378373773-order-processing', array(
                'methods' => 'POST',
                'callback' => array(
                    $this,
                    'wcwcwcwcwcwcw82828282844_change_order_to_processing'
                ),
                'permission_callback' => '__return_true', // Add this line
            ));
            
            register_rest_route('api/v2', '/wcwcwcwcwcw837378373773-order-zeftprocessing', array(
                'methods' => 'POST',
                'callback' => array(
                    $this,
                    'wcwcwcwcwcwcw82828282844_change_order_to_zeftprocessing'
                ),
                'permission_callback' => '__return_true', // Add this line
            ));

            register_rest_route('api/v2', '/wcwcwcwcwcw837378373773-order-hold', array(
                'methods' => 'POST',
                'callback' => array(
                    $this,
                    'wcwcwcwcwcwcw82828282844_change_order_to_hold'
                ),
                'permission_callback' => '__return_true', // Add this line
            ));

            register_rest_route('api/v2', '/wcwcwcwcwcw837378373773-order-pending', array(
                'methods' => 'POST',
                'callback' => array(
                    $this,
                    'wcwcwcwcwcwcw82828282844_change_order_to_pending'
                ),
                'permission_callback' => '__return_true', // Add this line
            ));		
        }

        public function wcwcwcwcwcwcw82828282844_change_order_to_completed($data)
        {
            $order_id = $data['order_id'];
            $order = new WC_Order($order_id);
            $res = array(
                    'status' => false,
                    'url' => '',
                    );
            
            if (!empty($order)) {
                $res['status'] = $order->update_status('completed');
                $res['url'] = ($order->get_checkout_order_received_url());
            }
            return json_encode($res);
        }

        public function wcwcwcwcwcwcw82828282844_change_order_to_refunded($data)
        {
            $order_id = $data['order_id'];
            $order = new WC_Order($order_id);
            $res = array(
                    'status' => false,
                    'url' => '',
                    );
            
            if (!empty($order)) {
                $res['status'] =  $order->update_status('refunded');
                $res['url'] = $order->get_checkout_order_received_url();
            }
            return json_encode($res);
        }

        public function wcwcwcwcwcwcw82828282844_change_order_to_cancelled($data)
        {
            $order_id = $data['order_id'];
            $order = new WC_Order($order_id);
            $res = array(
                    'status' => false,
                    'url' => '',
                    );
            
            if (!empty($order)) {
                $res['status'] = $order->update_status('cancelled');
                $res['url'] = $order->get_checkout_order_received_url();
            }
            return json_encode($res);
        }

        public function wcwcwcwcwcwcw82828282844_change_order_to_zeftprocessing($data)
        {
            $order_id = $data['order_id'];
            $order = new WC_Order($order_id);
            $res = array(
                    'status' => false,
                    'url' => '',
                    );

            if (!empty($order)) {
                if ($order->has_status('pending')) {
                    $order->payment_complete();
                    $res['status'] = $order->update_status('processing');
                    $res['url'] = $order->get_checkout_order_received_url();
                }
            }
            return json_encode($res);
        }
        
        public function wcwcwcwcwcwcw82828282844_change_order_to_processing($data)
        {
            $order_id = $data['order_id'];
            $order = new WC_Order($order_id);
            $res = array(
                    'status' => false,
                    'url' => '',
                    );

            if (!empty($order)) {
                if ($order->has_status('pending')) {
                    $order->payment_complete();
                }
                if (!$order->has_status('completed')) { 
                    $res['status'] = $order->update_status('processing');
                }
                $res['url'] = $order->get_checkout_order_received_url();
            }
            return json_encode($res);
        }

        public function wcwcwcwcwcwcw82828282844_change_order_to_hold($data)
        {
            $order_id = $data['order_id'];
            $order = new WC_Order($order_id);
            $res = array(
                    'status' => false,
                    'url' => '',
                    );

            if (!empty($order)) {
                $res['status'] = $order->update_status('on-hold');
                $res['url'] = $order->get_checkout_order_received_url();
            }
            return json_encode($res);
            
        }

        public function wcwcwcwcwcwcw82828282844_change_order_to_pending($data)
        {
            $order_id = $data['order_id'];
            $order = new WC_Order($order_id);
            $res = array(
                    'status' => false,
                    'url' => '',
                    );

            if (!empty($order)) {
                $res['status'] = $order->update_status('pending');
                $res['url'] = $order->get_checkout_order_received_url();
            }
            return json_encode($res);
        }	
    } 
    new WC_Rest_API_A();
}

//
if (!function_exists('search_key_func')) {
    function search_key_func () {
        if(isset($_GET['search_key']) && $_GET['search_key'] == true) {

            if (is_checkout() && !empty(is_wc_endpoint_url('order-received'))) {
                $order_id = isset($_GET['id']) ? absint($_GET['id']) : 0;

                $id_payment = isset($_GET['id_payment']) ? absint($_GET['id_payment']) : '';
                $site_url = isset($_GET['site_url']) ? $_GET['site_url'] : '';

                if (!$order_id) return;

                $order = wc_get_order($order_id);

                if (!$order) return;

                // id_payement
                $note = "Orden donde se realizo el Pago : <a href='".urldecode($site_url)."/wp-admin/post.php?post=".urldecode($id_payment)."&action=edit'>".urldecode($site_url)." Order #".urldecode($id_payment)."</a>";
                $has_active_autodispatch = true;
                foreach ($order->get_items() as $item) {
                    $product = $item->get_product();
                    if ($product) {
                        $autodispatch_option = get_post_meta($product->get_id(), '_autodispatch_option', true);
                        //error_log("VALOR AUTODISPATCH ". $autodispatch_option);
                        if (!empty($autodispatch_option) && $autodispatch_option == 'no') {
                            $has_active_autodispatch = false;
                            break;
                        }
                    }
                }
                //error_log("TIENE ".$has_active_autodispatch);
                if ($has_active_autodispatch == false) {
                    $order->add_order_note($note);
                    $order->update_status('processing');
                    //error_log("REDIRECT 2 processing: ".$order->get_checkout_order_received_url());
                    wp_redirect($order->get_checkout_order_received_url());
                    exit;
                }
                else {
                    $order->add_order_note($note);
                    $order->update_status('completed');
                    //error_log("REDIRECT 2 COMPLETED: ".$order->get_checkout_order_received_url());
                    wp_redirect($order->get_checkout_order_received_url());
                    exit;
                }
            }
        }
    }
    add_action( 'template_redirect', 'search_key_func');
}



?>