
<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package softa
 */
?>
			<?php if(softa_styles()['show_footer_top'] == '1') { ?>
				<div class="footer-top main-row">
					<div class="container">
						<div class="row">
							<div class="col-xs-12 col-sm-4">
								<?php if(softa_styles()['show_subcribe_form'] == '1' && !empty(softa_styles()['subcribe_code'])) { ?>
									<?php echo do_shortcode(softa_styles()['subcribe_code']); ?>
								<?php } ?>
							</div>
							<div class="col-xs-12 col-sm-4">
								<?php if(softa_styles()['show_social_buttons'] == '1' && (!empty(softa_styles()['facebook_link']) || !empty(softa_styles()['twitter_link']) || !empty(softa_styles()['instagram_link']) || !empty(softa_styles()['youtube_link']) || !empty(softa_styles()['gp_link']) || !empty(softa_styles()['linkedin_link']) || !empty(softa_styles()['skype_link'])) || !empty(softa_styles()['telegram_link'])) { ?>
									<div class="social-buttons">
										<span><?php echo esc_html__('follow us:', 'softa'); ?></span>
										<?php if(softa_styles()['facebook_link']) { ?>
											<a href="<?php echo esc_url(softa_styles()['facebook_link']) ?>" target="<?php echo esc_attr(softa_styles()['social_target']) ?>"><i class="social-icon-facebook"></i></a>
										<?php } if(softa_styles()['twitter_link']) { ?>
											<a href="<?php echo esc_url(softa_styles()['twitter_link']) ?>" target="<?php echo esc_attr(softa_styles()['social_target']) ?>"><i class="social-icon-twitter"></i></a>
										<?php } if(softa_styles()['instagram_link']) { ?>
											<a href="<?php echo esc_url(softa_styles()['instagram_link']) ?>" target="<?php echo esc_attr(softa_styles()['social_target']) ?>"><i class="social-icon-instagram"></i></a>
										<?php } if(softa_styles()['youtube_link']) { ?>
											<a href="<?php echo esc_url(softa_styles()['youtube_link']) ?>" target="<?php echo esc_attr(softa_styles()['social_target']) ?>"><i class="social-icon-youtube"></i></a>
										<?php } if(softa_styles()['gp_link']) { ?>
											<a href="<?php echo esc_url(softa_styles()['gp_link']) ?>" target="<?php echo esc_attr(softa_styles()['social_target']) ?>"><i class="social-icon-google-plus"></i></a>
										<?php } if(softa_styles()['linkedin_link']) { ?>
											<a href="<?php echo esc_url(softa_styles()['linkedin_link']) ?>" target="<?php echo esc_attr(softa_styles()['social_target']) ?>"><i class="social-icon-linkedin"></i></a>
										<?php } if(softa_styles()['skype_link']) { ?>
											<a href="<?php echo esc_url(softa_styles()['skype_link']) ?>" target="<?php echo esc_attr(softa_styles()['social_target']) ?>"><i class="social-icon-skype"></i></a>
										<?php } if(softa_styles()['telegram_link']) { ?>
											<a href="<?php echo esc_url(softa_styles()['telegram_link']) ?>" target="<?php echo esc_attr(softa_styles()['social_target']) ?>"><i class="fa fa-telegram"></i></a>
										<?php } ?>
									</div>
								<?php } ?>
							</div>
							<div class="col-xs-12 col-sm-4">
								<?php if(softa_styles()['show_search_form'] == '1') { ?>
									<?php get_search_form(); ?>
								<?php } ?>
							</div>
						</div>
					</div>
				</div>
			<?php } if(softa_styles()['footer'] == 'show') { ?>
				<footer class="site-footer main-row">
					<div class="container">
						<div class="row">
							<?php if(is_active_sidebar('footer-1')) { ?>
							<div class="col-xs-12 col-md-<?php echo esc_attr(softa_styles()['footer_col_1']) ?>">
								<?php dynamic_sidebar('footer-1'); ?>
							</div>
							<?php } if(is_active_sidebar('footer-2')) { ?>
							<div class="col-xs-12 col-sm-6 col-md-<?php echo esc_attr(softa_styles()['footer_col_2']) ?>">
								<?php dynamic_sidebar('footer-2'); ?>
							</div>
							<?php } if(is_active_sidebar('footer-3')) { ?>
							<div class="col-xs-12 col-sm-6 col-md-<?php echo esc_attr(softa_styles()['footer_col_3']) ?>">
								<?php dynamic_sidebar('footer-3'); ?>
							</div>
							<?php } if(is_active_sidebar('footer-4')) { ?>
							<div class="col-xs-12 col-sm-6 col-md-<?php echo esc_attr(softa_styles()['footer_col_4']) ?>">
								<?php dynamic_sidebar('footer-4'); ?>
							</div>
							<?php } ?>
						</div>
					</div>
					<?php if(softa_styles()['copyright_text']) { ?>
						<div class="copyright">
							<?php echo wp_kses(softa_styles()['copyright_text'], 'post') ?>
						</div>
					<?php } ?>
				</footer>
			<?php } ?>
		</div>
		
		<?php wp_footer(); ?>

	</body>
</html>
