<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package softa
 */

global $softa_theme;

if(softa_styles()['logo_variant'] == 'default' || softa_styles()['logo_variant'] == 'logo1') {
	$logo_html = softa_styles()['logo_content'];
}
if(softa_styles()['logo_variant'] == 'logo2' && !empty(softa_styles()['logo2_content'])) {
	$logo_html = softa_styles()['logo2_content'];
}
if(softa_styles()['logo_variant'] == 'logo3' && !empty(softa_styles()['logo3_content'])) {
	$logo_html = softa_styles()['logo3_content'];
}
if(softa_styles()['logo_variant'] == 'logo4' && !empty(softa_styles()['logo4_content'])) {
	$logo_html = softa_styles()['logo4_content'];
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
	<head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<link rel="profile" href="http://gmpg.org/xfn/11">

		<?php wp_head(); ?>
	</head>

	<body <?php body_class(); ?>>
		<div id="all" class="site">
			<?php if(softa_styles()['preloader_show'] == '1') { ?>
				<div id="loader-wrapper">
					<?php if(isset(softa_styles()['preloader_img']['background-image']) && !empty(softa_styles()['preloader_img']['background-image'])) { ?>
						<div id="loader2"><img src="<?php echo softa_styles()['preloader_img']['background-image'] ?>"></div>
					<?php } else { ?>
						<div id="loader"></div>
					<?php } ?>
					<div class="loader-section section-left"></div>
					<div class="loader-section section-right"></div>
				</div>
			<?php } if(softa_styles()['header_style'] == 'logo_left' || softa_styles()['header_style'] == 'logo_center') { ?>
				<header class="site-header <?php echo esc_attr(softa_styles()['css_classes']) ?> main-row">
					<div class="<?php echo esc_attr(softa_styles()['header_container']) ?>">
						<div class="logo"><a href="<?php echo esc_url(home_url('/')) ?>"><?php echo wp_kses($logo_html, 'post') ?></a></div>
						<div class="fr">
							<?php if(softa_styles()['navigation_type'] != 'disabled') { ?>
								<nav class="navigation <?php echo esc_attr(softa_styles()['navigation_type']) ?>"><?php wp_nav_menu( array( 'theme_location' => 'navigation', 'container' => 'ul', 'menu_class' => 'menu', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?></nav>
								<div class="butter-button nav-button <?php echo esc_attr(softa_styles()['navigation_type']) ?>">
									<div></div>
								</div>
							<?php } if(softa_styles()['header_button_show'] == '1' && !empty(softa_styles()['button_text']) && !empty(softa_styles()['button_link'])) { ?>
								<a href="<?php echo esc_url(softa_styles()['button_link']); ?>" class="button-style1"><?php echo esc_html(softa_styles()['button_text']); ?></a>
							<?php } if(softa_styles()['cart'] == 'yes' && class_exists( 'WooCommerce' )) { ?>
								<div class="header-minicart woocommerce header-minicart-softa">
									<?php global $woocommerce;
									$count = $woocommerce->cart->cart_contents_count;
									if($count == 0) { ?>
									<div class="hm-cunt"><i class="basic-ui-icon-shopping-cart"></i><span><?php echo esc_html($count) ?></span></div>
									<?php } else { ?>
									<a class="hm-cunt" href="<?php echo esc_url(wc_get_cart_url()) ?>"><i class="basic-ui-icon-shopping-cart"></i><span><?php echo esc_html($count) ?></span></a>
									<?php } ?>
									<div class="minicart-wrap">
										<?php woocommerce_mini_cart(); ?>
									</div>
								</div>
							<?php } if(softa_styles()['search'] == 'yes') { ?>
								<div class="search-button"><i class="basic-ui-icon-search"></i></div>
							<?php } ?>
						</div>
					</div>
				</header>
			<?php } else if(softa_styles()['header_style'] == 'logo_center') { ?>
				<header class="site-header <?php echo esc_attr(softa_styles()['css_classes']) ?> main-row">
					<div class="<?php echo esc_attr(softa_styles()['header_container']) ?>">
						<?php if(softa_styles()['cart'] == 'yes' && class_exists( 'WooCommerce' )) { ?>
							<div class="header-minicart fl woocommerce header-minicart-softa">
								<?php global $woocommerce;
								$count = $woocommerce->cart->cart_contents_count;
								if($count == 0) { ?>
								<div class="hm-cunt"><i class="basic-ui-icon-shopping-cart"></i><span><?php echo esc_html($count) ?></span></div>
								<?php } else { ?>
								<a class="hm-cunt" href="<?php echo esc_url(wc_get_cart_url()) ?>"><i class="basic-ui-icon-shopping-cart"></i><span><?php echo esc_html($count) ?></span></a>
								<?php } ?>
								<div class="minicart-wrap">
									<?php woocommerce_mini_cart(); ?>
								</div>
							</div>
						<?php } ?>
						<div class="logo"><a href="<?php echo esc_url(home_url('/')) ?>"><?php echo wp_kses(softa_styles()['logo_content'], 'post') ?></a></div>
						<div class="fr">
							<?php if(softa_styles()['navigation_type'] != 'disabled') { ?>
								<nav class="navigation <?php echo esc_attr(softa_styles()['navigation_type']) ?>"><?php wp_nav_menu( array( 'theme_location' => 'navigation', 'container' => 'ul', 'menu_class' => 'menu', 'link_before' => '<span>', 'link_after' => '</span>' ) ); ?></nav>
								<div class="butter-button nav-button <?php echo esc_attr(softa_styles()['navigation_type']) ?>">
									<div></div>
								</div>
							<?php } ?>
						</div>
					</div>
				</header>
			<?php } ?>
			<?php if(softa_styles()['header_space'] == 'yes') { ?>
				<div class="header-space"></div>
			<?php } else { ?>
				<div class="header-space hide"></div>
			<?php } if(softa_styles()['search'] == 'yes') { ?>
				<div class="search-popup main-row">
					<div class="close basic-ui-icon-cancel"></div>
					<div class="centered-container"><?php get_search_form(); ?></div>
				</div>
			<?php } if(softa_styles()['navigation_type']) { ?>
				<nav class="full-screen-nav main-row">
					<div class="close basic-ui-icon-cancel"></div>
					<div class="fsn-container">
						<?php wp_nav_menu( array( 'theme_location' => 'navigation', 'container' => 'ul', 'menu_class' => 'cell' ) ); ?>
					</div>
				</nav>
			<?php } 