<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Softa
 */

/*
Template Name: Coming soon page
*/

get_header(); 
$id = uniqid('countdown-');

if(get_field('date')) {
	$year = mysql2date('Y', get_field('date'));
	$month = mysql2date('m', get_field('date'))-1;
	$day = mysql2date('j', get_field('date'));
	$hour = mysql2date('H', get_field('date'));
	$minutes = mysql2date('i', get_field('date'));

	wp_enqueue_script( 'countdown', get_template_directory_uri() . '/js/jquery.countdown.js' );
	wp_enqueue_script( 'softa-script', get_template_directory_uri() . '/js/script.js' );

	wp_add_inline_script('softa-script', "jQuery(document).ready(function(jQuery) {
	  	/*------------------------------------------------------------------
		[ Coming soon countdown ]
		*/

		var ts = new Date(".$year.", ".$month.", ".$day.", ".$hour.", ".$minutes.");

		if(jQuery('.".esc_html($id)."').length > 0){
			jQuery('.".esc_html($id)."').countdown({
				timestamp	: ts,
				callback	: function(days, hours, minutes, seconds){
				}
			});
		}
	});");
}
?>

<section class="main-row">
	<div class="container-fluid no-padding">
		<!-- Banner -->
		<div class="banner-area">
			<div class="banner banner-coming-soon white">
				<div class="item tac" style="<?php echo softa_styles()['coming_soon_bg'] ?>">
				<div class="container">
					<div class="cell middle">
						<h1 class="b-coming-heading"><?php echo wp_kses_post(softa_styles()['coming_soon_heading']) ?></h1>
						<?php if(softa_styles()['coming_soon_subscribe_code']) { ?>
							<div class="text"><?php echo wp_kses_post(softa_styles()['coming_soon_text']) ?></div>
							<div class="tac"><?php echo do_shortcode(softa_styles()['coming_soon_subscribe_code']) ?></div>
						<?php } ?>
						<?php if(get_field('date')) { ?>
							<div id="countdown" class="<?php echo esc_attr($id) ?> medium"></div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<!-- END Banner -->
	</div>
</section>
<?php get_footer('empty');
