<?php

if (!class_exists('Redux')) {
  return;
}

$opt_name = "softa_theme";
$opt_name = apply_filters('softa_theme/opt_name', $opt_name);

$theme = wp_get_theme();

$args = array(
  'opt_name' => $opt_name,
  'display_name' => $theme->get('Name'),
  'display_version' => $theme->get('Version'),
  'menu_type' => 'submenu',
  'allow_sub_menu' => true,
  'menu_title' => esc_html__('Theme Options', 'softa'),
  'page_title' => esc_html__('Theme Options', 'softa'),
  'google_api_key' => '',
  'google_update_weekly' => false,
  'async_typography' => true,
  'admin_bar' => false,
  'admin_bar_icon' => 'dashicons-portfolio',
  'admin_bar_priority' => 50,
  'global_variable' => '',
  'dev_mode' => false,
  'update_notice' => true,
  'customizer' => true,
  'page_priority' => null,
  'page_parent' => 'softa_dashboard',
  'page_permissions' => 'manage_options',
  'menu_icon' => '',
  'last_tab' => '',
  'page_icon' => 'icon-themes',
  'page_slug' => '',
  'save_defaults' => true,
  'default_show' => false,
  'default_mark' => '',
  'show_import_export' => true,
  'transient_time' => 60 * MINUTE_IN_SECONDS,
  'output' => true,
  'output_tag' => true,
  'database' => '',
  'use_cdn' => true,
  'show_options_object' => false,
);

Redux::setArgs($opt_name, $args);

Redux::setSection($opt_name, array(
  'title' => esc_html__('General', 'softa'),
  'id' => 'general',
  'customizer_width' => '400px',
  'icon' => 'fa fa-home',
  'fields' => array(
    array(
      'id' => 'right_click_disable',
      'type' => 'switch',
      'title' => esc_html__('Right click disable', 'softa'),
      'default' => false,
    ),
    array(
      'id' => 'right_click_disable_message',
      'type' => 'editor',
      'title' => esc_html__('Right click Message', 'softa'),
      'default' => __('<p style="text-align: center"><strong><span style="font-size: 18px">Content is protected. Right-click function is disabled.</span></strong></p>', 'softa'),
      'args' => array(
        'teeny' => false,
        'textarea_rows' => 5,
      ),
      'required' => array('right_click_disable', '=', 1),
    ),
    array(
      'id' => 'protected_message',
      'type' => 'editor',
      'title' => esc_html__('Protected Page Message', 'softa'),
      'default' => esc_html__('This content is password protected. To view it please enter your password below:', 'softa'),
      'args' => array(
        'teeny' => false,
        'textarea_rows' => 5,
      ),
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Preloader', 'softa'),
  'id' => 'general_preloader',
  'customizer_width' => '450px',
  'subsection' => true,
  'icon' => 'fa fa-spinner',
  'fields' => array(
    array(
      'id' => 'preloader_show',
      'type' => 'switch',
      'title' => esc_html__('Preloader', 'softa'),
      'default' => true,
    ),
    array(
      'id' => 'preloader_img',
      'type' => 'background',
      'title' => esc_html__('Preloader img', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Header', 'softa'),
  'id' => 'header',
  'customizer_width' => '400px',
  'icon' => 'fa fa-header',
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Logo', 'softa'),
  'id' => 'header_logo',
  'customizer_width' => '450px',
  'subsection' => true,
  'icon' => 'fa fa-flag',
  'fields' => array(
    array(
      'id' => 'logo_text',
      'type' => 'text',
      'title' => esc_html__('Logo text', 'softa'),
    ),
    array(
      'id' => 'default_logo',
      'type' => 'background',
      'title' => esc_html__('Logo Image - normal', 'softa'),
      'desc' => esc_html__('Choose a default logo image to display', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'light_logo',
      'type' => 'background',
      'title' => esc_html__('Logo Image - light', 'softa'),
      'desc' => esc_html__('Choose a logo image to display for "Light" header skin', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'dark_logo',
      'type' => 'background',
      'title' => esc_html__('Logo Image - Dark', 'softa'),
      'desc' => esc_html__('Choose a logo image to display for "Dark" header skin', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'light2_logo',
      'type' => 'background',
      'title' => esc_html__('Logo Image 2 - light', 'softa'),
      'desc' => esc_html__('Choose a logo image to display for "Light" header skin', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'dark2_logo',
      'type' => 'background',
      'title' => esc_html__('Logo Image 2 - Dark', 'softa'),
      'desc' => esc_html__('Choose a logo image to display for "Dark" header skin', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'light3_logo',
      'type' => 'background',
      'title' => esc_html__('Logo Image 3 - light', 'softa'),
      'desc' => esc_html__('Choose a logo image to display for "Light" header skin', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'dark3_logo',
      'type' => 'background',
      'title' => esc_html__('Logo Image 3 - Dark', 'softa'),
      'desc' => esc_html__('Choose a logo image to display for "Dark" header skin', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'light4_logo',
      'type' => 'background',
      'title' => esc_html__('Logo Image 3 - light', 'softa'),
      'desc' => esc_html__('Choose a logo image to display for "Light" header skin', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'dark4_logo',
      'type' => 'background',
      'title' => esc_html__('Logo Image 3 - Dark', 'softa'),
      'desc' => esc_html__('Choose a logo image to display for "Dark" header skin', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'logo_size',
      'units' => 'px',
      'type' => 'dimensions',
      'units_extended' => 'false',
      'title' => esc_html__('Logo max width', 'softa'),
      'output' => array('.site-header .logo img, .side-header .logo img, .site-header .logo a, .side-header .logo a'),
      'height' => true,
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Header style', 'softa'),
  'id' => 'header_style',
  'customizer_width' => '450px',
  'subsection' => true,
  'icon' => 'fa fa-sliders',
  'fields' => array(
    array(
      'id' => 'header_style',
      'type' => 'image_select',
      'title' => esc_html__('Header style', 'softa'),
      'options' => array(
        'logo_left' => array(
          'alt' => 'Logo left',
          'img' => get_template_directory_uri() . '/theme-settings/imgs/header-style1.png',
        ),
        'logo_center' => array(
          'alt' => 'Logo center',
          'img' => get_template_directory_uri() . '/theme-settings/imgs/header-style2.png',
        ),
      ),
      'default' => 'logo_left',
    ),
    array(
      'id' => 'header_container',
      'type' => 'select',
      'title' => esc_html__('Header container', 'softa'),
      'options' => array(
        'container' => esc_html__('Center container', 'softa'),
        'container-fluid' => esc_html__('Full witdh', 'softa'),
      ),
      'default' => 'container-fluid',
    ),
    array(
      'id' => 'header_color_mode',
      'type' => 'select',
      'title' => esc_html__('Header color mode', 'softa'),
      'options' => array(
        'dark' => esc_html__('Dark', 'softa'),
        'light' => esc_html__('Light', 'softa'),
      ),
      'default' => 'light',
    ),
    array(
      'id' => 'header_bg_color',
      'type' => 'color',
      'title' => esc_html__('Header Background Color', 'softa'),
      'validate' => 'color',
      'transparent' => false,
      'output' => array('background-color' => '.site-header'),
    ),
    array(
      'id' => 'header_text_color',
      'type' => 'color',
      'title' => esc_html__('Header Text Color', 'softa'),
      'validate' => 'color',
      'transparent' => false,
      'output' => array('color' => '.site-header'),
    ),
    array(
      'id' => 'show_search',
      'type' => 'switch',
      'title' => esc_html__('Search', 'softa'),
      'default' => true,
    ),
    array(
      'id' => 'show_cart',
      'type' => 'switch',
      'title' => esc_html__('Cart', 'softa'),
      'default' => true,
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Header button', 'softa'),
  'id' => 'header_button',
  'customizer_width' => '450px',
  'subsection' => true,
  'icon' => 'fa fa-hand-pointer-o',
  'fields' => array(
    array(
      'id' => 'header_button_show',
      'type' => 'switch',
      'title' => esc_html__('Button', 'softa'),
      'default' => true,
    ),
    array(
      'id' => 'button_text',
      'type' => 'text',
      'title' => esc_html__('Button text', 'softa'),
      'required' => array('header_button_show', '=', 1),
    ),
    array(
      'id' => 'button_link',
      'type' => 'text',
      'title' => esc_html__('Button link', 'softa'),
      'required' => array('header_button_show', '=', 1),
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Navigation', 'softa'),
  'id' => 'header_navigation',
  'customizer_width' => '450px',
  'subsection' => true,
  'icon' => 'fa fa-bars',
  'fields' => array(
    array(
      'id' => 'navigation_type',
      'type' => 'select',
      'title' => esc_html__('Navigation type', 'softa'),
      'options' => array(
        'disabled' => esc_html__('Disabled', 'softa'),
        'hidden_menu' => esc_html__('Hidden menu', 'softa'),
        'visible_menu' => esc_html__('Visible menu', 'softa'),
        'full_screen' => esc_html__('Full screen menu', 'softa'),
      ),
      'default' => 'visible_menu',
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Typography', 'softa'),
  'id' => 'typography',
  'customizer_width' => '400px',
  'icon' => 'fa fa-font',
  'fields' => array(
    array(
			'id' => 'body-font-face',
			'type' => 'yprm_typography',
			'title' => esc_html__('Body', 'softa'),
			'output' => array('body'),
			'default' => array(
				'weight' => 'regular',
        'family' => 'Montserrat',
        'color' => '#161616',
				'font-size' => '16px',
				'backup-family' => 'Arial, Helvetica, sans-serif'
			),
		),
		array(
			'id' => 'h1-font-face',
			'type' => 'yprm_typography',
			'title' => esc_html__('H1', 'softa'),
			'output' => array('h1, .h1'),
			'default' => array(
				'weight' => '200',
				'family' => 'Montserrat',
				'font-size' => '60px',
				'backup-family' => 'Arial, Helvetica, sans-serif'
			),
		),
		array(
			'id' => 'h2-font-face',
			'type' => 'yprm_typography',
			'title' => esc_html__('H2', 'softa'),
			'output' => array('h2, .h2'),
			'default' => array(
				'weight' => '200',
				'family' => 'Montserrat',
				'font-size' => '48px',
				'backup-family' => 'Arial, Helvetica, sans-serif'
			),
		),
		array(
			'id' => 'h3-font-face',
			'type' => 'yprm_typography',
			'title' => esc_html__('H3', 'softa'),
			'output' => array('h3, .h3'),
			'default' => array(
				'weight' => '200',
				'family' => 'Montserrat',
				'font-size' => '36px',
				'backup-family' => 'Arial, Helvetica, sans-serif'
			),
		),
		array(
			'id' => 'h4-font-face',
			'type' => 'yprm_typography',
			'title' => esc_html__('H4', 'softa'),
			'output' => array('h4, .h4'),
			'default' => array(
				'weight' => '200',
				'family' => 'Montserrat',
				'font-size' => '30px',
				'backup-family' => 'Arial, Helvetica, sans-serif'
			),
		),
		array(
			'id' => 'h5-font-face',
			'type' => 'yprm_typography',
			'title' => esc_html__('H5', 'softa'),
			'output' => array('h5, .h5'),
			'default' => array(
				'weight' => '200',
				'family' => 'Montserrat',
				'font-size' => '24px',
				'backup-family' => 'Arial, Helvetica, sans-serif'
			),
		),
		array(
			'id' => 'h6-font-face',
			'type' => 'yprm_typography',
			'title' => esc_html__('H6', 'softa'),
			'output' => array('h6, .h6'),
			'default' => array(
				'weight' => '200',
				'family' => 'Montserrat',
				'font-size' => '18px',
				'backup-family' => 'Arial, Helvetica, sans-serif'
			),
    ),
  ),
));

Redux::setSection($opt_name, array(
	'title' => esc_html__('Theme Fonts', 'softa'),
	'id' => 'theme_fonts',
	'icon' => 'fa fa-i-cursor',
));

Redux::setSection($opt_name, array(
	'title' => esc_html__('Fonts', 'softa'),
	'id' => 'theme_fonts_array',
	'subsection' => true,
	'fields' => array(
		array(
			'id' => 'custom_fonts',
			'type' => 'yprm_fonts',
			'default' => array(
				'fonts' => '{"type":"google","family":"Montserrat","variants":"100, 100italic, 200, 200italic, 300, 300italic, regular, italic, 500, 500italic, 600, 600italic, 700, 700italic, 800, 800italic, 900, 900italic","subsets":"cyrillic, cyrillic-ext, latin, latin-ext, vietnamese"}',
			),
		),
	),
));

Redux::setSection($opt_name, array(
	'title' => esc_html__('Icon Fonts', 'softa'),
	'id' => 'theme_icon_fonts_array',
	'subsection' => true,
	'fields' => array(
		array(
			'id' => 'icon_fonts',
			'type' => 'yprm_icon_fonts',
			'title' => esc_html__('Upload Custom Icon Fonts', 'softa'),
		),
	),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Social buttons', 'softa'),
  'id' => 'social_buttons',
  'customizer_width' => '400px',
  'icon' => 'fa fa-twitter',
  'fields' => array(
    array(
      'id' => 'social_target',
      'type' => 'select',
      'title' => esc_html__('Open link in', 'softa'),
      'options' => array(
        '_self' => esc_html__('Current Tab', 'softa'),
        '_blank' => esc_html__('New Tab', 'softa'),
      ),
    ),
    array(
      'id' => 'facebook_link',
      'type' => 'text',
      'title' => esc_html__('Facebook link', 'softa'),
    ),
    array(
      'id' => 'twitter_link',
      'type' => 'text',
      'title' => esc_html__('Twitter link', 'softa'),
    ),
    array(
      'id' => 'instagram_link',
      'type' => 'text',
      'title' => esc_html__('Instagram link', 'softa'),
    ),
    array(
      'id' => 'youtube_link',
      'type' => 'text',
      'title' => esc_html__('Youtube link', 'softa'),
    ),
    array(
      'id' => 'gp_link',
      'type' => 'text',
      'title' => esc_html__('Google Plus link', 'softa'),
    ),
    array(
      'id' => 'linkedin_link',
      'type' => 'text',
      'title' => esc_html__('LinkedIn link', 'softa'),
    ),
    array(
      'id' => 'skype_link',
      'type' => 'text',
      'title' => esc_html__('Skype link', 'softa'),
    ),
    array(
      'id' => 'telegram_link',
      'type' => 'text',
      'title' => esc_html__('Telegram link', 'softa'),
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Footer', 'softa'),
  'id' => 'footer',
  'customizer_width' => '400px',
  'icon' => 'fa fa-th-list',
  'fields' => array(
    array(
      'id' => 'footer',
      'type' => 'select',
      'title' => esc_html__('Footer', 'softa'),
      'options' => array(
        'show' => esc_html__('Show', 'softa'),
        'hide' => esc_html__('Hide', 'softa'),
      ),
      'default' => 'show',
    ),
    array(
      'id' => 'copyright_text',
      'type' => 'text',
      'title' => esc_html__('Copyright text', 'softa'),
    ),
    array(
      'id' => 'footer_bg_color',
      'type' => 'color',
      'title' => esc_html__('Footer Background Color', 'softa'),
      'validate' => 'color',
      'transparent' => false,
      'output' => array('background-color' => '.site-footer'),
    ),
    array(
      'id' => 'footer_text_color',
      'type' => 'color',
      'title' => esc_html__('Footer Text Color', 'softa'),
      'validate' => 'color',
      'transparent' => false,
      'output' => array('color' => '.site-footer'),
    ),
    array(
      'id' => 'footer_col_1',
      'type' => 'select',
      'title' => esc_html__('Footer col 1', 'softa'),
      'options' => array(
        '1' => 'Col 1',
        '2' => 'Col 2',
        '3' => 'Col 3',
        '4' => 'Col 4',
        '5' => 'Col 5',
        '6' => 'Col 6',
        '7' => 'Col 7',
        '8' => 'Col 8',
        '9' => 'Col 9',
        '10' => 'Col 10',
        '11' => 'Col 11',
        '12' => 'Col 12',
      ),
      'default' => '3',
    ),
    array(
      'id' => 'footer_col_2',
      'type' => 'select',
      'title' => esc_html__('Footer col 2', 'softa'),
      'options' => array(
        '1' => 'Col 1',
        '2' => 'Col 2',
        '3' => 'Col 3',
        '4' => 'Col 4',
        '5' => 'Col 5',
        '6' => 'Col 6',
        '7' => 'Col 7',
        '8' => 'Col 8',
        '9' => 'Col 9',
        '10' => 'Col 10',
        '11' => 'Col 11',
        '12' => 'Col 12',
      ),
      'default' => '3',
    ),
    array(
      'id' => 'footer_col_3',
      'type' => 'select',
      'title' => esc_html__('Footer col 3', 'softa'),
      'options' => array(
        '1' => 'Col 1',
        '2' => 'Col 2',
        '3' => 'Col 3',
        '4' => 'Col 4',
        '5' => 'Col 5',
        '6' => 'Col 6',
        '7' => 'Col 7',
        '8' => 'Col 8',
        '9' => 'Col 9',
        '10' => 'Col 10',
        '11' => 'Col 11',
        '12' => 'Col 12',
      ),
      'default' => '3',
    ),
    array(
      'id' => 'footer_col_4',
      'type' => 'select',
      'title' => esc_html__('Footer col 4', 'softa'),
      'options' => array(
        '1' => 'Col 1',
        '2' => 'Col 2',
        '3' => 'Col 3',
        '4' => 'Col 4',
        '5' => 'Col 5',
        '6' => 'Col 6',
        '7' => 'Col 7',
        '8' => 'Col 8',
        '9' => 'Col 9',
        '10' => 'Col 10',
        '11' => 'Col 11',
        '12' => 'Col 12',
      ),
      'default' => '3',
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Footer top', 'softa'),
  'id' => 'footer_top',
  'customizer_width' => '450px',
  'subsection' => true,
  'icon' => 'fa fa-flag',
  'fields' => array(
    array(
      'id' => 'show_footer_top',
      'type' => 'switch',
      'title' => esc_html__('Footer top', 'softa'),
      'default' => true,
    ),
    array(
      'id' => 'show_subcribe_form',
      'type' => 'switch',
      'title' => esc_html__('Subscribe form', 'softa'),
      'default' => true,
      'required' => array('show_footer_top', '=', 1),
    ),
    array(
      'id' => 'subcribe_code',
      'type' => 'text',
      'title' => esc_html__('Subscribe form shortcode', 'softa'),
      'required' => array('show_subcribe_form', '=', 1),
    ),
    array(
      'id' => 'show_social_buttons',
      'type' => 'switch',
      'title' => esc_html__('Social buttons', 'softa'),
      'default' => true,
      'required' => array('show_footer_top', '=', 1),
    ),
    array(
      'id' => 'show_search_form',
      'type' => 'switch',
      'title' => esc_html__('Search form', 'softa'),
      'default' => true,
      'required' => array('show_footer_top', '=', 1),
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('404 Page', 'softa'),
  'id' => '404_page',
  'customizer_width' => '400px',
  'icon' => 'fa fa-exclamation-circle',
  'fields' => array(
    array(
      'id' => '404_bg',
      'type' => 'background',
      'title' => esc_html__('Background image', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => '404_page_color',
      'type' => 'color',
      'title' => esc_html__('Text color', 'softa'),
      'validate' => 'color',
      'transparent' => false,
      'output' => array('color' => '.banner-404'),
    ),
    array(
      'id' => '404_page_heading_color',
      'type' => 'color',
      'title' => esc_html__('Heading color', 'softa'),
      'validate' => 'color',
      'transparent' => false,
      'output' => array('color' => '.banner-404 .b-404-heading'),
    ),
    array(
      'id' => '404_heading',
      'type' => 'textarea',
      'title' => esc_html__('Heading', 'softa'),
      'default' => esc_html__('404 error', 'softa'),
    ),
    array(
      'id' => '404_text',
      'type' => 'textarea',
      'title' => esc_html__('Text', 'softa'),
      'default' => esc_html__('You are on a non-existing page', 'softa'),
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Coming soon page', 'softa'),
  'id' => 'coming_soon',
  'customizer_width' => '400px',
  'icon' => 'fa fa-clock-o',
  'fields' => array(
    array(
      'id' => 'coming_soon_bg',
      'type' => 'background',
      'title' => esc_html__('Background image', 'softa'),
      'background-attachment' => false,
      'background-position' => false,
      'background-repeat' => false,
      'background-origin' => false,
      'background-color' => false,
      'background-size' => false,
      'background-clip' => false,
      'preview_media' => true,
      'preview' => false,
    ),
    array(
      'id' => 'coming_soon_color',
      'type' => 'color',
      'title' => esc_html__('Text color', 'softa'),
      'validate' => 'color',
      'transparent' => false,
      'output' => array('color' => '.banner-coming-soon'),
    ),
    array(
      'id' => 'coming_soon_heading_color',
      'type' => 'color',
      'title' => esc_html__('Heading color', 'softa'),
      'validate' => 'color',
      'transparent' => false,
      'output' => array('color' => '.banner-coming-soon .b-coming-heading'),
    ),
    array(
      'id' => 'coming_soon_subscribe_code',
      'type' => 'text',
      'title' => esc_html__('Subscribe form code', 'softa'),
    ),
    array(
      'id' => 'coming_soon_heading',
      'type' => 'textarea',
      'title' => esc_html__('Heading', 'softa'),
      'default' => esc_html__('Coming Soon', 'softa'),
    ),
    array(
      'id' => 'coming_soon_text',
      'type' => 'textarea',
      'title' => esc_html__('Text', 'softa'),
      'default' => esc_html__('Subscribe and get the latest updates', 'softa'),
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Project page', 'softa'),
  'id' => 'project_page',
  'customizer_width' => '400px',
  'icon' => 'fa fa-file-text',
  'fields' => array(
    array(
      'id' => 'project_style',
      'type' => 'select',
      'title' => esc_html__('Style project page', 'softa'),
      'options' => array(
        'slider' => esc_html__('Slider', 'softa'),
        'masonry' => esc_html__('Masonry', 'softa'),
      ),
      'default' => 'slider',
    ),
    array(
      'id' => 'project_image',
      'type' => 'select',
      'title' => esc_html__('Project image', 'softa'),
      'options' => array(
        'hide' => esc_html__('Hide', 'softa'),
        'full' => esc_html__('Full', 'softa'),
        'adaptive' => esc_html__('Adaptive', 'softa'),
      ),
      'default' => 'full',
    ),
    array(
      'id' => 'project_date',
      'type' => 'select',
      'title' => esc_html__('Show date', 'softa'),
      'options' => array(
        'show' => esc_html__('Show', 'softa'),
        'hide' => esc_html__('Hide', 'softa'),
      ),
      'default' => 'show',
    ),
    array(
      'id' => 'project_categories',
      'type' => 'select',
      'title' => esc_html__('Show categories', 'softa'),
      'options' => array(
        'show' => esc_html__('Show', 'softa'),
        'hide' => esc_html__('Hide', 'softa'),
      ),
      'default' => 'show',
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Blog post', 'softa'),
  'id' => 'blog_post',
  'customizer_width' => '400px',
  'icon' => 'fa fa-wordpress',
  'fields' => array(
    array(
      'id' => 'blog_feature_image',
      'type' => 'select',
      'title' => esc_html__('Blog feature image', 'softa'),
      'options' => array(
        'hide' => esc_html__('Hide', 'softa'),
        'show' => esc_html__('Show', 'softa'),
      ),
      'default' => 'show',
    ),
    array(
      'id' => 'blog_date',
      'type' => 'select',
      'title' => esc_html__('Show date', 'softa'),
      'options' => array(
        'show' => esc_html__('Show', 'softa'),
        'hide' => esc_html__('Hide', 'softa'),
      ),
      'default' => 'show',
    ),
    array(
      'id' => 'blog_categories',
      'type' => 'select',
      'title' => esc_html__('Show categories', 'softa'),
      'options' => array(
        'show' => esc_html__('Show', 'softa'),
        'hide' => esc_html__('Hide', 'softa'),
      ),
      'default' => 'show',
    ),
  ),
));

Redux::setSection($opt_name, array(
  'title' => esc_html__('Custom code & analytics & Map API', 'softa'),
  'id' => 'custom_code_analytics',
  'customizer_width' => '400px',
  'icon' => 'fa fa-code',
  'fields' => array(
    array(
      'id' => 'code_in_head',
      'type' => 'ace_editor',
      'title' => esc_html__('Code in <head>', 'softa'),
    ),
    array(
      'id' => 'code_before_body',
      'type' => 'ace_editor',
      'title' => esc_html__('Code before </body> tag', 'softa'),
    ),
    array(
      'id' => 'google_maps_api_key',
      'type' => 'text',
      'title' => esc_html__('Google Map API Key', 'softa'),
      'description' => __('Create an application in <a href="https://console.developers.google.com/flows/enableapi?apiid=places_backend,maps_backend,geocoding_backend,directions_backend,distance_matrix_backend,elevation_backend&keyType=CLIENT_SIDE&reusekey=true" target="_blank">Google Console</a> and add the Key here.', 'softa'),
    ),
  ),
));