<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $source
 * @var $text
 * @var $link
 * @var $google_fonts
 * @var $font_container
 * @var $el_class
 * @var $el_id
 * @var $css
 * @var $css_animation
 * @var $font_container_data - returned from $this->getAttributes
 * @var $google_fonts_data - returned from $this->getAttributes
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Custom_heading
 */
$source = $text = $link = $google_fonts = $font_container = $el_id = $el_class = $css = $css_animation = $font_container_data = $google_fonts_data = array();
// This is needed to extract $font_container_data and $google_fonts_data
extract( $this->getAttributes( $atts ) );

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

/**
 * @var $css_class
 */
extract( $this->getStyles( $el_class . $this->getCSSAnimation( $css_animation ), $css, $google_fonts_data, $font_container_data, $atts ) );

$settings = get_option( 'wpb_js_google_fonts_subsets' );
if ( is_array( $settings ) && ! empty( $settings ) ) {
	$subsets = '&subset=' . implode( ',', $settings );
} else {
	$subsets = '';
}

if ( ( ! isset( $atts['use_theme_fonts'] ) || 'yes' !== $atts['use_theme_fonts'] ) && isset( $google_fonts_data['values']['font_family'] ) ) {
	wp_enqueue_style( 'vc_google_fonts_' . vc_build_safe_css_class( $google_fonts_data['values']['font_family'] ), '//fonts.googleapis.com/css?family=' . $google_fonts_data['values']['font_family'] . $subsets );
}

if ( ! empty( $styles ) ) {
	$style = 'style="' . esc_attr( implode( ';', $styles ) ) . '"';
} else {
	$style = '';
}

if ( 'post_title' === $source ) {
	$text = get_the_title( get_the_ID() );
}

if ( ! empty( $link ) ) {
	$link = vc_build_link( $link );
	$text = '<a href="' . esc_attr( $link['url'] ) . '"' . ( $link['target'] ? ' target="' . esc_attr( $link['target'] ) . '"' : '' ) . ( $link['rel'] ? ' rel="' . esc_attr( $link['rel'] ) . '"' : '' ) . ( $link['title'] ? ' title="' . esc_attr( $link['title'] ) . '"' : '' ) . '>' . $text . '</a>';
}
$wrapper_attributes = array();
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
$output = '';

if(count(explode('|', $atts['font_container'])) > 0) {
	$settings = array();
	foreach (explode('|', $atts['font_container']) as $item) {
		$settings[explode(':', $item)[0]] = explode(':', $item)[1];
	}
}

if($settings['text_align'] == "left") {
	$ta = "tal ";
} elseif($settings['text_align'] == "right") {
	$ta = "tar ";
} elseif($settings['text_align'] == "center") {
	$ta = "tac ";
} elseif($settings['text_align'] == "justify") {
	$ta = "taj ";
} else {
	$ta = "tal ";
}

$ta .= $item_id = 'heading-decor-'.uniqid();

if(isset($decor_line_style) && $decor_line_style == 'style2') {
	$ta .= ' style2';
}

$custom_css = "";
if(!empty($decor_line_bg_color) || !empty($decor_line_bg_gradient)) {
	$custom_css .= '.'.$item_id.' .h:after {';
	if(!empty($decor_line_bg_color)) {
		$custom_css .= 'background: '.$decor_line_bg_color.';';
	}
	if(!empty($decor_line_bg_gradient)) {
		$decor_line_bg_gradient = strip_tags(explode("||", $decor_line_bg_gradient)[1]);
		$custom_css .= $decor_line_bg_gradient;
	}
	$custom_css .= '}';
}

wp_enqueue_style('softa-custom-style', get_template_directory_uri() . '/css/custom_script.css');
wp_add_inline_style( 'softa-custom-style', $custom_css );

if($atts['decor_line'] == "on") {
	$output .= '<div class="heading-decor-s '.esc_attr($ta).'">';
}
if ( apply_filters( 'vc_custom_heading_template_use_wrapper', false ) ) {
	$output .= '<div class="' . esc_attr( $css_class ) . '" ' . implode( ' ', $wrapper_attributes ) . '>';
	$output .= '<' . $font_container_data['values']['tag'] . ' ' . $style . ' class="h" >';
	$output .= '<span>'.$text.'</span>';
	$output .= '</' . $font_container_data['values']['tag'] . '>';
	$output .= '</div>';
} else {
	$output .= '<' . $font_container_data['values']['tag'] . ' ' . $style . ' class="h ' . esc_attr( $css_class ) . '" ' . implode( ' ', $wrapper_attributes ) . '>';
	$output .= '<span>'.$text.'</span>';
	$output .= '</' . $font_container_data['values']['tag'] . '>';
}
if($atts['decor_line'] == "on") {
	$output .= '</div>';
}

echo $output;
