(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/razox-nav-menu-vertical.default', ($element) => {
            var menuItems = $element.find("ul li.menu-item-has-children");
            menuItems.each(function () {
                var dropdownItems = $(this).find(" > ul"),
                    menuItem = this,
                    anchor = $(this).find("> a"),
                    animationSpeed = "fast";
                anchor.on("click tap", function (e) {
                    e.preventDefault();
                    e.stopPropagation();

                    if (dropdownItems.is(":visible")) {
                        $(menuItem).removeClass("razox-menu-item--open");
                        dropdownItems.fadeOut(animationSpeed);
                    } else {
                        if (anchor.parent().parent().children().hasClass("razox-menu-item--open") &&
                            anchor.parent().parent().parent().hasClass("vertical-menu")) {
                            $(this).parent().parent().children().removeClass("razox-menu-item--open");
                            $(this).parent().parent().children().find(" > ul").fadeOut(animationSpeed);
                        } else {
                            if (!$(this).parents("li").hasClass("razox-menu-item--open")) {
                                menuItems.removeClass("razox-menu-item--open");
                                menuItems.find(" > .qodef-drop-down-second, > ul").fadeOut(animationSpeed);
                            }

                            if (anchor.parent().parent().children().hasClass("razox-menu-item--open")) {
                                $(this).parent().parent().children().removeClass("razox-menu-item--open");
                                $(this).parent().parent().children().find(" > ul").fadeOut(animationSpeed);
                            }
                        }

                        $(menuItem).addClass("razox-menu-item--open");
                        dropdownItems.fadeIn("slow");
                    }
                });
            });
        });
    });
})(jQuery);