(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/razox-timeline.default', ($scope) => {
            // Timeline Scroll Section
            // --------------------------------------------------------------

            checkScreenSize();

            window.addEventListener('resize', checkScreenSize);

            function checkScreenSize() {
                var screenWidth = window.innerWidth;

                var items = $(".elementor-timeline-wrapper .item"),
                    timelineHeight = $(".elementor-timeline-wrapper").height(),
                    greyLine = $('.elementor-timeline-wrapper .default-line'),
                    lineToDraw = $('.elementor-timeline-wrapper .draw-line'),
                    wrapper = $('.elementor-timeline-wrapper');

                // sets the height that the greyLine (.default-line) should be according to `.timeline ul` height

                // run this function only if draw line exists on the page
                if (lineToDraw.length) {
                    $(window).on('scroll', function () {

                        // Need to constantly get '.draw-line' height to compare against '.default-line'
                        var redLineHeight = lineToDraw.height(),

                            windowDistance = $(window).scrollTop(),
                            windowHeight = $(window).height() / 2,
                            heightFirstDistance = items[0].offsetHeight,
                            greyLineHeight = wrapper.height(),
                            timelineDistance = $(".elementor-timeline-wrapper").offset().top;

                        greyLine.css({
                            'height': greyLineHeight + 'px',
                            'top' : '0px',
                        });
                        lineToDraw.css({
                            'max-height': greyLineHeight + 'px',
                            'top' : '0px',
                        });
                        if (windowDistance >= timelineDistance - windowHeight) {
                            let line = windowDistance - timelineDistance + windowHeight;

                            if (line <= greyLineHeight) {
                                lineToDraw.css({
                                    'height': line + 10 + 'px'
                                });
                            }
                        }

                        // This takes care of adding the class in-view to the li:before items
                        var bottom = lineToDraw.offset().top + lineToDraw.outerHeight(true);
                        items.each(function (index) {
                            var circlePosition = $(this).offset();

                            if (bottom > circlePosition.top) {
                                $(this).addClass('in-view');
                            } else {
                                $(this).removeClass('in-view');
                            }
                        });
                    });
                }
            }



        });
    });

})(jQuery);



