(function ($) {
    "use strict";
    $(window).on('elementor/frontend/init', () => {
        elementorFrontend.hooks.addAction('frontend/element_ready/razox-video-review.default', ($scope) => {
            $scope.find('.razox-video-review a.elementor-video-review').magnificPopup({
                type: 'iframe',
                removalDelay: 500,
                midClick: true,
                closeBtnInside: true,
                callbacks: {
                    beforeOpen: function () {
                        this.st.mainClass = this.st.el.attr('data-effect');
                    }
                },
            });

            var contentItems = document.querySelectorAll('.video_list_left .review-item-content');
            var videoItems = document.querySelectorAll('.video_list_right .review-item-video');

            contentItems.forEach(function(item, index) {
                item.addEventListener('click', function() {
                    // Xóa lớp active từ tất cả các content items
                    contentItems.forEach(function(contentItem) {
                        contentItem.classList.remove('active');
                    });

                    // Thêm hoặc xóa lớp active cho content item đang được click
                    if (!item.classList.contains('active')) {
                        item.classList.add('active');
                    } else {
                        item.classList.remove('active');
                    }

                    // Xóa lớp active từ tất cả các video items
                    videoItems.forEach(function(videoItem) {
                        videoItem.classList.remove('active');
                    });

                    // Thêm hoặc xóa lớp active cho video item tương ứng
                    videoItems[index].classList.toggle('active');
                });
            });
        });
    });
})(jQuery);
