(function ($) {
    'use strict';
    var $body = $('body');
    var xhr = false;

    function tooltip() {
        $('body').on('mouseenter', '.group-action .add_to_cart_tooltips:not(.tooltipstered), .group-action .woosw-btn:not(.tooltipstered), .group-action .woosq-btn:not(.tooltipstered), .group-action .woosc-btn:not(.tooltipstered)', function () {
            var $element = $(this);
            if (typeof $.fn.tooltipster !== 'undefined') {
                $element.tooltipster({
                    position: 'top', functionBefore: function (instance, helper) {
                        instance.content(instance._$origin.text());
                    }, theme: 'opal-product-tooltipster', delay: 0, animation: 'grow'
                }).tooltipster('show');
            }
        });
    }

    function product_hover_image() {
        $('body').on('click', '.product-block .product-color .item', function () {
            var image = $(this).data('image');
            var $product = $(this).closest('.product-block');
            var $image = $product.find('.product-image img');
            $image.attr('src', image.src);
            $image.attr('srcset', image.srcset);
            $image.attr('sizes', image.sizes);
            if ($(this).hasClass('active-swatch')) {
                return;
            }
            $(this).parent().find('.active-swatch').removeClass('active-swatch');
            $(this).addClass('active-swatch');
        });
    }

    function ajax_wishlist_count() {

        $(document).on('added_to_wishlist removed_from_wishlist', function () {
            var counter = $('.header-wishlist .count, .footer-wishlist .count, .header-wishlist .wishlist-count-item');
            $.ajax({
                url: yith_wcwl_l10n.ajax_url, data: {
                    action: 'yith_wcwl_update_wishlist_count'
                }, dataType: 'json', success: function (data) {
                    counter.html(data.count);
                    $('.wishlist-count-text').html(data.text);
                },
            });
        });

        $('body').on('woosw_change_count', function (event, count) {
            var counter = $('.header-wishlist .count, .footer-wishlist .count, .header-wishlist .wishlist-count-item');

            $.ajax({
                url: woosw_vars.ajax_url, data: {
                    action: 'woosw_ajax_update_count'
                }, dataType: 'json', success: function (data) {
                    $('.wishlist-count-text').html(data.text);
                },
            });
            counter.html(count);
        });
    }

    function woo_widget_categories() {
        var widget = $('.widget_product_categories'),
            main_ul = widget.find('ul');
        if (main_ul.length) {
            var dropdown_widget_nav = function () {

                main_ul.find('li').each(function () {

                    var main = $(this), link = main.find('> a'), ul = main.find('> ul.children');
                    if (ul.length) {

                        //init widget
                        // main.removeClass('opened').addClass('closed');

                        if (main.hasClass('closed')) {
                            ul.hide();

                            link.before('<i class="icon-plus"></i>');
                        } else if (main.hasClass('opened')) {
                            link.before('<i class="icon-minus"></i>');
                        } else {
                            main.addClass('opened');
                            link.before('<i class="icon-minus"></i>');
                        }

                        // on click
                        main.find('i').on('click', function (e) {

                            ul.slideToggle('slow');

                            if (main.hasClass('closed')) {
                                main.removeClass('closed').addClass('opened');
                                main.find('>i').removeClass('icon-plus').addClass('icon-minus');
                            } else {
                                main.removeClass('opened').addClass('closed');
                                main.find('>i').removeClass('icon-minus').addClass('icon-plus');
                            }

                            e.stopImmediatePropagation();
                        });

                        main.on('click', function (e) {

                            if ($(e.target).filter('a').length) return;

                            ul.slideToggle('slow');

                            if (main.hasClass('closed')) {
                                main.removeClass('closed').addClass('opened');
                                main.find('i').removeClass('icon-plus').addClass('icon-minus');
                            } else {
                                main.removeClass('opened').addClass('closed');
                                main.find('i').removeClass('icon-minus').addClass('icon-plus');
                            }

                            e.stopImmediatePropagation();
                        });
                    }
                });
            };
            dropdown_widget_nav();
        }
    }

    function orderbyselect() {
        $('.woocommerce-ordering select').change(function () {
            var text = $(this).find('option:selected').text();
            var $aux = $('<select/>').append($('<option/>').text(text));
            $(this).after($aux);
            $(this).width($aux.width());
            $aux.remove();
        }).change()
    }

    function sendRequest(url, append = false) {

        if (xhr) {
            xhr.abort();
        }

        xhr = $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                var $products = $('ul.razox-products');
                if (!append) {
                    $products.addClass('preloader');
                }
            },
            success: function (data) {
                let $html = $(data);
                if (append) {
                    $('#main ul.razox-products').append($html.find('#main ul.razox-products > li'));
                } else {
                    $('#main ul.razox-products').replaceWith($html.find('#main ul.razox-products'));
                }
                $('#main .woocommerce-pagination-wrap').replaceWith($html.find('#main .woocommerce-pagination-wrap'));
                window.history.pushState(null, null, url);
                xhr = false;
                $(document).trigger('razox-products-loaded');
            }
        });
    }

    $body.on('change', '.razox-products-per-page #per_page', function (e) {
        e.preventDefault();
        var url = this.value;
        sendRequest(url);
    });

    $body.on('click', '.products-load-more-btn', function (e) {
        e.preventDefault();
        $(this).addClass('loading');
        var url = $(this).attr('href');
        sendRequest(url, true);
    });

    function productsPaginationScroll() {
        if (typeof $.fn.waypoint == 'function') {
            var waypoint = $('.products-load-more-btn.load-on-scroll').waypoint(function () {
                $('.products-load-more-btn.load-on-scroll').trigger('click');
            }, {offset: '100%'});
        }
    }

    function woo_dropdown_sidebar() {

        $body.on('click', '.widget.razox-widget-woocommerce .widgettitle', function (e) {
            e.preventDefault();
            var $parent = $(this).closest('.razox-menu-filter');
            if ($parent.length) {

                if ($(this).hasClass('toggled-on')) {
                    $(this).removeClass('toggled-on')
                        .siblings('.widget-content').stop().slideUp()
                        .closest('.widget').removeClass('active');
                } else {
                    $parent.find('.toggled-on').removeClass('toggled-on');
                    $parent.find('.widget-content').stop().slideUp();
                    $parent.find('.widget').removeClass('active');

                    $(this).addClass('toggled-on')
                        .siblings('.widget-content').stop().slideDown()
                        .closest('.widget').addClass('active');
                }

            } else {

                $(this).toggleClass('toggled-on')
                    .siblings('.widget-content').stop().slideToggle()
                    .closest('.widget').toggleClass('active');
            }
        });
    }

    // TOOL TIP PRODUCT
    function tooltipProduct() {
        if ($(window).width() > 1023) {
            var w_tooltip = $("#global-tooltip").width();
            var h_tooltip = 0;
            var pad = 30;
            var x_mouse = 0;
            var y_mouse = 0;
            var wrap_left = 0;
            var wrap_right = 0;
            var wrap_top = 0;
            var wrap_bottom = 0;

            $(".product-block .product-transition").mousemove(function (e) {

                var content_tooltip = $(this).parents(".product-block").find(".p-tooltip");
                // var content_tooltip = $(this).find(".p-tooltip")
                if (content_tooltip.length == 0) {
                    return;
                    $("#global-tooltip").hide();
                }

                $("#global-tooltip").html(content_tooltip.html());

                wrap_left = 0;
                wrap_top = $(window).scrollTop();
                wrap_bottom = $(window).height();
                wrap_right = $(window).width();
                x_mouse = e.pageX;
                y_mouse = e.pageY;
                h_tooltip = $("#global-tooltip").height();

                if (x_mouse + w_tooltip > wrap_right)
                    $("#global-tooltip").css("left", x_mouse - w_tooltip - pad);
                else $("#global-tooltip").css("left", x_mouse + pad);

                if (y_mouse - h_tooltip < wrap_top && 1 < 2) {
                    $("#global-tooltip").css("top", wrap_top);
                } else {
                    $("#global-tooltip").css("top", y_mouse - h_tooltip - pad);
                }

                $("#global-tooltip").show();
            });

            $(".product-block .product-transition").mouseout(function () {
                $("#global-tooltip").hide();
            });
        }
    }

    $(document).ready(function () {
        woo_widget_categories();
    }).on('razox-products-loaded', function () {
        $('.products-load-more-btn').removeClass('loading');
        productsPaginationScroll();
    });

    woo_dropdown_sidebar();
    productsPaginationScroll();
    orderbyselect();
    product_hover_image();
    tooltipProduct();
    tooltip();
    ajax_wishlist_count();
    $(window).on('resize', function () {
        tooltipProduct();
    });

})(jQuery);
