<?php
$theme = wp_get_theme('razox');
define('RAZOX_VERSION', $theme['Version']);
define('RAZOX_SUFFIX', (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? "" : ".min");

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if (!isset($content_width)) {
    $content_width = 980; /* pixels */
}
require get_theme_file_path('inc/class-tgm-plugin-activation.php');
$razox = (object)array(
    'version' => RAZOX_VERSION,
    /**
     * Initialize all the things.
     */
    'main'    => require 'inc/class-main.php',
);
require get_theme_file_path('inc/functions.php');
require get_theme_file_path('inc/template-hooks.php');
require get_theme_file_path('inc/template-functions.php');

add_action('after_setup_theme', function () {
    require_once get_theme_file_path('inc/merlin/vendor/autoload.php');
    require_once get_theme_file_path('inc/merlin/class-merlin.php');
    require_once get_theme_file_path('inc/merlin-config.php');

    require_once get_theme_file_path('inc/merlin/includes/class-color-picker-in-category.php');
    require get_theme_file_path('inc/merlin/includes/class-custom-post-type.php');
    $files = glob(trailingslashit(get_template_directory()) . 'inc/merlin/includes/post-type/*.php');
    foreach ($files as $file) {
        require $file;
    }
    require get_theme_file_path('inc/merlin/includes/class-custom-post-type-setting.php');
});

require_once get_theme_file_path('inc/class-customize.php');

if (razox_is_woocommerce_activated()) {
    $razox->woocommerce = require get_theme_file_path('inc/woocommerce/class-woocommerce.php');

    require_once get_theme_file_path('inc/woocommerce/class-woocommerce-adjacent-products.php');
    require_once get_theme_file_path('inc/woocommerce/class-product-category-walker.php');
    require_once get_theme_file_path('inc/woocommerce/woocommerce-functions.php');
    require_once get_theme_file_path('inc/woocommerce/woocommerce-template-hooks.php');

    add_action('after_setup_theme', function () {
        require_once get_theme_file_path('inc/merlin/includes/product/class-woocommerce-settings.php');
    });

    require_once get_theme_file_path('inc/woocommerce/class-woocommerce-extra.php');

    require_once get_theme_file_path('inc/merlin/includes/product/class-wc-widget-product-brands.php');
    require_once get_theme_file_path('inc/merlin/includes/product/class-wc-product-360-view.php');
//    require_once get_theme_file_path('inc/merlin/includes/product/class-wc-product-labels.php');
}

if (razox_is_elementor_activated()) {
    require get_theme_file_path('inc/elementor/functions-elementor.php');
    $razox->elementor = require get_theme_file_path('inc/elementor/class-elementor.php');
    //====start_premium
    $razox->megamenu = require get_theme_file_path('inc/megamenu/megamenu.php');
    //====end_premium
    $razox->parallax      = require get_theme_file_path('inc/elementor/class-section-parallax.php');
    $razox->muntiparallax = require get_theme_file_path('inc/merlin/includes/class-parallax.php');

    if (defined('ELEMENTOR_PRO_VERSION')) {
        require get_theme_file_path('inc/elementor/functions-elementor-pro.php');
    }

    if (function_exists('hfe_init')) {
        require get_theme_file_path('inc/header-footer-elementor/class-hfe.php');
        require get_theme_file_path('inc/merlin/includes/breadcrumb.php');
        require get_theme_file_path('inc/merlin/includes/class-custom-shapes.php');
    }
    if (razox_is_woocommerce_activated()) {
        require_once get_theme_file_path('inc/elementor/elementor-control/class-elementor-control.php');
        require_once get_theme_file_path('inc/elementor/product_review/class-elementor-control.php');
    }
}


if (!is_user_logged_in()) {
    require get_theme_file_path('inc/modules/class-login.php');
}


/**
 * Plugin Name: Custom WooCommerce Attributes
 * Description: Disable HTML sanitization for WooCommerce product attributes.
 * Version: 1.0
 */

function disable_attribute_sanitization($value, $attribute) {
    // Check if the attribute is 'pa_custom_attribute' (replace with your attribute name).
    if ($attribute == 'pa_custom_attribute') {
        return $value;
    }
    return wp_kses_post($value);
}

add_filter('woocommerce_variation_option_name', 'disable_attribute_sanitization', 10, 2);