<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Razox_Customize')) {

    class Razox_Customize {


        public function __construct() {
            add_action('customize_register', array($this, 'customize_register'));
        }

        public function get_banner() {
            global $post;

            $options[''] = esc_html__('Select Banner', 'razox');
            if (!razox_is_elementor_activated()) {
                return;
            }
            $args = array(
                'post_type'      => 'elementor_library',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                's'              => 'Banner ',
                'order'          => 'ASC',
            );

            $query1 = new WP_Query($args);
            while ($query1->have_posts()) {
                $query1->the_post();
                $options[$post->post_name] = $post->post_title;
            }

            wp_reset_postdata();
            return $options;
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         */
        public function tesst($wp_customize) {
            $wp_customize->add_control(
                new WP_Customize_Image_Control(
                    $wp_customize,
                    'dav_bgImage',
                    array(
                        'label'    => esc_attr__('Background image', 'razox'),
                        'section'  => 'dav_display_options',
                        'settings' => 'dav_bgImage',
                        'priority' => 8
                    )
                )
            );
        }

        public function customize_register($wp_customize) {

            /**
             * Theme options.
             */
            require_once get_theme_file_path('inc/customize-control/editor.php');
            $this->init_razox_blog($wp_customize);
            $this->razox_register_theme_customizer($wp_customize);


            if (razox_is_woocommerce_activated()) {
                $this->init_woocommerce($wp_customize);
            }

            do_action('razox_customize_register', $wp_customize);
        }

        function razox_register_theme_customizer($wp_customize) {

        } // end razox_register_theme_customizer

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */
        public function init_razox_blog($wp_customize) {

            $wp_customize->add_panel('razox_blog', array(
                'title' => esc_html__('Blog', 'razox'),
            ));

            // =========================================
            // Blog Archive
            // =========================================
            $wp_customize->add_section('razox_blog_archive', array(
                'title'      => esc_html__('Archive', 'razox'),
                'panel'      => 'razox_blog',
                'capability' => 'edit_theme_options',
            ));

            $wp_customize->add_setting('razox_options_blog_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_blog_sidebar', array(
                'section' => 'razox_blog_archive',
                'label'   => esc_html__('Sidebar Position', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'none'  => esc_html__('None', 'razox'),
                    'left'  => esc_html__('Left', 'razox'),
                    'right' => esc_html__('Right', 'razox'),
                ),
            ));

            $wp_customize->add_setting('razox_options_blog_style', array(
                'type'              => 'option',
                'default'           => 'standard',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_blog_style', array(
                'section' => 'razox_blog_archive',
                'label'   => esc_html__('Blog style', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'standard' => esc_html__('Blog Standard', 'razox'),
                    'list'     => esc_html__('Blog List', 'razox'),
                    'style-1'  => esc_html__('Blog Grid', 'razox'),
                ),
            ));

            $wp_customize->add_setting('razox_options_blog_columns', array(
                'type'              => 'option',
                'default'           => 3,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_blog_columns', array(
                'section' => 'razox_blog_archive',
                'label'   => esc_html__('Colunms', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'razox'),
                    2 => esc_html__('2', 'razox'),
                    3 => esc_html__('3', 'razox'),
                    4 => esc_html__('4', 'razox'),
                ),
            ));

            $wp_customize->add_setting('razox_options_blog_columns_laptop', array(
                'type'              => 'option',
                'default'           => 3,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_blog_columns_laptop', array(
                'section' => 'razox_blog_archive',
                'label'   => esc_html__('Colunms Laptop', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'razox'),
                    2 => esc_html__('2', 'razox'),
                    3 => esc_html__('3', 'razox'),
                    4 => esc_html__('4', 'razox'),
                ),
            ));

            $wp_customize->add_setting('razox_options_blog_columns_tablet', array(
                'type'              => 'option',
                'default'           => 2,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_blog_columns_tablet', array(
                'section' => 'razox_blog_archive',
                'label'   => esc_html__('Colunms Tablet', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'razox'),
                    2 => esc_html__('2', 'razox'),
                    3 => esc_html__('3', 'razox'),
                    4 => esc_html__('4', 'razox'),
                ),
            ));

            $wp_customize->add_setting('razox_options_blog_columns_mobile', array(
                'type'              => 'option',
                'default'           => 1,
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_blog_columns_mobile', array(
                'section' => 'razox_blog_archive',
                'label'   => esc_html__('Colunms Mobile', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    1 => esc_html__('1', 'razox'),
                    2 => esc_html__('2', 'razox'),
                    3 => esc_html__('3', 'razox'),
                    4 => esc_html__('4', 'razox'),
                ),
            ));

            // =========================================
            // Blog Single
            // =========================================
            $wp_customize->add_section('razox_blog_single', array(
                'title'      => esc_html__('Singular', 'razox'),
                'panel'      => 'razox_blog',
                'capability' => 'edit_theme_options',
            ));
            $wp_customize->add_setting('razox_options_blog_single_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_blog_single_sidebar', array(
                'section' => 'razox_blog_single',
                'label'   => esc_html__('Sidebar Position', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'none'  => esc_html__('None', 'razox'),
                    'left'  => esc_html__('Left', 'razox'),
                    'right' => esc_html__('Right', 'razox'),
                ),
            ));
        }

        /**
         * @param $wp_customize WP_Customize_Manager
         *
         * @return void
         */


        public function init_woocommerce($wp_customize) {

            $wp_customize->add_panel('woocommerce', array(
                'title' => esc_html__('Woocommerce', 'razox'),
            ));

            $wp_customize->add_section('razox_woocommerce_archive', array(
                'title'      => esc_html__('Archive', 'razox'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
                'priority'   => 1,
            ));

            $wp_customize->add_setting('razox_options_woocommerce_archive_content_width', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_woocommerce_archive_content_width', array(
                'section' => 'razox_woocommerce_archive',
                'label'   => esc_html__('Content Width', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'default' => esc_html__('default', 'razox'),
                    'wide'    => esc_html__('Wide', 'razox'),

                ),
            ));

            $wp_customize->add_setting('razox_options_woocommerce_archive_layout', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_woocommerce_archive_layout', array(
                'section' => 'razox_woocommerce_archive',
                'label'   => esc_html__('Sidebar Position', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'default'  => esc_html__('Sidebar', 'razox'),
                    //====start_premium
                    'canvas'   => esc_html__('Canvas Filter', 'razox'),
                    'menu'     => esc_html__('Menu Filter', 'razox'),
                    'dropdown' => esc_html__('Dropdown Filter', 'razox'),
                    //====end_premium
                ),
            ));

            $wp_customize->add_setting('razox_options_woocommerce_product_layout', array(
                'type'              => 'option',
                'default'           => 'grid',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_woocommerce_product_layout', array(
                'section' => 'razox_woocommerce_archive',
                'label'   => esc_html__('Product layout', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'grid' => esc_html__('Grid', 'razox'),
                    'list' => esc_html__('List', 'razox'),
                ),
            ));

            $wp_customize->add_setting('razox_options_woocommerce_archive_sidebar', array(
                'type'              => 'option',
                'default'           => 'left',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_woocommerce_archive_sidebar', array(
                'section' => 'razox_woocommerce_archive',
                'label'   => esc_html__('Sidebar Position', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'left'  => esc_html__('Left', 'razox'),
                    'right' => esc_html__('Right', 'razox'),
                ),
            ));

            $wp_customize->add_setting('razox_options_woocommerce_shop_pagination', array(
                'type'              => 'option',
                'default'           => 'default',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_woocommerce_shop_pagination', array(
                'section' => 'razox_woocommerce_archive',
                'label'   => esc_html__('Products pagination', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'default'  => esc_html__('Pagination', 'razox'),
                    'more-btn' => esc_html__('Load More', 'razox'),
                    'infinit'  => esc_html__('Infinit Scroll', 'razox'),
                ),
            ));

            if (razox_is_elementor_activated()) {
                $wp_customize->add_setting('razox_options_shop_banner', array(
                    'type'              => 'option',
                    'default'           => '',
                    'sanitize_callback' => 'sanitize_text_field',
                ));

                $wp_customize->add_control('razox_options_shop_banner', array(
                    'section'     => 'razox_woocommerce_archive',
                    'label'       => esc_html__('Banner', 'razox'),
                    'type'        => 'select',
                    'description' => __('Banner will take templates name prefix is "Banner"', 'razox'),
                    'choices'     => $this->get_banner()
                ));

            }


            // =========================================
            // Single Product
            // =========================================

            $wp_customize->add_section('razox_woocommerce_single', array(
                'title'      => esc_html__('Singular', 'razox'),
                'capability' => 'edit_theme_options',
                'panel'      => 'woocommerce',
                'priority'   => 1,
            ));

            $wp_customize->add_setting('razox_options_single_product_gallery_layout', array(
                'type'              => 'option',
                'default'           => 'horizontal',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('razox_options_single_product_gallery_layout', array(
                'section' => 'razox_woocommerce_single',
                'label'   => esc_html__('Product Gallery Style', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'horizontal' => esc_html__('Horizontal', 'razox'),
                    //====start_premium
                    'vertical'   => esc_html__('Vertical', 'razox'),
                    'gallery'    => esc_html__('Gallery', 'razox'),
                    'sticky'     => esc_html__('Sticky', 'razox'),
                    //====end_premium
                ),
            ));

            $wp_customize->add_setting('razox_options_single_product_tabs_layout', array(
                'type'              => 'option',
                'default'           => 'tabs',
                'transport'         => 'refresh',
                'sanitize_callback' => 'sanitize_text_field',
            ));
            $wp_customize->add_control('razox_options_single_product_tabs_layout', array(
                'section' => 'razox_woocommerce_single',
                'label'   => esc_html__('Product Tabs Style', 'razox'),
                'type'    => 'select',
                'choices' => array(
                    'tabs'         => esc_html__('Tabs', 'razox'),
                    //====start_premium
                    'full-content' => esc_html__('Full content', 'razox'),
                    'sticky'       => esc_html__('Sticky', 'razox'),
                    'accordion'    => esc_html__('Accordion', 'razox'),
                    //====end_premium
                ),
            ));


            $wp_customize->add_setting(
                'razox_options_single_product_extra_description',
                array(
                    /* translators: %s privacy policy page name and link */
                    'type'              => 'option',
                    'sanitize_callback' => 'wp_kses_post',
                    'capability'        => 'edit_theme_options',
                    'transport'         => 'postMessage',
                )
            );

            $wp_customize->add_control(
                'razox_options_single_product_extra_description',
                array(

                    'label'    => esc_html__('Single extra description', 'razox'),
                    'section'  => 'razox_woocommerce_single',
                    'settings' => 'razox_options_single_product_extra_description',
                    'type'     => 'textarea',
                )
            );


            $wp_customize->add_setting('razox_options_single_product_trust_seal_image', array(
                'capability'        => 'edit_theme_options',
                'default'           => '',
                'sanitize_callback' => 'razox_sanitize_image',
            ));

            $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'razox_options_single_product_trust_seal_image',
                array(
                    'label'    => esc_html__('Trust seal image', 'razox'),
                    'section'  => 'razox_woocommerce_single',
                    'settings' => 'razox_options_single_product_trust_seal_image',
                )
            ));

            // =========================================
            // Product
            // =========================================
            $wp_customize->add_setting('razox_options_wocommerce_row_laptop', array(
                'type'              => 'option',
                'default'           => 3,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_wocommerce_row_laptop', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row Laptop', 'razox'),
                'type'    => 'number',
            ));

            $wp_customize->add_setting('razox_options_wocommerce_row_tablet', array(
                'type'              => 'option',
                'default'           => 2,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_wocommerce_row_tablet', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row tablet', 'razox'),
                'type'    => 'number',
            ));

            $wp_customize->add_setting('razox_options_wocommerce_row_mobile', array(
                'type'              => 'option',
                'default'           => 1,
                'transport'         => 'postMessage',
                'sanitize_callback' => 'sanitize_text_field',
            ));

            $wp_customize->add_control('razox_options_wocommerce_row_mobile', array(
                'section' => 'woocommerce_product_catalog',
                'label'   => esc_html__('Products per row mobile', 'razox'),
                'type'    => 'number',
            ));

        }
    }
}
return new Razox_Customize();
