<?php


if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Razox_Elementor')) :

    /**
     * The Razox Elementor Integration class
     */
    class Razox_Elementor {
        private $suffix;

        public function __construct() {
            $this->suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'register_auto_scripts_frontend']);
            add_action('elementor/init', array($this, 'add_category'));
            add_action('wp_enqueue_scripts', [$this, 'add_scripts'], 15);
            add_action('elementor/widgets/register', array($this, 'include_widgets'));
            add_action('elementor/frontend/after_enqueue_scripts', [$this, 'add_js']);

            // Custom Animation Scroll
            add_filter('elementor/controls/animations/additional_animations', [$this, 'add_animations_scroll']);
            add_filter('wp_enqueue_scripts', [$this, 'add_animations_scroll_style']);

            // Elementor Fix Noitice WooCommerce
            add_action('elementor/editor/before_enqueue_scripts', array($this, 'woocommerce_fix_notice'));

            // Backend
            add_action('elementor/editor/after_enqueue_styles', [$this, 'add_style_editor'], 99);

            // Add Icon Custom
            add_action('elementor/icons_manager/native', [$this, 'add_icons_native']);
            add_action('elementor/controls/controls_registered', [$this, 'add_icons']);

            // Add Breakpoints
            add_action('wp_enqueue_scripts', 'razox_elementor_breakpoints', 9999);

            if (!razox_is_elementor_pro_activated()) {
                require trailingslashit(get_template_directory()) . 'inc/elementor/class-section-sticky.php';
                if (is_admin()) {
                    add_action('manage_elementor_library_posts_columns', [$this, 'admin_columns_headers']);
                    add_action('manage_elementor_library_posts_custom_column', [$this, 'admin_columns_content'], 10, 2);
                }
            }

            add_filter('elementor/fonts/additional_fonts', [$this, 'additional_fonts']);

        }

        public function additional_fonts($fonts) {
            $fonts["Gabarito"] = 'system';
            return $fonts;
        }

        public function admin_columns_headers($defaults) {
            $defaults['shortcode'] = esc_html__('Shortcode', 'razox');

            return $defaults;
        }

        public function admin_columns_content($column_name, $post_id) {
            if ('shortcode' === $column_name) {
                ob_start();
                ?>
                <input class="elementor-shortcode-input" type="text" readonly onfocus="this.select()" value="[hfe_template id='<?php echo esc_attr($post_id); ?>']"/>
                <?php
                ob_get_contents();
            }
        }

        public function add_js() {
            wp_enqueue_script('razox-elementor-frontend', get_theme_file_uri('/assets/js/elementor-frontend.js'), '', RAZOX_VERSION);
        }

        public function add_style_editor() {
            wp_enqueue_style('razox-icon', get_template_directory_uri() . '/assets/css/icons.css', '', RAZOX_VERSION);
        }

        public function add_scripts() {
            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
            wp_enqueue_style('razox-elementor', get_template_directory_uri() . '/assets/css/elementor.css', '', RAZOX_VERSION);
            wp_style_add_data('razox-elementor', 'rtl', 'replace');

            // Add Scripts
            wp_register_script('tweenmax', get_theme_file_uri('/assets/js/libs/TweenMax.min.js'), array('jquery'), '1.11.1');
            wp_register_script('parallaxmouse', get_theme_file_uri('/assets/js/libs/jquery-parallax.js'), array('jquery'), RAZOX_VERSION);
            if (razox_elementor_check_type('animated-bg-parallax')) {
                wp_enqueue_script('tweenmax');
                wp_enqueue_script('jquery-panr', get_theme_file_uri('/assets/js/libs/jquery-panr' . $suffix . '.js'), array('jquery'), '0.0.1');
            }
        }

        public function register_auto_scripts_frontend() {
            //js;
            wp_register_script('razox-elementor-brand', get_theme_file_uri('/assets/js/elementor/brand.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-countdown', get_theme_file_uri('/assets/js/elementor/countdown.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-header-carousel', get_theme_file_uri('/assets/js/elementor/header-carousel.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-image-gallery', get_theme_file_uri('/assets/js/elementor/image-gallery.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-nav-menu-vertical', get_theme_file_uri('/assets/js/elementor/nav-menu-vertical.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-posts-grid', get_theme_file_uri('/assets/js/elementor/posts-grid.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-product-categories', get_theme_file_uri('/assets/js/elementor/product-categories.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-product-reviews', get_theme_file_uri('/assets/js/elementor/product-reviews.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-products', get_theme_file_uri('/assets/js/elementor/products.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-team-box', get_theme_file_uri('/assets/js/elementor/team-box.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-testimonial', get_theme_file_uri('/assets/js/elementor/testimonial.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-timeline', get_theme_file_uri('/assets/js/elementor/timeline.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-video', get_theme_file_uri('/assets/js/elementor/video.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
            wp_register_script('razox-elementor-video-review', get_theme_file_uri('/assets/js/elementor/video-review.js'), array('jquery','elementor-frontend'), RAZOX_VERSION, true);
           
        }

        public function add_category() {
            Elementor\Plugin::instance()->elements_manager->add_category(
                'razox-addons',
                array(
                    'title' => esc_html__('Razox Addons', 'razox'),
                    'icon'  => 'fa fa-plug',
                ), 1);
        }

        public function add_animations_scroll_style() {
            $animations = [
                'pavo-move-up'    => 'Move Up',
                'pavo-move-down'  => 'Move Down',
                'pavo-move-left'  => 'Move Left',
                'pavo-move-right' => 'Move Right',
                'pavo-flip'       => 'Flip',
                'pavo-helix'      => 'Helix',
                'pavo-scale-up'   => 'Scale',
                'pavo-am-popup'   => 'Popup',
            ];
            foreach ($animations as $animation => $name) {
                wp_deregister_style('e-animation-' . $animation);
                wp_register_style('e-animation-' . $animation, get_theme_file_uri('/assets/css/animations/' . $animation . '.css'), [], RAZOX_VERSION);
            }
        }

        public function add_animations_scroll($animations) {
            $animations['Razox Animation'] = [
                'pavo-move-up'    => 'Move Up',
                'pavo-move-down'  => 'Move Down',
                'pavo-move-left'  => 'Move Left',
                'pavo-move-right' => 'Move Right',
                'pavo-flip'       => 'Flip',
                'pavo-helix'      => 'Helix',
                'pavo-scale-up'   => 'Scale',
                'pavo-am-popup'   => 'Popup',
            ];

            return $animations;
        }

        /**
         * @param $widgets_manager Elementor\Widgets_Manager
         */
        public function include_widgets($widgets_manager) {
            require 'base_widgets.php';

            $files_custom = glob(get_theme_file_path('/inc/elementor/custom-widgets/*.php'));
            foreach ($files_custom as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }

            $files = glob(get_theme_file_path('/inc/elementor/widgets/*.php'));
            foreach ($files as $file) {
                if (file_exists($file)) {
                    require_once $file;
                }
            }
        }

        public function woocommerce_fix_notice() {
            if (razox_is_woocommerce_activated()) {
                remove_action('woocommerce_cart_is_empty', 'woocommerce_output_all_notices', 5);
                remove_action('woocommerce_shortcode_before_product_cat_loop', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_single_product', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_cart', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_checkout_form', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_account_content', 'woocommerce_output_all_notices', 10);
                remove_action('woocommerce_before_customer_login_form', 'woocommerce_output_all_notices', 10);
            }
        }

        public function add_icons( $manager ) {
            $new_icons = json_decode( '{"razox-icon-arrow-right-1":"arrow-right-1","razox-icon-arrow-up-right":"arrow-up-right","razox-icon-caret-arrow-right":"caret-arrow-right","razox-icon-check-01":"check-01","razox-icon-customer":"customer","razox-icon-delivery":"delivery","razox-icon-gaming-pad-01":"gaming-pad-01","razox-icon-gaming-pad-02":"gaming-pad-02","razox-icon-hard-drive":"hard-drive","razox-icon-headphones-01":"headphones-01","razox-icon-keyboard-01":"keyboard-01","razox-icon-mail-01-converted":"mail-01-converted","razox-icon-mail-01":"mail-01","razox-icon-microphone-01":"microphone-01","razox-icon-monitor-02":"monitor-02","razox-icon-mouse":"mouse","razox-icon-phone-call-01":"phone-call-01","razox-icon-return":"return","razox-icon-video":"video","razox-icon-x":"x","razox-icon-360":"360","razox-icon-add-line":"add-line","razox-icon-add-to-cart":"add-to-cart","razox-icon-angle-down":"angle-down","razox-icon-angle-left":"angle-left","razox-icon-angle-right":"angle-right","razox-icon-angle-up":"angle-up","razox-icon-arrow-alt-circle-down":"arrow-alt-circle-down","razox-icon-arrow-alt-circle-left":"arrow-alt-circle-left","razox-icon-arrow-alt-circle-right":"arrow-alt-circle-right","razox-icon-arrow-alt-circle-up":"arrow-alt-circle-up","razox-icon-arrow-alt-down":"arrow-alt-down","razox-icon-arrow-alt-from-bottom":"arrow-alt-from-bottom","razox-icon-arrow-alt-from-left":"arrow-alt-from-left","razox-icon-arrow-alt-from-right":"arrow-alt-from-right","razox-icon-arrow-alt-from-top":"arrow-alt-from-top","razox-icon-arrow-alt-left":"arrow-alt-left","razox-icon-arrow-alt-right":"arrow-alt-right","razox-icon-arrow-alt-square-down":"arrow-alt-square-down","razox-icon-arrow-alt-square-left":"arrow-alt-square-left","razox-icon-arrow-alt-square-right":"arrow-alt-square-right","razox-icon-arrow-alt-square-up":"arrow-alt-square-up","razox-icon-arrow-alt-to-bottom":"arrow-alt-to-bottom","razox-icon-arrow-alt-to-left":"arrow-alt-to-left","razox-icon-arrow-alt-to-right":"arrow-alt-to-right","razox-icon-arrow-alt-to-top":"arrow-alt-to-top","razox-icon-arrow-alt-up":"arrow-alt-up","razox-icon-arrow-circle-down":"arrow-circle-down","razox-icon-arrow-circle-left":"arrow-circle-left","razox-icon-arrow-circle-right":"arrow-circle-right","razox-icon-arrow-circle-up":"arrow-circle-up","razox-icon-arrow-down":"arrow-down","razox-icon-arrow-from-bottom":"arrow-from-bottom","razox-icon-arrow-from-left":"arrow-from-left","razox-icon-arrow-from-right":"arrow-from-right","razox-icon-arrow-from-top":"arrow-from-top","razox-icon-arrow-left":"arrow-left","razox-icon-arrow-right":"arrow-right","razox-icon-arrow-square-down":"arrow-square-down","razox-icon-arrow-square-left":"arrow-square-left","razox-icon-arrow-square-right":"arrow-square-right","razox-icon-arrow-square-up":"arrow-square-up","razox-icon-arrow-to-bottom":"arrow-to-bottom","razox-icon-arrow-to-left":"arrow-to-left","razox-icon-arrow-to-right":"arrow-to-right","razox-icon-arrow-to-top":"arrow-to-top","razox-icon-arrow-up":"arrow-up","razox-icon-arrows-alt-h":"arrows-alt-h","razox-icon-arrows-alt-v":"arrows-alt-v","razox-icon-arrows-alt":"arrows-alt","razox-icon-arrows-h":"arrows-h","razox-icon-arrows-v":"arrows-v","razox-icon-arrows":"arrows","razox-icon-bow-arrow":"bow-arrow","razox-icon-bullseye-arrow":"bullseye-arrow","razox-icon-calendar":"calendar","razox-icon-caret-circle-down":"caret-circle-down","razox-icon-caret-circle-left":"caret-circle-left","razox-icon-caret-circle-right":"caret-circle-right","razox-icon-caret-circle-up":"caret-circle-up","razox-icon-caret-down":"caret-down","razox-icon-caret-left":"caret-left","razox-icon-caret-right":"caret-right","razox-icon-caret-square-down":"caret-square-down","razox-icon-caret-square-left":"caret-square-left","razox-icon-caret-square-right":"caret-square-right","razox-icon-caret-square-up":"caret-square-up","razox-icon-caret-up":"caret-up","razox-icon-cart-arrow-down":"cart-arrow-down","razox-icon-cart-empty":"cart-empty","razox-icon-chat":"chat","razox-icon-check-circle":"check-circle","razox-icon-check-double":"check-double","razox-icon-check-fill":"check-fill","razox-icon-check-square":"check-square","razox-icon-check":"check","razox-icon-checkbox-circle-fill":"checkbox-circle-fill","razox-icon-chevron-double-down":"chevron-double-down","razox-icon-chevron-double-left":"chevron-double-left","razox-icon-chevron-double-right":"chevron-double-right","razox-icon-chevron-double-up":"chevron-double-up","razox-icon-chevron-down":"chevron-down","razox-icon-chevron-left":"chevron-left","razox-icon-chevron-right":"chevron-right","razox-icon-chevron-selector-vertical":"chevron-selector-vertical","razox-icon-chevron-square-down":"chevron-square-down","razox-icon-chevron-up":"chevron-up","razox-icon-close":"close","razox-icon-cloud-download-alt":"cloud-download-alt","razox-icon-comment-info":"comment-info","razox-icon-compare":"compare","razox-icon-compress-arrows-alt":"compress-arrows-alt","razox-icon-credit-card":"credit-card","razox-icon-dot-circle":"dot-circle","razox-icon-dotfour":"dotfour","razox-icon-double-quotes-r":"double-quotes-r","razox-icon-double-quotes":"double-quotes","razox-icon-edit":"edit","razox-icon-envelope":"envelope","razox-icon-equalizer-line":"equalizer-line","razox-icon-expand-arrows-alt":"expand-arrows-alt","razox-icon-expand-arrows":"expand-arrows","razox-icon-eye-dropper":"eye-dropper","razox-icon-eye-evil":"eye-evil","razox-icon-eye-slash":"eye-slash","razox-icon-eye":"eye","razox-icon-file-alt":"file-alt","razox-icon-file-archive":"file-archive","razox-icon-filter":"filter","razox-icon-free-shipping":"free-shipping","razox-icon-frown-open":"frown-open","razox-icon-frown":"frown","razox-icon-gift-01":"gift-01","razox-icon-gift-card":"gift-card","razox-icon-gift":"gift","razox-icon-gifts":"gifts","razox-icon-heart":"heart","razox-icon-home":"home","razox-icon-info-circle":"info-circle","razox-icon-layout-grid":"layout-grid","razox-icon-layout-list":"layout-list","razox-icon-liquid":"liquid","razox-icon-location-arrow":"location-arrow","razox-icon-locationn":"locationn","razox-icon-long-arrow-alt-down":"long-arrow-alt-down","razox-icon-long-arrow-alt-left":"long-arrow-alt-left","razox-icon-long-arrow-alt-right":"long-arrow-alt-right","razox-icon-long-arrow-alt-up":"long-arrow-alt-up","razox-icon-long-arrow-down":"long-arrow-down","razox-icon-long-arrow-left":"long-arrow-left","razox-icon-long-arrow-right":"long-arrow-right","razox-icon-long-arrow-up":"long-arrow-up","razox-icon-meh-blank":"meh-blank","razox-icon-meh-rolling-eyes":"meh-rolling-eyes","razox-icon-meh":"meh","razox-icon-minus-circle":"minus-circle","razox-icon-minus":"minus","razox-icon-money-check-alt":"money-check-alt","razox-icon-overlap":"overlap","razox-icon-phone":"phone","razox-icon-pin":"pin","razox-icon-plane-arrival":"plane-arrival","razox-icon-plane":"plane","razox-icon-play-fill":"play-fill","razox-icon-plus-circle":"plus-circle","razox-icon-plus":"plus","razox-icon-quickview":"quickview","razox-icon-rating":"rating","razox-icon-repeat":"repeat","razox-icon-reply-line":"reply-line","razox-icon-reply":"reply","razox-icon-search-plus":"search-plus","razox-icon-search":"search","razox-icon-share-all":"share-all","razox-icon-share":"share","razox-icon-shopping-bag":"shopping-bag","razox-icon-shopping-basket":"shopping-basket","razox-icon-shopping-cart":"shopping-cart","razox-icon-sign-out-alt":"sign-out-alt","razox-icon-smile":"smile","razox-icon-spinner-third":"spinner-third","razox-icon-spinner":"spinner","razox-icon-square-full":"square-full","razox-icon-star-exclamation":"star-exclamation","razox-icon-star-half-alt":"star-half-alt","razox-icon-star-half":"star-half","razox-icon-star-o":"star-o","razox-icon-star":"star","razox-icon-stars":"stars","razox-icon-sync-alt":"sync-alt","razox-icon-sync":"sync","razox-icon-tachometer-alt":"tachometer-alt","razox-icon-times-circle":"times-circle","razox-icon-times":"times","razox-icon-truck":"truck","razox-icon-user-line-converted":"user-line-converted","razox-icon-user":"user","razox-icon-wishlist":"wishlist","razox-icon-world":"world","razox-icon-500px":"500px","razox-icon-accessible-icon":"accessible-icon","razox-icon-accusoft":"accusoft","razox-icon-acquisitions-incorporated":"acquisitions-incorporated","razox-icon-adn":"adn","razox-icon-adversal":"adversal","razox-icon-affiliatetheme":"affiliatetheme","razox-icon-airbnb":"airbnb","razox-icon-algolia":"algolia","razox-icon-alipay":"alipay","razox-icon-amazon-pay":"amazon-pay","razox-icon-amazon":"amazon","razox-icon-amilia":"amilia","razox-icon-android":"android","razox-icon-angellist":"angellist","razox-icon-angrycreative":"angrycreative","razox-icon-angular":"angular","razox-icon-app-store-ios":"app-store-ios","razox-icon-app-store":"app-store","razox-icon-apper":"apper","razox-icon-apple-pay":"apple-pay","razox-icon-apple":"apple","razox-icon-artstation":"artstation","razox-icon-asymmetrik":"asymmetrik","razox-icon-atlassian":"atlassian","razox-icon-audible":"audible","razox-icon-autoprefixer":"autoprefixer","razox-icon-avianex":"avianex","razox-icon-aviato":"aviato","razox-icon-aws":"aws","razox-icon-bandcamp":"bandcamp","razox-icon-battle-net":"battle-net","razox-icon-behance-square":"behance-square","razox-icon-behance":"behance","razox-icon-bimobject":"bimobject","razox-icon-bitbucket":"bitbucket","razox-icon-bitcoin":"bitcoin","razox-icon-bity":"bity","razox-icon-black-tie":"black-tie","razox-icon-blackberry":"blackberry","razox-icon-blogger-b":"blogger-b","razox-icon-blogger":"blogger","razox-icon-bluetooth-b":"bluetooth-b","razox-icon-bluetooth":"bluetooth","razox-icon-bootstrap":"bootstrap","razox-icon-btc":"btc","razox-icon-buffer":"buffer","razox-icon-buromobelexperte":"buromobelexperte","razox-icon-buy-n-large":"buy-n-large","razox-icon-buysellads":"buysellads","razox-icon-canadian-maple-leaf":"canadian-maple-leaf","razox-icon-cc-amazon-pay":"cc-amazon-pay","razox-icon-cc-amex":"cc-amex","razox-icon-cc-apple-pay":"cc-apple-pay","razox-icon-cc-diners-club":"cc-diners-club","razox-icon-cc-discover":"cc-discover","razox-icon-cc-jcb":"cc-jcb","razox-icon-cc-mastercard":"cc-mastercard","razox-icon-cc-paypal":"cc-paypal","razox-icon-cc-stripe":"cc-stripe","razox-icon-cc-visa":"cc-visa","razox-icon-centercode":"centercode","razox-icon-centos":"centos","razox-icon-chrome":"chrome","razox-icon-chromecast":"chromecast","razox-icon-cloudflare":"cloudflare","razox-icon-cloudscale":"cloudscale","razox-icon-cloudsmith":"cloudsmith","razox-icon-cloudversify":"cloudversify","razox-icon-codepen":"codepen","razox-icon-codiepie":"codiepie","razox-icon-confluence":"confluence","razox-icon-connectdevelop":"connectdevelop","razox-icon-contao":"contao","razox-icon-cotton-bureau":"cotton-bureau","razox-icon-cpanel":"cpanel","razox-icon-creative-commons-by":"creative-commons-by","razox-icon-creative-commons-nc-eu":"creative-commons-nc-eu","razox-icon-creative-commons-nc-jp":"creative-commons-nc-jp","razox-icon-creative-commons-nc":"creative-commons-nc","razox-icon-creative-commons-nd":"creative-commons-nd","razox-icon-creative-commons-pd-alt":"creative-commons-pd-alt","razox-icon-creative-commons-pd":"creative-commons-pd","razox-icon-creative-commons-remix":"creative-commons-remix","razox-icon-creative-commons-sa":"creative-commons-sa","razox-icon-creative-commons-sampling-plus":"creative-commons-sampling-plus","razox-icon-creative-commons-sampling":"creative-commons-sampling","razox-icon-creative-commons-share":"creative-commons-share","razox-icon-creative-commons-zero":"creative-commons-zero","razox-icon-creative-commons":"creative-commons","razox-icon-critical-role":"critical-role","razox-icon-css3-alt":"css3-alt","razox-icon-css3":"css3","razox-icon-cuttlefish":"cuttlefish","razox-icon-d-and-d-beyond":"d-and-d-beyond","razox-icon-d-and-d":"d-and-d","razox-icon-dailymotion":"dailymotion","razox-icon-dashcube":"dashcube","razox-icon-deezer":"deezer","razox-icon-delicious":"delicious","razox-icon-deploydog":"deploydog","razox-icon-deskpro":"deskpro","razox-icon-dev":"dev","razox-icon-deviantart":"deviantart","razox-icon-dhl":"dhl","razox-icon-diaspora":"diaspora","razox-icon-digg":"digg","razox-icon-digital-ocean":"digital-ocean","razox-icon-discord":"discord","razox-icon-discourse":"discourse","razox-icon-dochub":"dochub","razox-icon-docker":"docker","razox-icon-draft2digital":"draft2digital","razox-icon-dribbble-square":"dribbble-square","razox-icon-dribbble":"dribbble","razox-icon-dropbox":"dropbox","razox-icon-drupal":"drupal","razox-icon-dyalog":"dyalog","razox-icon-earlybirds":"earlybirds","razox-icon-ebay":"ebay","razox-icon-edge-legacy":"edge-legacy","razox-icon-edge":"edge","razox-icon-elementor":"elementor","razox-icon-ello":"ello","razox-icon-ember":"ember","razox-icon-empire":"empire","razox-icon-envira":"envira","razox-icon-erlang":"erlang","razox-icon-ethereum":"ethereum","razox-icon-etsy":"etsy","razox-icon-evernote":"evernote","razox-icon-expeditedssl":"expeditedssl","razox-icon-facebook-f":"facebook-f","razox-icon-facebook-messenger":"facebook-messenger","razox-icon-facebook-square":"facebook-square","razox-icon-facebook":"facebook","razox-icon-fantasy-flight-games":"fantasy-flight-games","razox-icon-fedex":"fedex","razox-icon-fedora":"fedora","razox-icon-figma":"figma","razox-icon-firefox-browser":"firefox-browser","razox-icon-firefox":"firefox","razox-icon-first-order-alt":"first-order-alt","razox-icon-first-order":"first-order","razox-icon-firstdraft":"firstdraft","razox-icon-flickr":"flickr","razox-icon-flipboard":"flipboard","razox-icon-fly":"fly","razox-icon-font-awesome":"font-awesome","razox-icon-fonticons-fi":"fonticons-fi","razox-icon-fonticons":"fonticons","razox-icon-fort-awesome-alt":"fort-awesome-alt","razox-icon-fort-awesome":"fort-awesome","razox-icon-forumbee":"forumbee","razox-icon-foursquare":"foursquare","razox-icon-free-code-camp":"free-code-camp","razox-icon-freebsd":"freebsd","razox-icon-fulcrum":"fulcrum","razox-icon-galactic-republic":"galactic-republic","razox-icon-galactic-senate":"galactic-senate","razox-icon-get-pocket":"get-pocket","razox-icon-gg-circle":"gg-circle","razox-icon-gg":"gg","razox-icon-git-alt":"git-alt","razox-icon-git-square":"git-square","razox-icon-git":"git","razox-icon-github-alt":"github-alt","razox-icon-github-square":"github-square","razox-icon-github":"github","razox-icon-gitkraken":"gitkraken","razox-icon-gitlab":"gitlab","razox-icon-gitter":"gitter","razox-icon-glide-g":"glide-g","razox-icon-glide":"glide","razox-icon-gofore":"gofore","razox-icon-goodreads-g":"goodreads-g","razox-icon-goodreads":"goodreads","razox-icon-google-drive":"google-drive","razox-icon-google-pay":"google-pay","razox-icon-google-play":"google-play","razox-icon-google-plus-g":"google-plus-g","razox-icon-google-plus-square":"google-plus-square","razox-icon-google-plus":"google-plus","razox-icon-google-wallet":"google-wallet","razox-icon-google":"google","razox-icon-gratipay":"gratipay","razox-icon-grav":"grav","razox-icon-gripfire":"gripfire","razox-icon-grunt":"grunt","razox-icon-guilded":"guilded","razox-icon-gulp":"gulp","razox-icon-hacker-news-square":"hacker-news-square","razox-icon-hacker-news":"hacker-news","razox-icon-hackerrank":"hackerrank","razox-icon-hips":"hips","razox-icon-hire-a-helper":"hire-a-helper","razox-icon-hive":"hive","razox-icon-hooli":"hooli","razox-icon-hornbill":"hornbill","razox-icon-hotjar":"hotjar","razox-icon-houzz":"houzz","razox-icon-html5":"html5","razox-icon-hubspot":"hubspot","razox-icon-ideal":"ideal","razox-icon-imdb":"imdb","razox-icon-innosoft":"innosoft","razox-icon-instagram-square":"instagram-square","razox-icon-instagram":"instagram","razox-icon-instalod":"instalod","razox-icon-intercom":"intercom","razox-icon-internet-explorer":"internet-explorer","razox-icon-invision":"invision","razox-icon-ioxhost":"ioxhost","razox-icon-itch-io":"itch-io","razox-icon-itunes-note":"itunes-note","razox-icon-itunes":"itunes","razox-icon-java":"java","razox-icon-jedi-order":"jedi-order","razox-icon-jenkins":"jenkins","razox-icon-jira":"jira","razox-icon-joget":"joget","razox-icon-joomla":"joomla","razox-icon-js-square":"js-square","razox-icon-js":"js","razox-icon-jsfiddle":"jsfiddle","razox-icon-kaggle":"kaggle","razox-icon-keybase":"keybase","razox-icon-keycdn":"keycdn","razox-icon-kickstarter-k":"kickstarter-k","razox-icon-kickstarter":"kickstarter","razox-icon-korvue":"korvue","razox-icon-laravel":"laravel","razox-icon-lastfm-square":"lastfm-square","razox-icon-lastfm":"lastfm","razox-icon-leanpub":"leanpub","razox-icon-less":"less","razox-icon-line":"line","razox-icon-linkedin-in":"linkedin-in","razox-icon-linkedin":"linkedin","razox-icon-linode":"linode","razox-icon-linux":"linux","razox-icon-lyft":"lyft","razox-icon-magento":"magento","razox-icon-mailchimp":"mailchimp","razox-icon-mandalorian":"mandalorian","razox-icon-markdown":"markdown","razox-icon-mastodon":"mastodon","razox-icon-maxcdn":"maxcdn","razox-icon-mdb":"mdb","razox-icon-medapps":"medapps","razox-icon-medium":"medium","razox-icon-medrt":"medrt","razox-icon-meetup":"meetup","razox-icon-megaport":"megaport","razox-icon-mendeley":"mendeley","razox-icon-microblog":"microblog","razox-icon-microsoft":"microsoft","razox-icon-mix":"mix","razox-icon-mixcloud":"mixcloud","razox-icon-mixer":"mixer","razox-icon-mizuni":"mizuni","razox-icon-modx":"modx","razox-icon-monero":"monero","razox-icon-napster":"napster","razox-icon-neos":"neos","razox-icon-nimblr":"nimblr","razox-icon-node-js":"node-js","razox-icon-node":"node","razox-icon-npm":"npm","razox-icon-ns8":"ns8","razox-icon-nutritionix":"nutritionix","razox-icon-octopus-deploy":"octopus-deploy","razox-icon-odnoklassniki-square":"odnoklassniki-square","razox-icon-odnoklassniki":"odnoklassniki","razox-icon-old-republic":"old-republic","razox-icon-opencart":"opencart","razox-icon-openid":"openid","razox-icon-opera":"opera","razox-icon-optin-monster":"optin-monster","razox-icon-orcid":"orcid","razox-icon-osi":"osi","razox-icon-page4":"page4","razox-icon-pagelines":"pagelines","razox-icon-palfed":"palfed","razox-icon-patreon":"patreon","razox-icon-paypal":"paypal","razox-icon-penny-arcade":"penny-arcade","razox-icon-perbyte":"perbyte","razox-icon-periscope":"periscope","razox-icon-phabricator":"phabricator","razox-icon-phoenix-framework":"phoenix-framework","razox-icon-phoenix-squadron":"phoenix-squadron","razox-icon-php":"php","razox-icon-pied-piper-alt":"pied-piper-alt","razox-icon-pied-piper-hat":"pied-piper-hat","razox-icon-pied-piper-pp":"pied-piper-pp","razox-icon-pied-piper-square":"pied-piper-square","razox-icon-pied-piper":"pied-piper","razox-icon-pinterest-p":"pinterest-p","razox-icon-pinterest-square":"pinterest-square","razox-icon-pinterest":"pinterest","razox-icon-playstation":"playstation","razox-icon-product-hunt":"product-hunt","razox-icon-pushed":"pushed","razox-icon-python":"python","razox-icon-qq":"qq","razox-icon-quinscape":"quinscape","razox-icon-quora":"quora","razox-icon-r-project":"r-project","razox-icon-raspberry-pi":"raspberry-pi","razox-icon-ravelry":"ravelry","razox-icon-react":"react","razox-icon-reacteurope":"reacteurope","razox-icon-readme":"readme","razox-icon-rebel":"rebel","razox-icon-red-river":"red-river","razox-icon-reddit-alien":"reddit-alien","razox-icon-reddit-square":"reddit-square","razox-icon-reddit":"reddit","razox-icon-redhat":"redhat","razox-icon-renren":"renren","razox-icon-replyd":"replyd","razox-icon-researchgate":"researchgate","razox-icon-resolving":"resolving","razox-icon-rev":"rev","razox-icon-rocketchat":"rocketchat","razox-icon-rockrms":"rockrms","razox-icon-rust":"rust","razox-icon-safari":"safari","razox-icon-salesforce":"salesforce","razox-icon-sass":"sass","razox-icon-schlix":"schlix","razox-icon-scribd":"scribd","razox-icon-searchengin":"searchengin","razox-icon-sellcast":"sellcast","razox-icon-sellsy":"sellsy","razox-icon-servicestack":"servicestack","razox-icon-shirtsinbulk":"shirtsinbulk","razox-icon-shopify":"shopify","razox-icon-shopware":"shopware","razox-icon-simplybuilt":"simplybuilt","razox-icon-sistrix":"sistrix","razox-icon-sith":"sith","razox-icon-sketch":"sketch","razox-icon-skyatlas":"skyatlas","razox-icon-skype":"skype","razox-icon-slack":"slack","razox-icon-slideshare":"slideshare","razox-icon-snapchat-square":"snapchat-square","razox-icon-snapchat":"snapchat","razox-icon-soundcloud":"soundcloud","razox-icon-sourcetree":"sourcetree","razox-icon-speakap":"speakap","razox-icon-speaker-deck":"speaker-deck","razox-icon-spotify":"spotify","razox-icon-square-font-awesome-stroke":"square-font-awesome-stroke","razox-icon-square-font-awesome":"square-font-awesome","razox-icon-squarespace":"squarespace","razox-icon-stack-exchange":"stack-exchange","razox-icon-stack-overflow":"stack-overflow","razox-icon-stackpath":"stackpath","razox-icon-staylinked":"staylinked","razox-icon-steam-square":"steam-square","razox-icon-steam-symbol":"steam-symbol","razox-icon-steam":"steam","razox-icon-sticker-mule":"sticker-mule","razox-icon-strava":"strava","razox-icon-stripe-s":"stripe-s","razox-icon-stripe":"stripe","razox-icon-studiovinari":"studiovinari","razox-icon-stumbleupon-circle":"stumbleupon-circle","razox-icon-stumbleupon":"stumbleupon","razox-icon-superpowers":"superpowers","razox-icon-supple":"supple","razox-icon-suse":"suse","razox-icon-swift":"swift","razox-icon-symfony":"symfony","razox-icon-teamspeak":"teamspeak","razox-icon-telegram":"telegram","razox-icon-tencent-weibo":"tencent-weibo","razox-icon-the-red-yeti":"the-red-yeti","razox-icon-themeco":"themeco","razox-icon-themeisle":"themeisle","razox-icon-think-peaks":"think-peaks","razox-icon-tiktok":"tiktok","razox-icon-trade-federation":"trade-federation","razox-icon-trello":"trello","razox-icon-tripadvisor":"tripadvisor","razox-icon-tumblr-square":"tumblr-square","razox-icon-tumblr":"tumblr","razox-icon-twitch":"twitch","razox-icon-twitter-square":"twitter-square","razox-icon-twitter":"twitter","razox-icon-typo3":"typo3","razox-icon-uber":"uber","razox-icon-ubuntu":"ubuntu","razox-icon-uikit":"uikit","razox-icon-umbraco":"umbraco","razox-icon-uncharted":"uncharted","razox-icon-uniregistry":"uniregistry","razox-icon-unity":"unity","razox-icon-unsplash":"unsplash","razox-icon-untappd":"untappd","razox-icon-ups":"ups","razox-icon-usb":"usb","razox-icon-usps":"usps","razox-icon-ussunnah":"ussunnah","razox-icon-vaadin":"vaadin","razox-icon-viacoin":"viacoin","razox-icon-viadeo-square":"viadeo-square","razox-icon-viadeo":"viadeo","razox-icon-viber":"viber","razox-icon-vimeo-square":"vimeo-square","razox-icon-vimeo-v":"vimeo-v","razox-icon-vimeo":"vimeo","razox-icon-vine":"vine","razox-icon-vk":"vk","razox-icon-vnv":"vnv","razox-icon-vuejs":"vuejs","razox-icon-watchman-monitoring":"watchman-monitoring","razox-icon-waze":"waze","razox-icon-weebly":"weebly","razox-icon-weibo":"weibo","razox-icon-weixin":"weixin","razox-icon-whatsapp-square":"whatsapp-square","razox-icon-whatsapp":"whatsapp","razox-icon-whmcs":"whmcs","razox-icon-wikipedia-w":"wikipedia-w","razox-icon-windows":"windows","razox-icon-wix":"wix","razox-icon-wizards-of-the-coast":"wizards-of-the-coast","razox-icon-wodu":"wodu","razox-icon-wolf-pack-battalion":"wolf-pack-battalion","razox-icon-wordpress-simple":"wordpress-simple","razox-icon-wordpress":"wordpress","razox-icon-wpbeginner":"wpbeginner","razox-icon-wpexplorer":"wpexplorer","razox-icon-wpforms":"wpforms","razox-icon-wpressr":"wpressr","razox-icon-xbox":"xbox","razox-icon-xing-square":"xing-square","razox-icon-xing":"xing","razox-icon-y-combinator":"y-combinator","razox-icon-yahoo":"yahoo","razox-icon-yammer":"yammer","razox-icon-yandex-international":"yandex-international","razox-icon-yandex":"yandex","razox-icon-yarn":"yarn","razox-icon-yelp":"yelp","razox-icon-yoast":"yoast","razox-icon-youtube-square":"youtube-square","razox-icon-youtube":"youtube","razox-icon-zhihu":"zhihu","razox-icon-user_222":"user_222"}', true );
			$icons     = $manager->get_control( 'icon' )->get_settings( 'options' );
			$new_icons = array_merge(
				$new_icons,
				$icons
			);
			// Then we set a new list of icons as the options of the icon control
			$manager->get_control( 'icon' )->set_settings( 'options', $new_icons ); 
        }

        public function add_icons_native($tabs) {
            $tabs['pavo-custom'] = [
                'name'          => 'razox-icon',
                'label'         => esc_html__('Razox Icon', 'razox'),
                'prefix'        => 'razox-icon-',
                'displayPrefix' => 'razox-icon-',
                'labelIcon'     => 'fab fa-font-awesome-alt',
                'ver'           => RAZOX_VERSION,
                'fetchJson'     => get_theme_file_uri('/inc/elementor/icons.json'),
                'native'        => true,
            ];

            return $tabs;
        }
    }

endif;

return new Razox_Elementor();
