<?php
//Accordion
use Elementor\Controls_Manager;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Accordion;
use Elementor\Modules\NestedAccordion;


add_action( 'elementor/element/accordion/section_title_style/before_section_end', function ($element, $args ) {

    $element->remove_control( 'border_width', [
        'type' => Controls_Manager::HIDDEN,
    ] );
    $element->remove_control( 'border_color', [
        'type' => Controls_Manager::HIDDEN,
    ] );

    $element->add_control(
        'title_margin',
        [
            'label' => esc_html__( 'Margin', 'razox' ),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', 'em', '%' ],
            'selectors' => [
                '{{WRAPPER}} .elementor-accordion .elementor-accordion-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
    $element->add_control(
        'style_theme',
        [
            'label' => esc_html__('Layout', 'razox'),
            'type' => Controls_Manager::SELECT,
            'default' => 'ecofa-1',
            'options' => [
                'layout-1' => esc_html__('Layout 1', 'razox'),
                'layout-2' => esc_html__('Layout 2', 'razox'),
            ],
            'prefix_class' => 'ecofa-accordion-',
        ]
    );

},10,2);

add_action( 'elementor/element/accordion/section_toggle_style_title/before_section_end', function ( $element, $args ) {

    $element->update_control( 'title_color', [
        'global' => [
            'default' => '',
        ],
    ] );

    $element->update_control( 'tab_active_color', [
        'global' => [
            'default' => '',
        ],
    ] );
//
    $element->update_control( 'title_typography', [
        'global' => [
            'default' => '',
        ],
    ] );

    $element->add_control(
        'title_background_active',
        [
            'label' => esc_html__( 'Background Active', 'razox' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .elementor-accordion .elementor-tab-title.elementor-active' => 'background-color: {{VALUE}};',
            ],
        ]
    );

},10,2);
add_action( 'elementor/element/accordion/section_toggle_style_icon/before_section_end', function ( $element, $args ) {

    $element->add_responsive_control(
        'icon_size',
        [
            'label'      => __( 'Icon Size', 'razox' ),
            'type'       => Controls_Manager::SLIDER,
            'range'      => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                ],
            ],
            'size_units' => [ 'px', 'em', '%' ],
            'selectors'  => [
                '{{WRAPPER}} .elementor-accordion-icon-opened i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                '{{WRAPPER}} .elementor-accordion-icon i' => 'font-size: {{SIZE}}{{UNIT}} !important;',
            ],
        ]
    );

},10,2);

add_action('elementor/element/nested-accordion/section_accordion_style/before_section_end',function ( $element, $args ) {

    $element->add_control(
        'style_theme_1',
        [
            'type' => Controls_Manager::SWITCHER,
            'label' => esc_html__( 'Style Border', 'razox' ),
            'prefix_class'	=> 'style-theme-'
        ]
    );

},10,2);