<?php
// Button
use Elementor\Controls_Manager;

add_action('elementor/element/button/section_button/after_section_end', function ($element, $args) {

    $element->update_control(
        'button_type',
        [
            'label'        => esc_html__('Type', 'razox'),
            'type'         => Controls_Manager::SELECT,
            'default'      => 'default',
            'options'      => [
                'default' => esc_html__('Default', 'razox'),
                'outline' => esc_html__('OutLine', 'razox'),
                'info'    => esc_html__('Info', 'razox'),
                'success' => esc_html__('Success', 'razox'),
                'warning' => esc_html__('Warning', 'razox'),
                'danger'  => esc_html__('Danger', 'razox'),
                'link'    => esc_html__('Link', 'razox'),
            ],
            'prefix_class' => 'elementor-button-',
        ]
    );
}, 10, 2);

add_action('elementor/element/button/section_button/before_section_end', function ($element, $args) {
    $element->add_control(
        'icon_button_effects',
        [
            'label'        => esc_html__('Effects_button', 'razox'),
            'type'         => Controls_Manager::SWITCHER,
            'prefix_class' => 'enable-effects-',
        ]
    );
}, 10, 2);

add_action('elementor/element/button/section_style/after_section_end', function ($element, $args) {
    $element->update_control(
        'background_color',
        [
            'global'    => [
                'default' => '',
            ],
            'selectors' => [
                '{{WRAPPER}} .elementor-button' => ' background-color: {{VALUE}};',
            ],
        ]
    );
}, 10, 2);




