<?php
use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Icon_Box;

add_action('elementor/element/icon-box/section_style_content/before_section_end', function ($element, $args) {
    $element->add_responsive_control(
        'align_content',
        [
            'label'     => esc_html__('Alignment Info ', 'razox'),
            'type'      => Controls_Manager::CHOOSE,
            'options'   => [
                'flex-start' => [
                    'title' => esc_html__('Left', 'razox'),
                    'icon'  => 'eicon-h-align-left',
                ],
                'center'     => [
                    'title' => esc_html__('Center', 'razox'),
                    'icon'  => 'eicon-h-align-center',
                ],
                'flex-end'   => [
                    'title' => esc_html__('Right', 'razox'),
                    'icon'  => 'eicon-h-align-right',
                ],
            ],
            'default'   => 'center',
            'selectors' => [
                '{{WRAPPER}} .elementor-icon-box-icon .elementor-icon' => 'justify-content: {{VALUE}}',
            ],
        ]
    );
    $element->add_control(
        'icon_box_title_hover',
        [
            'label'     => esc_html__('Color Title Hover', 'razox'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}} .elementor-icon-box-wrapper:hover .elementor-icon-box-content .elementor-icon-box-title' => 'color: {{VALUE}};',
            ],
            'separator'    => 'before',
        ]
    );
    $element->add_control(
        'title_effects',
            [
                'label' => esc_html__('Line Title', 'razox'),
                'type'  => Controls_Manager::SWITCHER,

                'prefix_class' => 'title-effects-',
            ]
    );
}, 10, 2);
add_action('elementor/element/icon-box/section_icon/before_section_end', function ($element, $args) {
    $element->add_control(
        'icon_enable_effects',
        [
            'label'     => esc_html__('Effects Animation', 'razox'),
            'type'      => Controls_Manager::SWITCHER,
            'prefix_class' => 'enable-icon-effects-',
        ]
    );
}, 10, 2);
add_action('elementor/element/icon-box/section_style_icon/before_section_end', function ($element, $args) {
    $element->add_control(
        'effects_color',
        [
            'label'     => esc_html__('Effects color', 'razox'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}}.enable-effects-yes .elementor-icon-box-icon .elementor-icon' => 'background-color:{{VALUE}};',

            ]
        ]
    );
    $element->add_control(
        'effects_color_animation',
        [
            'label'     => esc_html__('Effects color Animation', 'razox'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}}.enable-icon-effects-yes .elementor-icon-box-icon .elementor-icon:before' => 'background-color:{{VALUE}};',

            ]
        ]
    );
    $element->add_control(
        'effects_color_hover',
        [
            'label'     => esc_html__('Effects color hover', 'razox'),
            'type'      => Controls_Manager::COLOR,
            'default'   => '',
            'selectors' => [
                '{{WRAPPER}}.enable-effects-yes .elementor-icon-box-icon .elementor-icon:hover' => 'background-color:{{VALUE}};',
            ]
        ]
    );
    $element->add_responsive_control(
        'effects_width_svg',
        [
            'label'          => esc_html__('Width SVG', 'razox'),
            'type'           => Controls_Manager::SLIDER,
            'default'        => [
                'unit' => 'px',
            ],
            'tablet_default' => [
                'unit' => 'px',
            ],
            'mobile_default' => [
                'unit' => 'px',
            ],
            'size_units'     => ['%', 'px', 'vw'],
            'range'          => [
                '%'  => [
                    'min' => 1,
                    'max' => 100,
                ],
                'px' => [
                    'min' => 1,
                    'max' => 1000,
                ],
                'vw' => [
                    'min' => 1,
                    'max' => 100,
                ],
            ],
            'selectors'      => [
                '{{WRAPPER}} .elementor-icon-box-icon .elementor-icon svg' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
    $element->add_responsive_control(
        'effects_height_svg',
        [
            'label'          => esc_html__('Height SVG', 'razox'),
            'type'           => Controls_Manager::SLIDER,
            'default'        => [
                'unit' => 'px',
            ],
            'tablet_default' => [
                'unit' => 'px',
            ],
            'mobile_default' => [
                'unit' => 'px',
            ],
            'size_units'     => ['%', 'px', 'vw'],
            'range'          => [
                '%'  => [
                    'min' => 1,
                    'max' => 100,
                ],
                'px' => [
                    'min' => 1,
                    'max' => 1000,
                ],
                'vw' => [
                    'min' => 1,
                    'max' => 100,
                ],
            ],
            'selectors'      => [
                '{{WRAPPER}} .elementor-icon-box-icon .elementor-icon svg' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
    $element->add_responsive_control(
        'effects_width_icon',
        [
            'label'          => esc_html__('Width Effects', 'razox'),
            'type'           => Controls_Manager::SLIDER,
            'default'        => [
                'unit' => 'px',
            ],
            'tablet_default' => [
                'unit' => 'px',
            ],
            'mobile_default' => [
                'unit' => 'px',
            ],
            'size_units'     => ['%', 'px', 'vw'],
            'range'          => [
                '%'  => [
                    'min' => 1,
                    'max' => 100,
                ],
                'px' => [
                    'min' => 1,
                    'max' => 1000,
                ],
                'vw' => [
                    'min' => 1,
                    'max' => 100,
                ],
            ],
            'selectors'      => [
                '{{WRAPPER}}.enable-icon-effects-yes .elementor-icon-box-icon .elementor-icon:before' => 'width: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
    $element->add_responsive_control(
        'effects_height_icon',
        [
            'label'          => esc_html__('Height Effects', 'razox'),
            'type'           => Controls_Manager::SLIDER,
            'default'        => [
                'unit' => 'px',
            ],
            'tablet_default' => [
                'unit' => 'px',
            ],
            'mobile_default' => [
                'unit' => 'px',
            ],
            'size_units'     => ['%', 'px', 'vw'],
            'range'          => [
                '%'  => [
                    'min' => 1,
                    'max' => 100,
                ],
                'px' => [
                    'min' => 1,
                    'max' => 1000,
                ],
                'vw' => [
                    'min' => 1,
                    'max' => 100,
                ],
            ],
            'selectors'      => [
                '{{WRAPPER}}.enable-icon-effects-yes .elementor-icon-box-icon .elementor-icon:before' => 'height: {{SIZE}}{{UNIT}};',
            ],
        ]
    );
}, 10, 2);