<?php
use Elementor\Controls_Manager;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Elementor\Widget_Icon_List;

add_action( 'elementor/element/icon-list/section_icon_list/before_section_end', function ($element, $args ) {

    $element->add_control(
        'background-box-divider',
        [
            'label' => esc_html__( 'Style Background', 'razox' ),
            'type' => Controls_Manager::SWITCHER,
            'label_off' => esc_html__( 'Off', 'razox' ),
            'label_on' => esc_html__( 'On', 'razox' ),
            'separator' => 'before',
            'prefix_class' => 'razox-background-box-divider-',
        ]
    );
    $element->add_control(
        'list_item_color',
        [
            'label'     => esc_html__('Background Item', 'razox'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .elementor-icon-list-item a' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'background-box-divider' => 'yes',
            ],
        ]
    );
    $element->add_control(
        'list_item_color_hover',
        [
            'label'     => esc_html__('Background Item Hover', 'razox'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .elementor-icon-list-item:hover a' => 'background-color: {{VALUE}};',
            ],
            'condition' => [
                'background-box-divider' => 'yes',
            ],
        ]
    );
    $element->add_group_control(

        Group_Control_Border::get_type(),
        [
            'name' => 'border_formgroup',
            'placeholder' => '1px',
            'default' => '1px',
            'selector' => '{{WRAPPER}} .elementor-icon-list-item',
            'condition' => [
                'background-box-divider' => 'yes',
            ],
            'separator' => 'before',
        ]
    );
    $element->add_control(
        'box_border_radius',
        [
            'label'      => esc_html__('Border Radius', 'razox'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .elementor-icon-list-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'condition' => [
                'background-box-divider' => 'yes',
            ],
        ]
    );

    $element->add_responsive_control(
        'padding_list_item',
        [
            'label'      => esc_html__('Padding Item', 'razox'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors'  => [
                '{{WRAPPER}} .elementor-icon-list-item a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
            'condition' => [
                'background-box-divider' => 'yes',
            ],
        ]
    );

},10,2);