<?php
// Image
use Elementor\Controls_Manager;


add_action('elementor/element/image/section_image/before_section_end', function ($element, $args) {
    $element->add_control(
        'image_style_theme',
        [
            'label'        => esc_html__('Theme Style', 'razox'),
            'type'         => Controls_Manager::SWITCHER,
            'default'      => '',
            'prefix_class' => 'image-style-razox-',
            'condition'    => [
                'link_to!' => 'none',
            ],
        ]
    );
    $element->add_control(
        'image_effect',
        [
            'label'        => esc_html__('Image Effect', 'razox'),
            'type'         => Controls_Manager::SWITCHER,
            'default'      => '',
            'prefix_class' => 'razox-image-effect-',
        ]
    );
}, 10, 2);

add_action('elementor/element/image/section_style_image/before_section_end', function ($element, $args) {
    $element->add_control(
            'image_effect_border_radius',
            [
                'label' => esc_html__( 'Border Radius Effects', 'razox' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-widget-container:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
    );

}, 10, 2);

