<?php
// Image
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
add_action('elementor/element/nested-tabs/section_tabs/before_section_end', function ($element, $args) {
    $element->add_control(
        'style',
        [
            'label'        => esc_html__('Style', 'razox'),
            'type'         => Controls_Manager::SELECT,
            'default'      => '1',
            'options'      => [
                '1' => esc_html__('Style 1', 'razox'),
                '2' => esc_html__('Style 2', 'razox'),
            ],
            'prefix_class' => 'tabs-style-'
        ]
    );
}, 10, 2);
add_action('elementor/element/nested-tabs/section_tabs_style/before_section_end', function ($element, $args) {
    $element->add_control(
        'padding_tabs',
        [
            'label'      => esc_html__('Padding Tabs', 'razox'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'separator'   => 'before',
            'selectors'  => [
                '{{WRAPPER}} .e-n-tabs-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
            ],
        ]
    );

}, 10, 2);

add_action('elementor/element/nested-tabs/section_tabs_style/before_section_end', function ($element, $args) {
    $element->add_group_control(
        Group_Control_Border::get_type(),
        [
            'name'        => 'tabs_heading_border',
            'placeholder' => '1px',
            'default'     => '1px',
            'selector'    => '{{WRAPPER}} .e-n-tabs-heading',
        ]
    );
}, 10, 2);

add_action('elementor/element/nested-tabs/section_tabs_style/before_section_end', function ($element, $args) {
    $element->add_control(
        'tabs_border_radius',
        [
            'label'      => esc_html__('Border Radius Tabs', 'razox'),
            'type'       => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', '%'],
            'selectors'  => [
                '{{WRAPPER}} .e-n-tabs-heading' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]
    );
}, 10, 2);

add_action('elementor/element/nested-tabs/section_tabs_style/before_section_end', function ($element, $args) {
    $element->add_control(
        'tabs_background_color',
        [
            'label'     => esc_html__('Background Tabs', 'razox'),
            'type'      => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .e-n-tabs-heading' => 'background-color: {{VALUE}}',
            ],
        ]
    );
}, 10, 2);
