<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
use Elementor\Icons_Manager;
use Elementor\Utils;
use Razox\Elementor\Razox_Base_Widgets;
use Elementor\Group_Control_Background;


class Razox_Elementor_Header_Carousel extends Razox_Base_Widgets {

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @return string Widget name.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_name() {
        return 'razox-header-carousel';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @return string Widget title.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_title() {
        return esc_html__('Razox Header Carousel', 'razox');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @return string Widget icon.
     * @since  1.0.0
     * @access public
     *
     */
    public function get_icon() {
        return 'eicon-image';
    }

    public function get_script_depends() {
        return ['razox-elementor-header-carousel'];
    }

    public function get_categories() {
        return array('razox-addons');
    }

    public function get_style_depends(): array {
        return [ 'e-swiper' ];
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls($args = []) {
        $this->start_controls_section(
            'section_header_carousel',
            [
                'label' => esc_html__('Header', 'razox'),
            ]
        );
        $default_args = [
            'section_condition'              => [],
            'button_default_text'            => esc_html__('Click here', 'razox'),
            'text_control_label'             => esc_html__('Text', 'razox'),
            'alignment_control_prefix_class' => 'elementor%s-align-',
            'alignment_default'              => '',
            'icon_exclude_inline_options'    => [],
        ];
        $args         = wp_parse_args($args, $default_args);
        $repeater     = new Repeater();
        $repeater->add_control(
            'header_carousel_title',
            [
                'label'   => esc_html__('Title', 'razox'),
                'type'    => Controls_Manager::TEXT,
                'default' => 'Header title',
            ]
        );
        $repeater->add_control(
            'used_icon',
            [
                'label' => esc_html__('Use Icon', 'razox'),
                'type'  => Controls_Manager::SWITCHER,
            ]
        );
        $repeater->add_control(
            'selected_icon',
            [
                'label' => esc_html__('Icon', 'razox'),
                'type'  => Controls_Manager::ICONS,
                'condition'   => [
                    'used_icon' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'header_carousel',
            [
                'label'       => esc_html__('Items', 'razox'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ header_carousel_title }}}',
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section_style_header_carousel',
            [
                'label' => esc_html__('Box', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'width',
            [
                'label'      => esc_html__('Width', 'razox'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 100,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-heading-carousel-inner .elementor-heading-carousel-item' => 'width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label'      => esc_html__('Height', 'razox'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 100,
                        'max' => 1000,
                    ],
                    '%'  => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-heading-carousel-inner .elementor-heading-carousel-item' => 'height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'header_carousel_padding',
            [
                'label'      => esc_html__('Padding', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-heading-carousel-inner .elementor-heading-carousel-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'header_carousel_margin',
            [
                'label'      => esc_html__('Margin', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-heading-carousel-inner .elementor-heading-carousel-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'Horizontal_align',
            [
                'label'        => esc_html__('Horizontal Align', 'razox'),
                'type'         => Controls_Manager::CHOOSE,
                'options'      => [
                    'flex-start' => [
                        'title' => esc_html__('Left', 'razox'),
                        'icon'  => 'eicon-h-align-left',
                    ],
                    'center'     => [
                        'title' => esc_html__('Center', 'razox'),
                        'icon'  => 'eicon-h-align-center',
                    ],
                    'flex-end'   => [
                        'title' => esc_html__('Right', 'razox'),
                        'icon'  => 'eicon-h-align-right',
                    ],
                ],
                'prefix_class' => 'box-valign-',
                'separator'    => 'none',
                'selectors'    => [
                    '{{WRAPPER}} .elementor-heading-carousel-inner .elementor-heading-carousel-item' => 'justify-content:{{VALUE}} ;',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content_title_section_style',
            [
                'label' => esc_html__('Title', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'header_carousel_title_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-heading-carousel-item .header-carousel-title .header-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'header_carousel_title_color_hover',
            [
                'label'     => esc_html__('Color Hover', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-heading-carousel-item:hover .header-carousel-title .header-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .elementor-heading-carousel-item .header-carousel-title .header-title',
            ]
        );
        $this->add_responsive_control(
            'header_carousel_title_padding',
            [
                'label'      => esc_html__('Padding', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .elementor-heading-carousel-item .header-carousel-title ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'header_carousel_background',
                'selector' => '{{WRAPPER}} .elementor-heading-carousel-item-wrapper',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'header_carousel_icon_section_style',
            [
                'label' => esc_html__('Icon', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'icon_width',
            [
                'label'      => __('Size', 'razox'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 6,
                        'max' => 300,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .header-carousel-title .header-icon'     => 'width: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .header-carousel-title .header-icon svg' => 'width: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .header-carousel-title .header-icon i'   => 'font-size: {{SIZE}}{{UNIT}} !important;',

                ],
            ]
        );

        $this->start_controls_tabs('button_tabs');

        $this->start_controls_tab('button_normal',
            [
                'label' => esc_html__('Normal', 'razox'),
            ]
        );

        $this->add_control(
            'button_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .header-carousel-title .header-icon i'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .header-carousel-title .header-icon svg' => 'fill: {{VALUE}}; '],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button-hover',
            [
                'label' => esc_html__('Hover', 'razox'),
            ]
        );

        $this->add_control(
            'button_hover_icon_color',
            [
                'label'     => esc_html__('Icon Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .elementor-button:hover .elementor-button-icon i'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .elementor-button:hover .elementor-button-icon svg' => 'fill: {{VALUE}}; color: {{VALUE}};',
                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        $this->get_controls_column();
        // Carousel options
        $this->get_control_carousel();
    }

    protected function render(Widget_Base $instance = null) {
        if (empty($instance)) {
            $instance = $this;
        }
        $settings = $instance->get_settings_for_display();
        $migrated = isset($settings['__fa4_migrated']['selected_icon']);
        $is_new   = empty($settings['icon']) && Icons_Manager::is_migration_allowed();
        if (!$is_new && empty($settings['icon_align'])) {
            // @todo: remove when deprecated
            // added as bc in 2.6
            //old default
            $settings['icon_align'] = $instance->get_settings('icon_align');
        }
        if (!empty($settings['header_carousel']) && is_array($settings['header_carousel'])) {

            $this->add_render_attribute('wrapper', 'class', 'elementor-heading-carousel-item-wrapper');
            $this->get_data_elementor_columns();
            $this->add_render_attribute('inner', 'class', 'elementor-heading-carousel-inner');
            // Item
            $this->add_render_attribute('item', 'class', 'elementor-heading-carousel-item');
            ?>
            <div <?php $this->print_render_attribute_string('wrapper'); ?>>
                <div <?php $this->print_render_attribute_string('container'); ?>>
                    <div <?php $this->print_render_attribute_string('inner'); ?>>
                        <?php foreach ($settings['header_carousel'] as $item):

                            ?>

                            <div <?php $this->print_render_attribute_string('item'); ?> <?php $this->print_render_attribute_string('color'); ?>>
                                <div class="header-carousel-title">
                                    <?php if ($item['used_icon']): ?>
                                        <div class="header-icon">
                                            <?php
                                            if ($is_new || $migrated) {
                                                Icons_Manager::render_icon($item['selected_icon'], ['aria-hidden' => 'true']);
                                            }
                                            ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if (!empty($item['header_carousel_title'])) : ?>
                                        <h3 class="header-title" <?php $this->print_render_attribute_string('color-title'); ?>><?php echo esc_html($item["header_carousel_title"]) ?></h3>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php $this->get_swiper_navigation(count($settings['header_carousel'])); ?>
                </div>
            </div>
            <?php
        }
    }
}

$widgets_manager->register(new Razox_Elementor_Header_Carousel());