<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

if (!razox_is_woocommerce_activated()) {
    return;
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Razox\Elementor\Razox_Base_Widgets;

class Razox_Elementor_Product_Review extends Razox_Base_Widgets {

    public function get_name() {
        return 'razox-product-review';
    }

    public function get_title() {
        return esc_html__('Razox Product Review', 'razox');
    }

    public function get_icon() {
        return 'eicon-review';
    }

    public function get_script_depends() {
        return ['razox-elementor-product-reviews'];
    }

    public function get_style_depends(): array {
        return [ 'e-swiper' ];
    }

    public function get_categories() {
        return array('razox-addons');
    }

    protected function register_controls() {


        $this->start_controls_section('reviews_content',
            [
                'label' => esc_html__('Reviews', 'razox'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );


        $repeater = new Repeater();

        $repeater->add_control('review_id', [
            'label'       => esc_html__('Products Review', 'razox'),
            'type'        => 'products_review',
            'label_block' => true,
            'multiple'    => false,
        ]);

        $this->add_control('reviews',
            [
                'label'  => esc_html__('Reviews', 'razox'),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'style',
            [
                'label'        => esc_html__('Style', 'razox'),
                'type'         => Controls_Manager::SELECT,
                'default'      => '1',
                'options'      => [
                    '1' => esc_html__('Style 1', 'razox'),
                    '2' => esc_html__('Style 2', 'razox'),
                ],
                'prefix_class' => 'product-review-style-'
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_section_style',
            [
                'label' => esc_html__('Box', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label'      => esc_html__('Padding', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label'      => esc_html__('Margin', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(), [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .review-item',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_background',
            [
                'label'     => esc_html__('Background Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // image

        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__('Image', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'image_border',
                'selector'  => '{{WRAPPER}} .product-thumbnail',
                'separator' => 'before',
            ]
        );
        $this->add_responsive_control(
            'image_border_radius',
            [
                'label'      => esc_html__('Border radius', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .product-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_width',
            [
                'label'          => esc_html__('Width', 'razox'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'size_units'     => ['%', 'px', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .product-item .product-thumbnail img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_height',
            [
                'label'          => esc_html__('Height', 'razox'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'unit' => 'px',
                ],
                'size_units'     => ['px', 'vh'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 500,
                    ],
                    'vh' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .product-item .product-thumbnail img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_padding',
            [
                'label'      => esc_html__('Padding', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .product-item .product-thumbnail img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

        // icon

        $this->start_controls_section(
            'icon_style',
            [
                'label' => esc_html__('Icon', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label'      => esc_html__('Icon size', 'razox'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 30,
                        'max' => 500,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-meta .star-rating' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .review-meta .star-rating::before' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color_active',
            [
                'label'     => esc_html__('Color Active', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .review-meta .star-rating span::before' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        // title

        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__('Title', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // title product

        $this->add_control(
            'product_title_heading',
            [
                'label'     => esc_html__('Product', 'razox'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'tilte_typography',
                'label'    => esc_html__('Title', 'razox'),
                'selector' => '{{WRAPPER}} .product-caption .woocommerce-loop-product__title',
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label'      => esc_html__('Margin', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label'      => esc_html__('Padding', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('tab_title');
        $this->start_controls_tab(
            'tab_title_normal',
            [
                'label' => esc_html__('Normal', 'razox'),
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tab_title_hover',
            [
                'label' => esc_html__('Hover', 'razox'),
            ]
        );
        $this->add_control(
            'title_color_hover',
            [
                'label'     => esc_html__('Hover Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title: hover'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title: hover a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tabs();

        // review title

        $this->add_control(
            'review_title_heading',
            [
                'label'     => esc_html__('Review', 'razox'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'review_tilte_typography',
                'label'    => esc_html__('Title', 'razox'),
                'selector' => '{{WRAPPER}} .product-caption .woocommerce-loop-product__title',
            ]
        );

        $this->add_responsive_control(
            'review_title_margin',
            [
                'label'      => esc_html__('Margin', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'review_title_padding',
            [
                'label'      => esc_html__('Padding', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('review_tab_title');
        $this->start_controls_tab(
            'review_tab_title_normal',
            [
                'label' => esc_html__('Normal', 'razox'),
            ]
        );
        $this->add_control(
            'review_title_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'review_tab_title_hover',
            [
                'label' => esc_html__('Hover', 'razox'),
            ]
        );
        $this->add_control(
            'review_title_color_hover',
            [
                'label'     => esc_html__('Hover Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title: hover'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title: hover a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tabs();

        $this->end_controls_section();

        //meta

        $this->start_controls_section(
            'meta_title_style',
            [
                'label' => esc_html__('Meta', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        // title product

        $this->add_control(
            'name_title_heading',
            [
                'label'     => esc_html__('Name', 'razox'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'name_tilte_typography',
                'label'    => esc_html__('Title', 'razox'),
                'selector' => '{{WRAPPER}} .product-caption .woocommerce-loop-product__title',
            ]
        );

        $this->add_responsive_control(
            'name_title_margin',
            [
                'label'      => esc_html__('Margin', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'name_title_padding',
            [
                'label'      => esc_html__('Padding', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'name_title_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        // time title

        $this->add_control(
            'time_title_heading',
            [
                'label'     => esc_html__('Time', 'razox'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'time_tilte_typography',
                'label'    => esc_html__('Title', 'razox'),
                'selector' => '{{WRAPPER}} .product-caption .woocommerce-loop-product__title',
            ]
        );

        $this->add_responsive_control(
            'time_title_margin',
            [
                'label'      => esc_html__('Margin', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'time_title_padding',
            [
                'label'      => esc_html__('Padding', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors'  => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'time_title_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title'   => 'color: {{VALUE}};',
                    '{{WRAPPER}} .product-caption .woocommerce-loop-product__title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->get_controls_column();
        // Carousel options
        $this->get_control_carousel();
    }


    protected function render() {
        $settings = $this->get_settings_for_display();
        $this->get_data_elementor_columns();
        $this->add_render_attribute('wrapper', 'class', 'elementor-product-review-wrapper');

        // Item
        $this->add_render_attribute('item', 'class', 'elementor-categories-item');
        ?>
        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <div <?php $this->print_render_attribute_string('container'); ?>>
                <div <?php $this->print_render_attribute_string('inner'); ?>>
                    <?php
                    foreach ($settings['reviews'] as $index => $item) {
                        $review_id = $item['review_id'];
                        $review    = get_comment($review_id);
                        if ($review && $review->comment_type === 'review') {
                            $product_id = $review->comment_post_ID;
                            $product    = wc_get_product($product_id);
                            ?>
                            <div <?php $this->print_render_attribute_string('item'); ?>>
                                <div class="review-item">
                                    <?php
                                    echo '<div class="product-caption">';
                                    echo '<h4 class="woocommerce-loop-product__title"><a href="' . $product->get_permalink() . '">' . esc_html($product->get_name()) . '</a></h4>';
                                    //                                            echo '<span class="price">' . $product->get_price_html() . '</span>';
                                    echo '</div>';

                                    echo '<div class="review-content">' . esc_html($review->comment_content) . '</div>';
                                    ?>

                                    <div class="review-bottom">
                                        <div class="review-head">
                                            <?php woocommerce_review_display_gravatar($review); ?>
                                            <div class="review-meta">
                                                <?php
                                                $rating = intval(get_comment_meta($review_id, 'rating', true));
                                                if ($rating && wc_review_ratings_enabled()) {
                                                    echo wc_get_rating_html($rating);
                                                }
                                                echo '<span class="woocommerce-review__author">' . esc_html($review->comment_author) . '</span>';
                                                $review_date = date_i18n(get_option('date_format'), strtotime($review->comment_date));
                                                echo '<span class="woocommerce-review__published-date">' . esc_html($review_date) . '</span>';
                                                ?>
                                            </div>
                                        </div>

                                        <?php
                                        if ($settings['style'] == 1) {
                                            if ($product) {
                                                ?>
                                                <div class="product-item">
                                                    <?php
                                                    echo '<div class="product-thumbnail"><a href="' . $product->get_permalink() . '">' . $product->get_image('thumbnail') . '</a></div>';
                                                    ?>
                                                </div>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        }
                    }
                    ?>
                </div>
                <?php $this->get_swiper_navigation(count($settings['reviews'])); ?>
            </div>
        </div>
        <?php
    }


}

$widgets_manager->register(new Razox_Elementor_Product_Review());