<?php

//namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Group_Control_Image_Size;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Typography;

class Smartic_Elementor_Timeline extends Elementor\Widget_Base {

    public function get_name() {
        return 'razox-timeline';
    }

    public function get_title() {
        return esc_html__('Razox Timeline', 'razox');
    }

    public function get_categories() {
        return array('razox-addons');
    }

    public function get_script_depends() {
        return array('razox-elementor-timeline');
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_general',
            [
                'label' => esc_html__('General', 'razox'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'number_year',
            [
                'label'       => esc_html__('Year', 'razox'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => esc_html__('Year...', 'razox'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label'       => esc_html__('Title & Content', 'razox'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Timeline Title', 'razox'),
                'label_block' => true,
            ]


        );
        $repeater->add_control(
            'content',

            [
                'label'      => esc_html__('Content', 'razox'),
                'type'       => Controls_Manager::WYSIWYG,
                'default'    => esc_html__('Timeline Content', 'razox'),
                'show_label' => false,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label'   => esc_html__('Choose Image', 'razox'),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'timeline_list',
            [
                'label'       => esc_html__('Timeline Items', 'razox'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'number_year' => esc_html__('2020', 'razox'),
                        'title'       => esc_html__('Timeline #1', 'razox'),
                        'content'     => esc_html__('If you remember the very first time you have met with the person you love or your friend, it would be nice to let the person know that you still remember that very moment.', 'razox'),
                        'image'       => Utils::get_placeholder_image_src(),
                    ],
                    [
                        'number_year' => esc_html__('2021', 'razox'),
                        'title'       => esc_html__('Timeline #2', 'razox'),
                        'content'     => esc_html__('If you remember the very first time you have met with the person you love or your friend, it would be nice to let the person know that you still remember that very moment.', 'razox'),
                        'image'       => Utils::get_placeholder_image_src(),

                    ],
                    [
                        'number_year' => esc_html__('2023', 'razox'),
                        'title'       => esc_html__('Timeline #3', 'razox'),
                        'content'     => esc_html__('If you remember the very first time you have met with the person you love or your friend, it would be nice to let the person know that you still remember that very moment.', 'razox'),
                        'image'       => Utils::get_placeholder_image_src(),
                    ],
                ],
                'title_field' => '{{{ title }}}',

            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'wrapper_timeline',
            [
                'label' => esc_html__('Wrapper', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'wrapper',
            [
                'label'          => esc_html__('Width', 'razox'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'size_units'     => ['%', 'px', 'vw'],
                'range'          => [
                    '%'  => [
                        'min' => 1,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                    'vw' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors'      => [
                    '{{WRAPPER}} .elementor-timeline-wrapper' => 'max-width: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'wrapper_gap',
            [
                'label'          => esc_html__('Gap', 'razox'),
                'type'           => Controls_Manager::SLIDER,
                'default'        => [
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'unit' => 'px',
                ],
                'size_units'     => ['px'],
                'range'          => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ]
                ],
                'selectors'      => [
                    '{{WRAPPER}} .elementor-timeline-wrapper .item' => 'margin-bottom: {{SIZE}}{{UNIT}}; ',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'number_style',
            [
                'label' => esc_html__('Number', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'number_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .content .number'              => 'color: {{VALUE}};',
                ],

            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'number_typography',
                'selector' => '{{WRAPPER}} .content .number',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__('Title', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'title',
            [
                'label'     => esc_html__('Title', 'razox'),
                'type'      => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Title Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],

            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'title_typography',
                'selector' => '{{WRAPPER}} .title',
            ]
        );
        $this->add_responsive_control(
            'title_spacing_item',
            [
                'label'      => esc_html__('Spacing', 'razox'),
                'type'       => Controls_Manager::SLIDER,
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'content_style',
            [
                'label' => esc_html__('Content', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .description' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'content_typography',
                'selector' => '{{WRAPPER}} .description',
            ]
        );
        $this->end_controls_section();
    }


    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="elementor-timeline-wrapper">
            <span class="default-line"></span>
            <span class="draw-line" style="height: 517px;"></span>
            <?php foreach ($settings['timeline_list'] as $item): ?>
                <div class="item">
                    <div class="thumbnail">
                        <?php
                        echo Group_Control_Image_Size::get_attachment_image_html($item);
                        ?>
                    </div>
                    <div class="content-wrap">
                        <div class="inner">
                            <div class="thumbnail-mobile">
                                <?php
                                echo Group_Control_Image_Size::get_attachment_image_html($item);
                                ?>
                            </div>

                            <div class="content">
                                <span class="number"><?php echo esc_html($item['number_year']) ?></span>
                                <div class="content-block">
                                    <?php printf('<h3 class="title">%s</h3><div class="description">%s</div>', $item['title'], $item['content']); ?>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <?php
    }
}

$widgets_manager->register_widget_type(new Smartic_Elementor_Timeline());
