<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Icons_Manager;
use Elementor\Group_Control_Border;
use Elementor\Repeater;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;

class Razox_Video_Review extends Elementor\Widget_Base {


    public function get_name() {
        return 'razox-video-review';
    }

    public function get_title() {
        return esc_html__('Razox Video Review', 'razox');
    }

    public function get_icon() {
        return 'eicon-youtube';
    }

    public function get_script_depends() {
        return ['razox-elementor-video-review', 'magnific-popup'];
    }

    public function get_style_depends() {
        return ['magnific-popup'];
    }

    public function get_categories() {
        return array('razox-addons');
    }


    protected function register_controls() {
        $this->start_controls_section(
            'section_videos',
            [
                'label' => esc_html__('General', 'razox'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'video_link',
            [
                'label'       => esc_html__('Link Video', 'razox'),
                'type'        => Controls_Manager::TEXT,
                'description' => esc_html__('Support video from Youtube and Vimeo', 'razox'),
                'placeholder' => esc_html__('https://your-link.com', 'razox'),
            ]
        );

        $repeater->add_control(
            'video_name',
            [
                'label'   => esc_html__('Video name', 'razox'),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            ]
        );

        $repeater->add_control(
            'video_description',
            [
                'label'   => esc_html__('Description', 'razox'),
                'type'    => Controls_Manager::TEXT,
                'default' => '',
            ]
        );

        $repeater->add_control(
            'video_image_ava',
            [
                'label'      => esc_html__('Choose Avatar', 'razox'),
                'type'       => Controls_Manager::MEDIA,
                'show_label' => true,
            ]
        );

        $repeater->add_control(
            'video_image',
            [
                'label'      => esc_html__('Choose Image Poster', 'razox'),
                'type'       => Controls_Manager::MEDIA,
                //                'default'    => [
                //                    'url' => Utils::get_placeholder_image_src(),
                //                ],
                'show_label' => true,
            ]
        );

        $this->add_control(
            'video_reviews',
            [
                'label'       => esc_html__('Items', 'razox'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ video_name }}}',
            ]
        );

        $this->add_control(
            'video_icon',
            [
                'label'            => esc_html__('Icon', 'razox'),
                'type'             => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default'          => [
                    'value'   => 'fas fa-star',
                    'library' => 'fa-solid',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'      => 'video_image',
                'default'   => 'full',
                'separator' => 'none',
            ]
        );

        $this->add_control(
            'icon_effects',
            [
                'label'        => esc_html__('Effects', 'razox'),
                'type'         => Controls_Manager::SWITCHER,
                'condition'    => [
                    'video_icon[value]!' => '',
                ],
                'prefix_class' => 'video-icon-effects'
            ]
        );

        $this->end_controls_section();

        //Wrapper
        $this->start_controls_section(
            'section_video_wrapper',
            [
                'label' => esc_html__('Wrapper', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('tabs_wrapper_style');

        $this->start_controls_tab(
            'tab_wrapper_normal',
            [
                'label' => esc_html__('Normal', 'razox'),
            ]
        );

        $this->add_control(
            'background_wrapper',
            [
                'label'     => esc_html__('Background', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review-item-content' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_wrapper_hover',
            [
                'label' => esc_html__('Hover', 'razox'),
            ]
        );

        $this->add_control(
            'background_wrapper_hover',
            [
                'label'     => esc_html__('Background', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review-item-content:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'border_wrapper_hover',
            [
                'label'     => esc_html__('Border Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .review-item-content:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();


        $this->add_group_control(

            Group_Control_Border::get_type(),
            [
                'name'        => 'border_wrapper',
                'placeholder' => '1px',
                'default'     => '1px',
                'selector'    => '{{WRAPPER}} .review-item-content',
                'separator'   => 'before',
            ]
        );

        $this->add_control(
            'wrapper_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-item-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'wrapper_padding',
            [
                'label'      => esc_html__('Padding', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'wrapper_margin',
            [
                'label'      => esc_html__('Margin', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-item-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_gap',
            [
                'label'     => esc_html__('Gap', 'razox'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .razox-video-review' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_review_height',
            [
                'label'     => esc_html__('Height', 'razox'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .razox-video-review .video_list_right .review-item-video' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .razox-video-review .video_list_left'                     => 'max-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        //Icon
        $this->start_controls_section(
            'section_video_style',
            [
                'label'     => esc_html__('Icon', 'razox'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'video_icon[value]!' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_size',
            [
                'label'     => esc_html__('Font Size', 'razox'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition' => [
                    'video_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-video-review .elementor-video-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_width_svg',
            [
                'label'     => esc_html__('Width SVG', 'razox'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 250,
                    ],
                ],
                'condition' => [
                    'video_icon[value]!' => '',
                ],

                'selectors' => [
                    '{{WRAPPER}} .elementor-video-review .elementor-video-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_height_svg',
            [
                'label'     => esc_html__('Height SVG', 'razox'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 250,
                    ],
                ],
                'condition' => [
                    'video_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-video-review .elementor-video-icon svg' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_width',
            [
                'label'     => esc_html__('Width', 'razox'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'condition' => [
                    'video_icon[value]!' => '',
                ],

                'selectors' => [
                    '{{WRAPPER}} .elementor-video-review .elementor-video-icon' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'video_height',
            [
                'label'     => esc_html__('Height', 'razox'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 250,
                    ],
                ],
                'condition' => [
                    'video_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .elementor-video-review .elementor-video-icon' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('tabs_video_style');

        $this->start_controls_tab(
            'tab_video_normal',
            [
                'label'     => esc_html__('Normal', 'razox'),
                'condition' => [
                    'video_icon[value]!' => '',
                ],
            ]
        );

        $this->add_control(
            'video_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'video_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .razox-video-review .elementor-video-icon '    => 'color: {{VALUE}};',
                    '{{WRAPPER}} .razox-video-review .elementor-video-icon svg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'video_background_color',
            [
                'label'     => esc_html__('Background Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'video_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}} .razox-video-review .elementor-video-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_video_hover',
            [
                'label'     => esc_html__('Hover', 'razox'),
                'condition' => [
                    'video_icon[value]!' => '',
                ],
            ]
        );

        $this->add_control(
            'video_hover_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'video_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}}  .elementor-video-icon:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'video_hover_background_color',
            [
                'label'     => esc_html__('Background Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'condition' => [
                    'video_icon[value]!' => '',
                ],
                'selectors' => [
                    '{{WRAPPER}}  .elementor-video-icon:hover' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'video_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'razox'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .review-item-content .elementor-video-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        //title
        $this->start_controls_section(
            'section_video_title',
            [
                'label' => esc_html__('Title', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .razox-video-review .elementor-video-title' => 'color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label'     => esc_html__('Color Hover', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .review-item-content:hover .elementor-video-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'typography',
                //'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .razox-video-review .elementor-video-title',
            ]
        );
        $this->add_responsive_control(
            'title_spacing',
            [
                'label'     => __('Spacing', 'razox'),
                'type'      => Controls_Manager::SLIDER,
                'range'     => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .razox-video-review .elementor-video-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_video_description',
            [
                'label' => esc_html__('Description', 'razox'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'description_color',
            [
                'label'     => esc_html__('Color', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .razox-video-review .elementor-video-description' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->add_control(
            'description_hover_color',
            [
                'label'     => esc_html__('Color Hover', 'razox'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}}:hover .razox-video-review .elementor-video-description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'typography_description',
                //'scheme' => Scheme_Typography::TYPOGRAPHY_1,
                'selector' => '{{WRAPPER}} .razox-video-review .elementor-video-description',
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {
        $settings = $this->get_settings_for_display();

//        if (empty($repeater['video_link'])) {
//            return;
//        }

        $this->add_render_attribute('wrapper', 'class', 'elementor-video-wrapper');
        $this->add_render_attribute('wrapper', 'class', 'razox-video-review');
        $this->add_render_attribute('wrapper', 'data-count', count($settings['video_reviews']));

//        $this->add_render_attribute('item-content', 'class', 'review-item-content');
        $this->add_render_attribute('details', 'class', 'details');

//        $this->add_render_attribute('item-video', 'class', 'review-item-video');
        $this->add_render_attribute('details', 'class', 'details');


        $this->add_render_attribute('video-icon', 'class', 'elementor-video-icon');
//        $titleHtml = !empty($repeater['title']) ? '<span class="elementor-video-title">' . $repeater['title'] . '</span>' : '';
        $this->add_render_attribute('title', 'class', ['elementor-video-title',]);
        $this->add_render_attribute('description', 'class', ['elementor-video-description',]);

        ?>
        <div <?php $this->print_render_attribute_string('wrapper'); ?>>
            <div class="video_list_left">
                <?php foreach ($settings['video_reviews'] as $index => $videoitem): ?>
                    <div class="review-item-content <?php echo esc_attr(($index === 0) ? 'active' : ''); ?>">
                        <?php $this->render_image_1($settings, $videoitem); ?>
                        <div class="video-content">

                            <?php if (!empty($videoitem['video_name'])) : ?>
                                <div <?php $this->print_render_attribute_string('title'); ?>>
                                    <?php echo esc_html($videoitem["video_name"]) ?>
                                </div>
                            <?php endif; ?>

                            <?php if (!empty($videoitem['video_description'])) : ?>
                                <div <?php $this->print_render_attribute_string('description'); ?>>
                                    <?php echo esc_html($videoitem["video_description"]) ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="video_list_right">
                <?php
                $this->add_render_attribute('button', 'class', 'elementor-video-review');
                $this->add_render_attribute('button', 'role', 'button');
                $this->add_render_attribute('button', 'data-effect', 'mfp-zoom-in');
                ?>
                <?php foreach ($settings['video_reviews'] as $index => $videoitem): ?>
                    <div class="review-item-video <?php echo esc_attr(($index === 0) ? 'active' : ''); ?>">
                        <a <?php $this->print_render_attribute_string('button'); ?> href="<?php echo esc_url($videoitem['video_link']); ?>">
                            <?php $this->render_image_2($settings, $videoitem); ?>
                            <span <?php $this->print_render_attribute_string('video-icon'); ?>>
                                    <span class="animation"> </span>
                                    <?php Icons_Manager::render_icon($settings['video_icon'], ['aria-hidden' => 'true']); ?>
                                </span>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }

    private function render_image_1($settings, $videoitem) {
        if (!empty($videoitem['video_image']['url'])) :
            ?>
            <div class="elementor-videoimage-image-ava">
                <?php
                $videoitem['video_image_size']             = $settings['video_image_size'];
                $videoitem['video_image_custom_dimension'] = $settings['video_image_custom_dimension'];
                echo Group_Control_Image_Size::get_attachment_image_html($videoitem, 'video_image_ava');
                ?>
            </div>
        <?php
        endif;
    }

    private function render_image_2($settings, $videoitem) {
        if (!empty($videoitem['video_image']['url'])) :
            ?>
            <div class="elementor-videoimage-image">
                <?php
                $videoitem['video_image_size']             = $settings['video_image_size'];
                $videoitem['video_image_custom_dimension'] = $settings['video_image_custom_dimension'];
                echo Group_Control_Image_Size::get_attachment_image_html($videoitem, 'video_image');
                ?>
            </div>
        <?php
        endif;
    }


}

$widgets_manager->register(new Razox_Video_Review());
