<?php

defined('ABSPATH') || exit();

/**
 * Razox_Megamenu_Walker
 *
 * extends Walker_Nav_Menu
 */
class Razox_Admin_Megamenu_Assets {

    public static function init() {
        add_action('admin_enqueue_scripts', array(__CLASS__, 'enqueue_scripts'));
        add_action('elementor/editor/after_enqueue_scripts', array(__CLASS__, 'add_scripts_editor'));
    }

    public static function add_scripts_editor() {
        if (isset($_REQUEST['razox-menu-editable']) && $_REQUEST['razox-menu-editable']) {
            wp_register_script('razox-elementor-menu', get_template_directory_uri() . '/inc/megamenu/assets/js/editor.js', [], RAZOX_VERSION);
            wp_enqueue_script('razox-elementor-menu');
        }
    }

    /**
     * enqueue scripts
     */
    public static function enqueue_scripts($page) {
        if ($page === 'nav-menus.php') {
            wp_enqueue_script('backbone');
            wp_enqueue_script('underscore');

            $suffix = '.min';
            wp_register_script(
                'jquery-elementor-select2',
                ELEMENTOR_ASSETS_URL . 'lib/e-select2/js/e-select2.full' . $suffix . '.js',
                [
                    'jquery',
                ],
                '4.0.6-rc.1',
                true
            );
            wp_enqueue_script('jquery-elementor-select2');
            wp_register_style(
                'elementor-select2',
                ELEMENTOR_ASSETS_URL . 'lib/e-select2/css/e-select2' . $suffix . '.css',
                [],
                '4.0.6-rc.1'
            );
            wp_enqueue_style('elementor-select2');
            wp_enqueue_style('wp-color-picker');
            wp_enqueue_script('wp-color-picker');
            wp_register_script('razox-megamenu', get_template_directory_uri() . '/inc/megamenu/assets/js/admin.js', array(
                'jquery',
                'backbone',
                'underscore'
            ), RAZOX_VERSION, true);
            wp_localize_script('razox-megamenu', 'razox_memgamnu_params', apply_filters('razox_admin_megamenu_localize_scripts', array(
                'ajaxurl' => admin_url('admin-ajax.php'),
                'i18n'    => array(
                    'close'  => esc_html__('Close', 'razox'),
                    'submit' => esc_html__('Save', 'razox')
                ),
                'nonces'  => array(
                    'load_menu_data' => wp_create_nonce('razox-menu-data-nonce')
                )
            )));
            wp_enqueue_script('razox-megamenu');

            wp_enqueue_style('razox-megamenu', get_template_directory_uri() . '/inc/megamenu/assets/css/admin.css', [], RAZOX_VERSION);
            wp_enqueue_style('razox-icon', get_template_directory_uri() . '/assets/css/icons.css', '', RAZOX_VERSION);
        }

    }

}

Razox_Admin_Megamenu_Assets::init();
