<?php

class Razox_Merlin_Config {

    private $wizard;

    public function __construct() {
        $this->init();
        add_filter('merlin_import_files', [$this, 'import_files']);
        add_action('merlin_after_all_import', [$this, 'after_import_setup'], 10, 1);
        add_filter('merlin_generate_child_functions_php', [$this, 'render_child_functions_php']);

        add_action('import_start', function () {
            add_filter('wxr_importer.pre_process.post_meta', [$this, 'fiximport_elementor'], 10, 1);
        });

        add_action('import_end', function () {
            update_option('elementor_experiment-container', 'active');
            update_option('elementor_experiment-nested-elements', 'active');
        });
    }

    public function fiximport_elementor($post_meta) {
        if ('_elementor_data' === $post_meta['key']) {
            $post_meta['value'] = wp_slash($post_meta['value']);
        }

        return $post_meta;
    }

    public function import_files() {
            
        return array(
            array(
                'import_file_name'           => 'home 1',
                'home'                       => 'home-1',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'homepage'                   => get_theme_file_path('/dummy-data/homepage/home-1.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_rev_slider_file_url' => 'http://source.wpopal.com/razox/dummy_data/revsliders/home-1/slider-1.zip',
                'import_more_revslider_file_url' => [],
                'import_lookbook_revslider_file_url' => [],
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home-1.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/razox/home-1',
                'elementor'                  => '{"system_colors":[{"_id":"primary","title":"Primary","color":"#DE3431"},{"_id":"secondary","title":"Secondary(Heading)","color":"#000000"},{"_id":"tertiary","title":"Tertiary","color":"#7FD07E"},{"_id":"text","title":"Text","color":"#555555"},{"_id":"accent","title":"Accent","color":"#222222"},{"_id":"border","title":"Border","color":"#DFE1E7"},{"_id":"lighter","title":"Lighter","color":"#888888"},{"_id":"dark","title":"Dark","color":"#000000"},{"_id":"highlight","title":"Highlight","color":"#FF922D"}],"custom_colors":[],"system_typography":[{"_id":"primary","title":"Primary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"600"},{"_id":"secondary","title":"Secondary(Heading)","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"},{"_id":"tertiary","title":"Tertiary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"400"},{"_id":"text","title":"Text","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"500"},{"_id":"accent","title":"Accent","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"}],"custom_typography":[],"default_generic_fonts":"Sans-serif","site_name":"Razox","site_description":"Gaming Gear WooCommerce Theme","page_title_selector":"h1.entry-title","activeItemIndex":1,"active_breakpoints":["viewport_mobile","viewport_mobile_extra","viewport_tablet","viewport_tablet_extra","viewport_laptop"],"viewport_md":768,"viewport_lg":1025,"container_width":{"unit":"px","size":1410,"sizes":[]},"space_between_widgets":{"column":"30","row":"30","isLinked":true,"unit":"px","size":30,"sizes":[]},"body_background_background":"classic","body_background_color":"#FFFFFF","colors_enable_styleguide_preview":"yes","mobile_browser_background":"#FFFFFF"}',
                'themeoptions'               => '{}',
            ),

            array(
                'import_file_name'           => 'home 2',
                'home'                       => 'home-2',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'homepage'                   => get_theme_file_path('/dummy-data/homepage/home-2.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_rev_slider_file_url' => 'http://source.wpopal.com/razox/dummy_data/revsliders/home-2/slider-1.zip',
                'import_more_revslider_file_url' => [],
                'import_lookbook_revslider_file_url' => [],
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home-2.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/razox/home-2',
                'elementor'                  => '{"system_colors":[{"_id":"primary","title":"Primary","color":"#DE3431"},{"_id":"secondary","title":"Secondary(Heading)","color":"#000000"},{"_id":"tertiary","title":"Tertiary","color":"#7FD07E"},{"_id":"text","title":"Text","color":"#555555"},{"_id":"accent","title":"Accent","color":"#222222"},{"_id":"border","title":"Border","color":"#DFE1E7"},{"_id":"lighter","title":"Lighter","color":"#888888"},{"_id":"dark","title":"Dark","color":"#000000"},{"_id":"highlight","title":"Highlight","color":"#FF922D"}],"custom_colors":[],"system_typography":[{"_id":"primary","title":"Primary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"600"},{"_id":"secondary","title":"Secondary(Heading)","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"},{"_id":"tertiary","title":"Tertiary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"400"},{"_id":"text","title":"Text","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"500"},{"_id":"accent","title":"Accent","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"}],"custom_typography":[],"default_generic_fonts":"Sans-serif","site_name":"Razox","site_description":"Gaming Gear WooCommerce Theme","page_title_selector":"h1.entry-title","activeItemIndex":1,"active_breakpoints":["viewport_mobile","viewport_mobile_extra","viewport_tablet","viewport_tablet_extra","viewport_laptop"],"viewport_md":768,"viewport_lg":1025,"container_width":{"unit":"px","size":1410,"sizes":[]},"space_between_widgets":{"column":"30","row":"30","isLinked":true,"unit":"px","size":30,"sizes":[]},"body_background_background":"classic","body_background_color":"#FFFFFF","colors_enable_styleguide_preview":"yes","mobile_browser_background":"#FFFFFF"}',
                'themeoptions'               => '{}',
            ),

            array(
                'import_file_name'           => 'home 3',
                'home'                       => 'home-3',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'homepage'                   => get_theme_file_path('/dummy-data/homepage/home-3.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_rev_slider_file_url' => 'http://source.wpopal.com/razox/dummy_data/revsliders/home-3/slider-2.zip',
                'import_more_revslider_file_url' => [],
                'import_lookbook_revslider_file_url' => [],
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home-3.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/razox/home-3',
                'elementor'                  => '{"system_colors":[{"_id":"primary","title":"Primary","color":"#DE3431"},{"_id":"secondary","title":"Secondary(Heading)","color":"#000000"},{"_id":"tertiary","title":"Tertiary","color":"#7FD07E"},{"_id":"text","title":"Text","color":"#555555"},{"_id":"accent","title":"Accent","color":"#222222"},{"_id":"border","title":"Border","color":"#DFE1E7"},{"_id":"lighter","title":"Lighter","color":"#888888"},{"_id":"dark","title":"Dark","color":"#000000"},{"_id":"highlight","title":"Highlight","color":"#FF922D"}],"custom_colors":[],"system_typography":[{"_id":"primary","title":"Primary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"600"},{"_id":"secondary","title":"Secondary(Heading)","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"},{"_id":"tertiary","title":"Tertiary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"400"},{"_id":"text","title":"Text","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"500"},{"_id":"accent","title":"Accent","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"}],"custom_typography":[],"default_generic_fonts":"Sans-serif","site_name":"Razox","site_description":"Gaming Gear WooCommerce Theme","page_title_selector":"h1.entry-title","activeItemIndex":1,"active_breakpoints":["viewport_mobile","viewport_mobile_extra","viewport_tablet","viewport_tablet_extra","viewport_laptop"],"viewport_md":768,"viewport_lg":1025,"container_width":{"unit":"px","size":1410,"sizes":[]},"space_between_widgets":{"column":"30","row":"30","isLinked":true,"unit":"px","size":30,"sizes":[]},"body_background_background":"classic","body_background_color":"#FFFFFF","colors_enable_styleguide_preview":"yes","mobile_browser_background":"#FFFFFF"}',
                'themeoptions'               => '{}',
            ),

            array(
                'import_file_name'           => 'home 4',
                'home'                       => 'home-4',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'homepage'                   => get_theme_file_path('/dummy-data/homepage/home-4.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_rev_slider_file_url' => 'http://source.wpopal.com/razox/dummy_data/revsliders/home-4/slider-1.zip',
                'import_more_revslider_file_url' => [],
                'import_lookbook_revslider_file_url' => [],
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home-4.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/razox/home-4',
                'elementor'                  => '{"system_colors":[{"_id":"primary","title":"Primary","color":"#DE3431"},{"_id":"secondary","title":"Secondary(Heading)","color":"#ffffff"},{"_id":"tertiary","title":"Tertiary","color":"#7FD07E"},{"_id":"text","title":"Text","color":"#ffffff"},{"_id":"accent","title":"Accent","color":"#fff"},{"_id":"border","title":"Border","color":"#363636"},{"_id":"lighter","title":"Lighter","color":"#ffffff"},{"_id":"dark","title":"Dark","color":"#111111"},{"_id":"highlight","title":"Highlight","color":"#FF8103"}],"custom_colors":[],"system_typography":[{"_id":"primary","title":"Primary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"600"},{"_id":"secondary","title":"Secondary(Heading)","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"},{"_id":"tertiary","title":"Tertiary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"400"},{"_id":"text","title":"Text","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"500"},{"_id":"accent","title":"Accent","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"}],"custom_typography":[],"default_generic_fonts":"Sans-serif","site_name":"Razox","site_description":"Gaming Gear WooCommerce Theme","page_title_selector":"h1.entry-title","activeItemIndex":1,"active_breakpoints":["viewport_mobile","viewport_mobile_extra","viewport_tablet","viewport_tablet_extra","viewport_laptop"],"viewport_md":768,"viewport_lg":1025,"container_width":{"unit":"px","size":1410,"sizes":[]},"space_between_widgets":{"column":"30","row":"30","isLinked":true,"unit":"px","size":30,"sizes":[]},"body_background_background":"classic","body_background_color":"#181818","colors_enable_styleguide_preview":"yes","mobile_browser_background":"#FFFFFF"}',
                'themeoptions'               => '{}',
            ),

            array(
                'import_file_name'           => 'home 5',
                'home'                       => 'home-5',
                'local_import_file'          => get_theme_file_path('/dummy-data/content.xml'),
                'homepage'                   => get_theme_file_path('/dummy-data/homepage/home-5.xml'),
                'local_import_widget_file'   => get_theme_file_path('/dummy-data/widgets.json'),
                'import_rev_slider_file_url' => 'http://source.wpopal.com/razox/dummy_data/revsliders/home-5/slider-2.zip',
                'import_more_revslider_file_url' => [],
                'import_lookbook_revslider_file_url' => [],
                'import_preview_image_url'   => get_theme_file_uri('/assets/images/oneclick/home-5.jpg'),
                'preview_url'                => 'https://demo2.pavothemes.com/razox/home-5',
                'elementor'                  => '{"system_colors":[{"_id":"primary","title":"Primary","color":"#DE3431"},{"_id":"secondary","title":"Secondary(Heading)","color":"#ffffff"},{"_id":"tertiary","title":"Tertiary","color":"#7FD07E"},{"_id":"text","title":"Text","color":"#ffffff"},{"_id":"accent","title":"Accent","color":"#fff"},{"_id":"border","title":"Border","color":"#363636"},{"_id":"lighter","title":"Lighter","color":"#ffffff"},{"_id":"dark","title":"Dark","color":"#111111"},{"_id":"highlight","title":"Highlight","color":"#FF8103"}],"custom_colors":[],"system_typography":[{"_id":"primary","title":"Primary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"600"},{"_id":"secondary","title":"Secondary(Heading)","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"},{"_id":"tertiary","title":"Tertiary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"400"},{"_id":"text","title":"Text","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"500"},{"_id":"accent","title":"Accent","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"}],"custom_typography":[],"default_generic_fonts":"Sans-serif","site_name":"Razox","site_description":"Gaming Gear WooCommerce Theme","page_title_selector":"h1.entry-title","activeItemIndex":1,"active_breakpoints":["viewport_mobile","viewport_mobile_extra","viewport_tablet","viewport_tablet_extra","viewport_laptop"],"viewport_md":768,"viewport_lg":1025,"container_width":{"unit":"px","size":1410,"sizes":[]},"space_between_widgets":{"column":"30","row":"30","isLinked":true,"unit":"px","size":30,"sizes":[]},"body_background_background":"classic","body_background_color":"#181818","colors_enable_styleguide_preview":"yes","mobile_browser_background":"#FFFFFF"}',
                'themeoptions'               => '{}',
            ),

        );           
    }// end import_files

    public function after_import_setup($selected_import) {
        $selected_import = ($this->import_files())[$selected_import];

        // setup Home page
        $home = get_page_by_path($selected_import['home']);
        if ($home->ID) {
            update_option('show_on_front', 'page');
            update_option('page_on_front', $home->ID);
        }

        $this->set_demo_menus();

        // Setup Options
        $options       = $this->get_all_options();
        $theme_options = $options['options'];
        foreach ($theme_options as $key => $option) {
            update_option($key, $option);
        }

        $active_kit_id = Elementor\Plugin::$instance->kits_manager->get_active_id();
        update_post_meta($active_kit_id, '_elementor_page_settings', json_decode($selected_import['elementor'], true));
        set_theme_mod('custom_logo', $this->get_attachment('_logo'));

        // Header Footer Builder
        $this->reset_header_footer();
        $this->set_hf($selected_import['home']);


        //if exists, assign to $cpt_support var
        $cpt_support = get_option('elementor_cpt_support');
        //check if option DOESN'T exist in db
        if (!$cpt_support) {
            $cpt_support = ['page', 'post', 'razox_class', 'razox_event', 'razox_program', 'razox_teacher',]; //create array of our default supported post types
            update_option('elementor_cpt_support', $cpt_support); //write it to the database
        } //if it DOES exist, but portfolio is NOT defined
        else if (!in_array('razox_class', $cpt_support)) {
            $cpt_support[] = 'razox_class'; //append to array
            $cpt_support[] = 'razox_event'; //append to array
            $cpt_support[] = 'razox_program'; //append to array
            $cpt_support[] = 'razox_teacher'; //append to array
            update_option('elementor_cpt_support', $cpt_support); //update database
        }


        $this->remove_quick_table_enable();
        $this->update_page();
        $this->update_nav_menu_item('http://source.wpopal.com/razox');
        \Elementor\Utils::replace_urls('http://source.wpopal.com/razox', site_url());
        \Elementor\Plugin::instance()->files_manager->clear_cache();
    }

    private function update_nav_menu_item($url) {
        if (empty($url)) {
            return;
        }
        $from = trim($url);
        $to   = trim(site_url());

        $query = new WP_Query([
            'posts_per_page' => -1,
            'post_type'      => 'nav_menu_item',
        ]);
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $post_id = get_the_ID();

                wp_update_post([
                    'ID'         => $post_id,
                    'post_title' => get_the_title(),
                ]);

                if (get_post_meta($post_id, '_menu_item_type', true) === 'custom') {
                    $url = get_post_meta($post_id, '_menu_item_url', true);
                    if (!empty($url) && strpos($url, $from) !== false) {
                        update_post_meta($post_id, '_menu_item_url', esc_url_raw(str_replace($from, $to, $url)));
                    }
                }
            }
            wp_reset_postdata();
        }
    }

    private function update_page() {
        if (!class_exists('WooCommerce')) {
            return; // Exit if WooCommerce is not active
        }

        $pages = [
            [
                "ID"           => get_option('woocommerce_cart_page_id'),
                "post_content" => "<!-- wp:shortcode -->[woocommerce_cart]<!-- /wp:shortcode -->"
            ],
            [
                "ID"           => get_option('woocommerce_checkout_page_id'),
                "post_content" => "<!-- wp:shortcode -->[woocommerce_checkout]<!-- /wp:shortcode -->"
            ],
            [
                "ID"           => get_option('woocommerce_myaccount_page_id'),
                "post_content" => "<!-- wp:shortcode -->[woocommerce_my_account]<!-- /wp:shortcode -->"
            ]
        ];

        foreach ($pages as $page) {
            if (!empty($page['ID']) && get_post($page['ID'])) { // Ensure the page exists
                wp_update_post($page);
            }
        }
    }

    //remove quick_table_enable
    private function remove_quick_table_enable() {
        $qte = get_option('woosc_settings', []);

        if (!is_array($qte)) {
            $qte = [];
        }

        $qte['quick_table_enable'] = 'no';
        $qte['button_single']      = '0';

        update_option('woosc_settings', $qte);
    }

    private function get_mailchimp_id() {
        $params = array(
            'post_type'      => 'mc4wp-form',
            'posts_per_page' => 1,
        );
        $post   = get_posts($params);

        return isset($post[0]) ? $post[0]->ID : 0;
    }

    private function get_attachment($key) {
        $params = array(
            'post_type'      => 'attachment',
            'post_status'    => 'inherit',
            'posts_per_page' => 1,
            'meta_key'       => $key,
        );
        $post   = get_posts($params);
        if ($post) {
            return $post[0]->ID;
        }

        return 0;
    }

    private function init() {
        $this->wizard = new Merlin(
            $config = array(
                // Location / directory where Merlin WP is placed in your theme.
                'merlin_url'         => 'merlin',
                // The wp-admin page slug where Merlin WP loads.
                'parent_slug'        => 'themes.php',
                // The wp-admin parent page slug for the admin menu item.
                'capability'         => 'manage_options',
                // The capability required for this menu to be displayed to the user.
                'dev_mode'           => true,
                // Enable development mode for testing.
                'license_step'       => false,
                // EDD license activation step.
                'license_required'   => false,
                // Require the license activation step.
                'license_help_url'   => '',
                'directory'          => '/inc/merlin',
                // URL for the 'license-tooltip'.
                'edd_remote_api_url' => '',
                // EDD_Theme_Updater_Admin remote_api_url.
                'edd_item_name'      => '',
                // EDD_Theme_Updater_Admin item_name.
                'edd_theme_slug'     => '',
                // EDD_Theme_Updater_Admin item_slug.
            ),
            $strings = array(
                'admin-menu'          => esc_html__('Theme Setup', 'razox'),

                /* translators: 1: Title Tag 2: Theme Name 3: Closing Title Tag */
                'title%s%s%s%s'       => esc_html__('%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s', 'razox'),
                'return-to-dashboard' => esc_html__('Return to the dashboard', 'razox'),
                'ignore'              => esc_html__('Disable this wizard', 'razox'),

                'btn-skip'                 => esc_html__('Skip', 'razox'),
                'btn-next'                 => esc_html__('Next', 'razox'),
                'btn-start'                => esc_html__('Start', 'razox'),
                'btn-no'                   => esc_html__('Cancel', 'razox'),
                'btn-plugins-install'      => esc_html__('Install', 'razox'),
                'btn-child-install'        => esc_html__('Install', 'razox'),
                'btn-content-install'      => esc_html__('Install', 'razox'),
                'btn-import'               => esc_html__('Import', 'razox'),
                'btn-license-activate'     => esc_html__('Activate', 'razox'),
                'btn-license-skip'         => esc_html__('Later', 'razox'),

                /* translators: Theme Name */
                'license-header%s'         => esc_html__('Activate %s', 'razox'),
                /* translators: Theme Name */
                'license-header-success%s' => esc_html__('%s is Activated', 'razox'),
                /* translators: Theme Name */
                'license%s'                => esc_html__('Enter your license key to enable remote updates and theme support.', 'razox'),
                'license-label'            => esc_html__('License key', 'razox'),
                'license-success%s'        => esc_html__('The theme is already registered, so you can go to the next step!', 'razox'),
                'license-json-success%s'   => esc_html__('Your theme is activated! Remote updates and theme support are enabled.', 'razox'),
                'license-tooltip'          => esc_html__('Need help?', 'razox'),

                /* translators: Theme Name */
                'welcome-header%s'         => esc_html__('Welcome to %s', 'razox'),
                'welcome-header-success%s' => esc_html__('Hi. Welcome back', 'razox'),
                'welcome%s'                => esc_html__('This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.', 'razox'),
                'welcome-success%s'        => esc_html__('You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.', 'razox'),

                'child-header'         => esc_html__('Install Child Theme', 'razox'),
                'child-header-success' => esc_html__('You\'re good to go!', 'razox'),
                'child'                => esc_html__('Let\'s build & activate a child theme so you may easily make theme changes.', 'razox'),
                'child-success%s'      => esc_html__('Your child theme has already been installed and is now activated, if it wasn\'t already.', 'razox'),
                'child-action-link'    => esc_html__('Learn about child themes', 'razox'),
                'child-json-success%s' => esc_html__('Awesome. Your child theme has already been installed and is now activated.', 'razox'),
                'child-json-already%s' => esc_html__('Awesome. Your child theme has been created and is now activated.', 'razox'),

                'plugins-header'         => esc_html__('Install Plugins', 'razox'),
                'plugins-header-success' => esc_html__('You\'re up to speed!', 'razox'),
                'plugins'                => esc_html__('Let\'s install some essential WordPress plugins to get your site up to speed.', 'razox'),
                'plugins-success%s'      => esc_html__('The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.', 'razox'),
                'plugins-action-link'    => esc_html__('Advanced', 'razox'),

                'import-header'      => esc_html__('Import Content', 'razox'),
                'import'             => esc_html__('Let\'s import content to your website, to help you get familiar with the theme.', 'razox'),
                'import-action-link' => esc_html__('Advanced', 'razox'),

                'ready-header'      => esc_html__('All done. Have fun!', 'razox'),

                /* translators: Theme Author */
                'ready%s'           => esc_html__('Your theme has been all set up. Enjoy your new theme by %s.', 'razox'),
                'ready-action-link' => esc_html__('Extras', 'razox'),
                'ready-big-button'  => esc_html__('View your website', 'razox'),
                'ready-link-1'      => sprintf('<a href="%1$s" target="_blank">%2$s</a>', 'https://wordpress.org/support/', esc_html__('Explore WordPress', 'razox')),
                'ready-link-2'      => sprintf('<a href="%1$s" target="_blank">%2$s</a>', 'https://themebeans.com/contact/', esc_html__('Get Theme Support', 'razox')),
                'ready-link-3'      => sprintf('<a href="%1$s">%2$s</a>', admin_url('customize.php'), esc_html__('Start Customizing', 'razox')),
            )
        );
        if (razox_is_elementor_activated()) {
            add_action('widgets_init', [$this, 'widgets_init']);
        }
        if (class_exists('Monster_Widget')) {
            add_action('widgets_init', [$this, 'widget_monster']);
        }
    }

    public function widget_monster() {
        unregister_widget('Monster_Widget');
        require_once get_parent_theme_file_path('/inc/merlin/includes/monster-widget.php');
        register_widget('Razox_Monster_Widget');
    }

    public function widgets_init() {
        require_once get_parent_theme_file_path('/inc/merlin/includes/recent-post.php');
        require_once get_parent_theme_file_path('/inc/merlin/includes/class-widget-category-classes.php');
        register_widget('Razox_WP_Widget_Recent_Posts');
        register_widget('Razox_WP_Widget_Category_Classe');
        if (razox_is_woocommerce_activated()) {
            require_once get_parent_theme_file_path('/inc/merlin/includes/class-wc-widget-layered-nav.php');
            register_widget('Razox_Widget_Layered_Nav');
        }
    }

    private function get_all_header_footer() {
        return [
            'home-1' => [
                'header' => [
                    [
                        'slug'                         => 'header-1',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ],
                ],
                'footer' => [
                    [
                        'slug'                         => 'footer-1',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ]
                ]
            ],
            'home-2' => [
                'header' => [
                    [
                        'slug'                         => 'header-2',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ]
                ],
                'footer' => [
                    [
                        'slug'                         => 'footer-2',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ]
                ]
            ],
            'home-3' => [
                'header' => [
                    [
                        'slug'                         => 'header-3',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ]
                ],
                'footer' => [
                    [
                        'slug'                         => 'footer-2',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ]
                ]
            ],
            'home-4' => [
                'header' => [
                    [
                        'slug'                         => 'header-1',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ]
                ],
                'footer' => [
                    [
                        'slug'                         => 'footer-1',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ]
                ]
            ],
            'home-5' => [
                'header' => [
                    [
                        'slug'                         => 'header-1',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ]
                ],
                'footer' => [
                    [
                        'slug'                         => 'footer-1',
                        'ehf_target_include_locations' => ['rule' => ['basic-global'], 'specific' => []],
                    ]
                ]
            ]
        ];
    }


    private function reset_header_footer() {
        $footer_args = array(
            'post_type'      => 'elementor-hf',
            'posts_per_page' => -1,
            'meta_query'     => array(
                array(
                    'key'     => 'ehf_template_type',
                    'compare' => 'IN',
                    'value'   => ['type_footer', 'type_header']
                ),
            )
        );
        $footer      = new WP_Query($footer_args);
        while ($footer->have_posts()) : $footer->the_post();
            update_post_meta(get_the_ID(), 'ehf_target_include_locations', []);
            update_post_meta(get_the_ID(), 'ehf_target_exclude_locations', []);
        endwhile;
        wp_reset_postdata();
    }

    public function set_demo_menus() {
        $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

        set_theme_mod(
            'nav_menu_locations',
            array(
                'primary'  => $main_menu->term_id,
                'handheld' => $main_menu->term_id,
            )
        );
    }

    private function set_hf($home) {
        $all_hf = $this->get_all_header_footer();
        $datas  = $all_hf[$home];
        foreach ($datas as $item) {
            foreach ($item as $object) {
                $hf = get_page_by_path($object['slug'], OBJECT, 'elementor-hf');
                if ($hf) {
                    update_post_meta($hf->ID, 'ehf_target_include_locations', $object['ehf_target_include_locations']);
                    if (isset($object['ehf_target_exclude_locations'])) {
                        update_post_meta($hf->ID, 'ehf_target_exclude_locations', $object['ehf_target_exclude_locations']);
                    }
                }
            }
        }
    }

    public function render_child_functions_php() {
        $output
            = "<?php
/**
 * Theme functions and definitions.
 */
		 ";

        return $output;
    }

    public function get_all_options(){
        $options = [];
        $options['options']   = json_decode('{"razox_options_blog_sidebar":"right","razox_options_blog_style":"list","razox_options_blog_single_sidebar":"none","razox_options_woocommerce_archive_content_width":"default","razox_options_woocommerce_archive_layout":"default","razox_options_shop_banner":"banner-top-banner","razox_options_single_product_extra_description":"<ul>\n<li class=\"delivery\"><b>Free delivery</b> over  00</li>\n<li class=\"return\"><b>30 Days Return</b> Period</li>\n<li class=\"customer\"><b>Customer</b> support</li>\n</ul>","razox_options_single_product_gallery_layout":"vertical"}', true);
        $options['elementor']   = json_decode('{"system_colors":[{"_id":"primary","title":"Primary","color":"#DE3431"},{"_id":"secondary","title":"Secondary(Heading)","color":"#000000"},{"_id":"tertiary","title":"Tertiary","color":"#7FD07E"},{"_id":"text","title":"Text","color":"#555555"},{"_id":"accent","title":"Accent","color":"#222222"},{"_id":"border","title":"Border","color":"#DFE1E7"},{"_id":"lighter","title":"Lighter","color":"#888888"},{"_id":"dark","title":"Dark","color":"#000000"},{"_id":"highlight","title":"Highlight","color":"#FF922D"}],"custom_colors":[],"system_typography":[{"_id":"primary","title":"Primary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"600"},{"_id":"secondary","title":"Secondary(Heading)","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"},{"_id":"tertiary","title":"Tertiary","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"400"},{"_id":"text","title":"Text","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"500"},{"_id":"accent","title":"Accent","typography_typography":"custom","typography_font_family":"Rajdhani","typography_font_weight":"700"}],"custom_typography":[],"default_generic_fonts":"Sans-serif","site_name":"Razox","site_description":"Gaming Gear WooCommerce Theme","page_title_selector":"h1.entry-title","activeItemIndex":1,"active_breakpoints":["viewport_mobile","viewport_mobile_extra","viewport_tablet","viewport_tablet_extra","viewport_laptop"],"viewport_md":768,"viewport_lg":1025,"container_width":{"unit":"px","size":1410,"sizes":[]},"space_between_widgets":{"column":"30","row":"30","isLinked":true,"unit":"px","size":30,"sizes":[]},"body_background_background":"classic","body_background_color":"#FFFFFF","colors_enable_styleguide_preview":"yes","mobile_browser_background":"#FFFFFF"}', true);
        return $options;
    } // end get_all_options
}

return new Razox_Merlin_Config();
