<?php

class Razox_Age_Verification {
    private static $_instance = null;

    public static function instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;
    }

    /**
     * Constructor
     */
    public function __construct() {
        add_action('customize_register', array($this, 'customize_register'));
        add_action('wp_enqueue_scripts', array($this, 'enqueue_scripts'), 10);
        add_action('wp_footer', array($this, 'razox_avpublic_js'));
    }


    public function customize_register($wp_customize) {
        /**
         * Defining our own 'Display Options' section
         */
        $wp_customize->add_section(
            'razox_display_options',
            array(
                'title'    => esc_attr__('Age Verification', 'razox'),
                'priority' => 55,
            )
        );

        /* minAge */
        $wp_customize->add_setting(
            'razox_minAge',
            array(
                'default'           => '18',
                'sanitize_callback' => 'razox_sanitize_input',
                'transport'         => 'refresh',
            )
        );
        $wp_customize->add_control(
            'razox_minAge',
            array(
                'section'  => 'razox_display_options',
                'label'    => esc_attr__('Minimum age?', 'razox'),
                'type'     => 'number',
                'priority' => 7,
            )
        );

        /* Add setting for background image uploader. */
        $wp_customize->add_setting('razox_bgImage');

        /* Add control for background image uploader (actual uploader) */
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'razox_bgImage',
                array(
                    'label'    => esc_attr__('Background image', 'razox'),
                    'section'  => 'razox_display_options',
                    'settings' => 'razox_bgImage',
                    'priority' => 8
                )
            )
        );

        /* Add setting for logo uploader. */
        $wp_customize->add_setting('razox_logo');

        /* Add control for logo uploader (actual uploader) */
        $wp_customize->add_control(
            new WP_Customize_Image_Control(
                $wp_customize,
                'razox_logo',
                array(
                    'label'    => esc_attr__('Logo image', 'razox'),
                    'section'  => 'razox_display_options',
                    'settings' => 'razox_logo',
                    'priority' => 9
                )
            )
        );

        /* title */
        $wp_customize->add_setting(
            'razox_title',
            array(
                'default'           => esc_attr__('Are you over [age] years old?', 'razox'),
                'sanitize_callback' => 'razox_sanitize_input',
                'transport'         => 'refresh',
            )
        );
        $wp_customize->add_control(
            'razox_title',
            array(
                'section'  => 'razox_display_options',
                'label'    => esc_attr__('Title', 'razox'),
                'type'     => 'text',
                'priority' => 10,
            )
        );

        /* description */
        $wp_customize->add_setting(
            'razox_description',
            array(
                'default'           => esc_attr__('You must be of legal drinking age to buy our products. Age will be verified upon delivery through ID.', 'razox'),
                'sanitize_callback' => 'razox_sanitize_input',
                'transport'         => 'refresh',
            )
        );
        $wp_customize->add_control(
            'razox_description',
            array(
                'section'  => 'razox_display_options',
                'label'    => esc_attr__('Description', 'razox'),
                'type'     => 'textarea',
                'priority' => 11,
            )
        );

        /* Yes button */
        $wp_customize->add_setting(
            'razox_button_yes',
            array(
                'default'           => esc_attr__('Yes i am', 'razox'),
                'sanitize_callback' => 'razox_sanitize_input',
                'transport'         => 'refresh',
            )
        );
        $wp_customize->add_control(
            'razox_button_yes',
            array(
                'section'  => 'razox_display_options',
                'label'    => esc_attr__('Button yes text', 'razox'),
                'type'     => 'text',
                'priority' => 14,
            )
        );

        /* No button */
        $wp_customize->add_setting(
            'razox_button_no',
            array(
                'default'           => esc_attr__('No i am not', 'razox'),
                'sanitize_callback' => 'razox_sanitize_input',
                'transport'         => 'refresh',
            )
        );
        $wp_customize->add_control(
            'razox_button_no',
            array(
                'section'  => 'razox_display_options',
                'label'    => esc_attr__('Button no text', 'razox'),
                'type'     => 'text',
                'priority' => 13,
            )
        );

        /* Success/Failure message display time */
        $wp_customize->add_setting(
            'razox_message_display_time',
            array(
                'default'           => 2000,
                'sanitize_callback' => 'razox_sanitize_input',
                'transport'         => 'refresh',
            )
        );
        $wp_customize->add_control(
            'razox_message_display_time',
            array(
                'section'  => 'razox_display_options',
                'label'    => esc_attr__('Message display time (milliseconds)', 'razox'),
                'type'     => 'number',
                'priority' => 18,
            )
        );
        /* Success/Failure message display time */
        $wp_customize->add_setting(
            'razox_cookie_days',
            array(
                'default'           => 30,
                'sanitize_callback' => 'razox_sanitize_input',
                'transport'         => 'refresh',
            )
        );
        $wp_customize->add_control(
            'razox_cookie_days',
            array(
                'section'  => 'razox_display_options',
                'label'    => esc_attr__('Cookie (day)', 'razox'),
                'type'     => 'number',
                'priority' => 20,
            )
        );

        /* Show or Hide Blog Description */
        $wp_customize->add_setting(
            'razox_adminHide',
            array(
                'default'           => '',
                'sanitize_callback' => 'razox_sanitize_input',
                'transport'         => 'refresh',
            )
        );
        $wp_customize->add_control(
            'razox_adminHide',
            array(
                'section'  => 'razox_display_options',
                'label'    => esc_attr__('Hide for admin users?', 'razox'),
                'type'     => 'checkbox',
                'priority' => 99,
            )
        );

        /* Show or Hide Blog Description */
        $wp_customize->add_setting(
            'razox_Enable',
            array(
                'default'           => '',
                'sanitize_callback' => 'razox_sanitize_input',
                'transport'         => 'refresh',
            )
        );
        $wp_customize->add_control(
            'razox_Enable',
            array(
                'section'  => 'razox_display_options',
                'label'    => esc_attr__('Enable Age Verification', 'razox'),
                'type'     => 'checkbox',
                'priority' => 99,
            )
        );
    }

    public function enqueue_scripts() {
        if ('1' == get_theme_mod('razox_Enable')) {
            wp_enqueue_script('age-verification-cookie', get_template_directory_uri() . '/assets/js/frontend/js.cookie.js', array('jquery'), RAZOX_VERSION, false);
            wp_enqueue_script('age-verification', get_template_directory_uri() . '/assets/js/frontend/age-verification.js', array('jquery'), RAZOX_VERSION, false);
        }
    }

    function razox_avpublic_js() {
        $landing = apply_filters('razox_landing_id', '');
        // Empty redirect.
        $redirect_fail = '';

        // Set the redirect URL.
        $redirectOnFail = esc_url(apply_filters('razox_avredirect_on_fail_link', $redirect_fail));

        // Add content before popup contents.
        $beforeContent = apply_filters('razox_avbefore_popup_content', '');

        // Add content after popup contents.
        $afterContent = apply_filters('razox_avafter_popup_content', '');

        // Add JavaScript codes to footer based on setting in the Customizer.

        if ('1' != get_theme_mod('razox_Enable') || ('1' === get_theme_mod('razox_adminHide') && current_user_can('administrator')) || $landing === get_queried_object_id()) {
            // Do nothing.
        } else { ?>
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
                    $.razoxageCheck({
                        "bgImage": '<?php echo get_theme_mod('razox_bgImage', '') ?>',
                        "minAge": '<?php echo get_theme_mod('razox_minAge', '18')?>',
                        "imgLogo": '<?php echo get_theme_mod('razox_logo', '')?>',
                        "title": '<?php echo get_theme_mod('razox_title', 'Are you over [age] years old?')?>',
                        "description": '<?php echo get_theme_mod('razox_description', 'You must be of legal drinking age to buy our products. Age will be verified upon delivery through ID.')?>',
                        'btnYes': '<?php  echo get_theme_mod('razox_button_yes', esc_attr__('Yes i am', 'razox'))?>',
                        'btnNo': '<?php echo get_theme_mod('razox_button_no', esc_attr__('No i am not', 'razox'))?>',
                        "successTitle": '<?php echo esc_attr__('Success!', 'razox')?>',
                        "successText": '<?php echo esc_attr__('You are now being redirected back to the site ...', 'razox')?>',
                        "successMessage": '<?php echo get_theme_mod('razox_success_message', 'show')?>',
                        "failTitle": '<?php echo esc_attr__('Sorry!', 'razox')?>',
                        "failText": '<?php echo esc_attr__('You are not old enough to view the site ...', 'razox')?>',
                        "messageTime": '<?php echo get_theme_mod('razox_message_display_time', '2000')?>',
                        "cookieDays": '<?php echo get_theme_mod('razox_cookie_days', '30')?>',
                        "redirectOnFail": '<?php echo $redirectOnFail?>',
                        "beforeContent": '<?php echo $beforeContent?>',
                        "afterContent": '<?php echo $afterContent?>'
                    });
                });
            </script>
            <?php
        } // end adminHide check.
    }

}

Razox_Age_Verification::instance();