<?php
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('Razox_Color_Picker_In_Category.php')) {
    class Razox_Color_Picker_In_Category {
        public function __construct() {
            add_action('category_edit_form_fields', [$this, 'colorpicker_field_edit_category']);   // Variable Hook Name
            add_action('category_add_form_fields', [$this, 'colorpicker_field_add_new_category']);  // Variable Hook Name
            add_action('created_category', [$this, 'save_termmeta']);  // Variable Hook Name
            add_action('edited_category', [$this, 'save_termmeta']);  // Variable Hook Name
            add_action('admin_enqueue_scripts', [$this, 'category_colorpicker_enqueue']);
            add_action('in_admin_footer', [$this, 'colorpicker_init_inline'], 100);
        }

        /**
         * Add new colopicker field to "Edit Category" screen
         * - https://developer.wordpress.org/reference/hooks/taxonomy_add_form_fields/
         *
         * @param WP_Term_Object $term
         *
         * @return void
         */
        public function colorpicker_field_edit_category($term) {

            $color = get_term_meta($term->term_id, '_category_color', true);
            $color = (!empty($color)) ? "#{$color}" : '#ffffff';

            ?>

            <tr class="form-field term-colorpicker-wrap">
                <th scope="row">
                    <label for="term-colorpicker"><?php echo esc_html__('Severity Color', 'razox') ?></label>
                </th>
                <td>
                    <input name="_category_color" value="<?php echo $color; ?>" class="colorpicker" id="term-colorpicker"/>
                    <p class="description"><?php echo esc_html__('This is the field description where you can tell the user how the color is used in the theme.', 'razox') ?></p>
                </td>
            </tr>

            <?php
        }


        /**
         * Add new colorpicker field to "Add new Category" screen
         * - https://developer.wordpress.org/reference/hooks/taxonomy_add_form_fields/
         *
         * @param String $taxonomy
         *
         * @return void
         */
        public function colorpicker_field_add_new_category($taxonomy) {
            ?>
            <div class="form-field term-colorpicker-wrap">
                <label for="term-colorpicker"><?php echo esc_html__('Category Color', 'razox') ?></label>
                <input name="_category_color" value="#ffffff" class="colorpicker" id="term-colorpicker"/>
                <p><?php echo esc_html__('This is the field description where you can tell the user how the color is used in the theme.', 'razox') ?></p>
            </div>
            <?php
        }


        /**
         * Term Metadata - Save Created and Edited Term Metadata
         * - https://developer.wordpress.org/reference/hooks/created_taxonomy/
         * - https://developer.wordpress.org/reference/hooks/edited_taxonomy/
         *
         * @param Integer $term_id
         *
         * @return void
         */
        public function save_termmeta($term_id) {

            // Save term color if possible
            if (isset($_POST['_category_color']) && !empty($_POST['_category_color'])) {
                update_term_meta($term_id, '_category_color', sanitize_hex_color_no_hash($_POST['_category_color']));
            } else {
                delete_term_meta($term_id, '_category_color');
            }

        }

        /**
         * Enqueue colorpicker styles and scripts.
         * - https://developer.wordpress.org/reference/hooks/admin_enqueue_scripts/
         *
         * @return void
         */
        public function category_colorpicker_enqueue($taxonomy) {

            if (null !== ($screen = get_current_screen()) && 'edit-category' !== $screen->id) {

                return;
            }
            // Colorpicker Scripts
            wp_enqueue_script('wp-color-picker');

            // Colorpicker Styles
            wp_enqueue_style('wp-color-picker');

        }


        /**
         * Print javascript to initialize the colorpicker
         * - https://developer.wordpress.org/reference/hooks/admin_print_scripts/
         *
         * @return void
         */
        public function colorpicker_init_inline() {

            if (null !== ($screen = get_current_screen()) && 'edit-category' !== $screen->id) {
                return;
            }
            ?>

            <script type="text/javascript">
                (function ($) {
                    'use strict';
                    $(document).ready(function () {
                        $('.colorpicker').wpColorPicker();
                    });

                })(jQuery);

            </script>

            <?php
        }
    }
}
return new Razox_Color_Picker_In_Category();