<?php

namespace Razox;

use Razox\Razox_Custom_post_type;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

/**
 * Class Razox_Custom_Post_Type_Setting
 */
class Razox_Custom_Post_Type_Setting extends Razox_Custom_Post_Type {

    static $instance;

    public static function getInstance() {
        if (!isset(self::$instance) && !(self::$instance instanceof Razox_Custom_Post_Type_Setting)) {
            self::$instance = new Razox_Custom_Post_Type_Setting();
        }
        return self::$instance;
    }

    public function __construct() {
        parent::__construct();
        $this->setup();
    }

    public function getPosttypes() {
        return self::$posttypes;
    }

    public function setup() {
        $theme_support = array();
        foreach (self::$posttypes as $key => $posttype) {
            $theme_support[] = str_replace('razox_', '', $key);
        }
        add_theme_support('custom-post-types', $theme_support);
    }
}

Razox_Custom_Post_Type_Setting::getInstance();