<?php

namespace Razox;

class Razox_Custom_Post_Type {
    static $instance;
    public $prefix    = 'razox_options_';
    static $posttypes = array();
    public $args      = array();
    public $posttype;
    public $options;
    public $settings_key;

    public static function getInstance() {
        if (!isset(self::$instance) && !(self::$instance instanceof Razox_Custom_Post_Type)) {
            self::$instance = new Razox_Custom_Post_Type();
        }
        return self::$instance;
    }

    function __construct() {
        $this->options['posts_per_page'] = 8;
        if ($this->posttype) {
            $option_name        = str_replace('razox_', '', $this->posttype) . '_settings';
            $this->settings_key = str_replace('razox_', $this->prefix, $this->posttype) . '_settings';
            $this->args         = razox_get_theme_option($option_name, $this->options);
            foreach ( $this->options as $slug => $option ) {
                $this->args[$slug]           = isset($this->args[$slug]) ? $this->args[$slug] : $this->options[$slug];
            }

            add_action('admin_menu', array($this, 'add_admin_menu'));
            add_action('admin_init', array($this, 'register_settings'));

            $this->create_post_type($this->args);
            $this->create_taxonomy($this->args);
            add_action('cmb2_admin_init', array($this, 'create_meta_box'));
            add_filter('body_class', array($this, 'body_classes'), 30);
            add_filter('razox_theme_sidebar', array($this, 'set_sidebar'), 30);
            add_action('pre_get_posts', [$this, 'show_more_posts']);
            add_action('widgets_init', array($this, 'register_widget'));
        }
    }

    public function getposttypes() {
        if ($this->posttype) {
            self::$posttypes[$this->posttype] = $this->posttype;
        }
    }

    /**
     * @return void
     */
    public function create_post_type($args) {

        $labels = apply_filters(str_replace('_', '-', $this->posttype) . '-post-type-labels', array(
            'name'                  => $args['plural_name'],
            'singular_name'         => $args['singular_name'],
            'menu_name'             => $args['plural_name'],
            'add_new'               => esc_html__('Add New', 'razox'),
            'add_new_item'          => sprintf(__('Add New %s', 'razox'), $args['singular_name']),
            'edit_item'             => sprintf(__('Edit %s', 'razox'), $args['singular_name']),
            'new_item'              => sprintf(__('New %s', 'razox'), $args['singular_name']),
            'view_item'             => sprintf(__('View %s', 'razox'), $args['singular_name']),
            'view_items'            => sprintf(__('View %s', 'razox'), $args['plural_name']),
            'search_items'          => sprintf(__('Search %s', 'razox'), $args['plural_name']),
            'not_found'             => sprintf(__('No %s found', 'razox'), $args['plural_name']),
            'not_found_in_trash'    => sprintf(__('No %s found in Trash', 'razox'), $args['plural_name']),
            'parent_item_colon'     => sprintf(__('Parent %s:', 'razox'), $args['singular_name']),
            'all_items'             => sprintf(__('All %s', 'razox'), $args['plural_name']),
            'archives'              => sprintf(__('%s Archives', 'razox'), $args['singular_name']),
            'attributes'            => sprintf(__('%s Attributes', 'razox'), $args['singular_name']),
            'uploaded_to_this_item' => sprintf(__('Uploaded to this %s', 'razox'), $args['singular_name']),
            'filter_items_list'     => sprintf(__('Filter %s list', 'razox'), $args['plural_name']),
            'items_list_navigation' => sprintf(__('%s list navigation', 'razox'), $args['plural_name']),
            'items_list'            => sprintf(__('%s list', 'razox'), $args['plural_name']),
        ));

        $args = array(
            'labels'        => $labels,
            'public'        => true,
            'menu_position' => 5,
            'has_archive'   => true,
            'menu_icon'     => 'dashicons-admin-post',
            'supports'      => array('title', 'editor', 'thumbnail', 'excerpt'),
            'rewrite'       => array('slug' => $args['slug']),
        );
        register_post_type($this->posttype, $args);
    }

    /**
     * @return void
     */
    public function create_taxonomy($args) {

        $post_type = $this->posttype;
        $taxonomy  = $post_type . '_cat';
        $labels    = apply_filters(str_replace('_', '-', $post_type) . '-taxonomy-labels', array(
            'name'              => esc_html__('Categories', 'razox'),
            'singular_name'     => esc_html__('Category', 'razox'),
            'search_items'      => esc_html__('Search Category', 'razox'),
            'all_items'         => esc_html__('All Categories', 'razox'),
            'parent_item'       => esc_html__('Parent Category', 'razox'),
            'parent_item_colon' => esc_html__('Parent Category:', 'razox'),
            'edit_item'         => esc_html__('Edit Category', 'razox'),
            'update_item'       => esc_html__('Update Category', 'razox'),
            'add_new_item'      => esc_html__('Add New Category', 'razox'),
            'new_item_name'     => esc_html__('New Category Name', 'razox'),
            'menu_name'         => esc_html__('Categories', 'razox'),
        ));

        $args = array(
            'hierarchical'      => true,
            'labels'            => $labels,
            'show_ui'           => true,
            'show_admin_column' => true,
            'query_var'         => true,
            'show_in_nav_menus' => true,
            'rewrite'           => array('slug' => $args['slug_cat'])
        );
        // Now register the taxonomy
        register_taxonomy($taxonomy, array($post_type), $args);

    }

    /**
     * @return void
     */
    public function create_meta_box() {
    }

    /**
     * @return $option
     */
    public function register_widget($option) {
        if (!$this->posttype) return;
        $sidebar_args['sidebar-single-' . $this->posttype] = array(
            'name'        => esc_html__('Sidebar Single ' . $this->options['singular_name'], 'razox'),
            'id'          => 'sidebar-single-' . $this->posttype,
            'description' => '',
        );

        $sidebar_args = apply_filters('sidebar_' . $this->posttype . '_args', $sidebar_args);

        foreach ($sidebar_args as $sidebar => $args) {
            $widget_tags = array(
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget'  => '</div>',
                'before_title'  => '<span class="gamma widget-title">',
                'after_title'   => '</span>',
            );

            $filter_hook = sprintf('razox_%s_widget_tags', $sidebar);
            $widget_tags = apply_filters($filter_hook, $widget_tags);

            if (is_array($widget_tags)) {
                register_sidebar($args + $widget_tags);
            }
        }
    }

    /**
     * @return $name
     */
    public function set_sidebar($name) {
        if (is_singular($this->posttype)) {
            $name = '';
            if (is_active_sidebar('sidebar-single-' . $this->posttype)) {
                $name = 'sidebar-single-' . $this->posttype;
            }
        } elseif (is_post_type_archive($this->posttype) || is_tax($this->posttype . '_cat')) {
            $name = '';
            if (is_active_sidebar('sidebar-archive-' . $this->posttype)) {
                $name = 'sidebar-archive-' . $this->posttype;
            }
        }
        return $name;
    }

    public function body_classes($classes) {
        if (is_singular($this->posttype) || is_post_type_archive($this->posttype) || is_tax($this->posttype . '_cat')) {
            $classes = array_diff($classes, array(
                'razox-full-width-content',
                'razox-sidebar-none',
                'razox-sidebar-left',
                'razox-sidebar-right'
            ));
        }

        if (is_singular($this->posttype)) {
            if (!is_active_sidebar('sidebar-single-' . $this->posttype)) {
                $classes[] = 'razox-full-width-content';
            } else {
                $classes[] = 'razox-sidebar-' . razox_get_theme_option('blog_single_sidebar', 'right');
            }
        } elseif (is_post_type_archive($this->posttype) || is_tax($this->posttype . '_cat')) {
            if (!is_active_sidebar('sidebar-archive-' . $this->posttype)) {
                $classes[] = 'razox-full-width-content';
            } else {
                $classes[] = 'razox-sidebar-' . razox_get_theme_option('blog_single_sidebar', 'right');
            }
        }
        return $classes;
    }

    public function single_template($single) {
    }

    public function archive_template($archive) {
    }

    function show_more_posts($query) {

        if ($query->is_post_type_archive($this->posttype) && !is_admin() && $query->is_main_query())
            $query->set('posts_per_page', $this->args['posts_per_page']);
    }

    public function add_admin_menu() {
        add_submenu_page(
            'edit.php?post_type=' . $this->posttype,
            sprintf(__('%s Settings', 'razox'), $this->args['singular_name']),
            esc_html__('Settings', 'razox'),
            'manage_options',
            $this->posttype . '-settings',
            array($this, 'settings_page')
        );
    }


    public function settings_page() {
        ?>
        <div class="wrap">
            <h2><?php echo sprintf(__('%s Settings', 'razox'), $this->args['singular_name']); ?></h2>
            <form method="post" action="options.php">
                <?php
                settings_fields($this->settings_key);
                do_settings_sections($this->settings_key);
                submit_button();
                ?>
            </form>
        </div>
        <?php
    }

    public function register_settings() {
        register_setting(
            $this->settings_key,
            $this->settings_key,
            array($this, 'sanitize_settings')
        );

        add_settings_section(
            $this->posttype . '_settings_section',
            sprintf(__('%s Settings', 'razox'), $this->args['singular_name']),
            null,
            $this->settings_key
        );

        add_settings_field(
            'plural_name',
            esc_html__('Plural Name', 'razox'),
            array($this, 'name_field_callback'),
            $this->settings_key,
            $this->posttype . '_settings_section'
        );

        add_settings_field(
            'singular_name',
            esc_html__('Singular Name', 'razox'),
            array($this, 'singular_name_field_callback'),
            $this->settings_key,
            $this->posttype . '_settings_section'
        );

        add_settings_field(
            'slug',
            'Slug',
            array($this, 'slug_field_callback'),
            $this->settings_key,
            $this->posttype . '_settings_section'
        );
        add_settings_field(
            'slug_cat',
            'Slug Category',
            array($this, 'slug_cat_field_callback'),
            $this->settings_key,
            $this->posttype . '_settings_section'
        );
        add_settings_field(
            'posts_per_page',
            'Post Per Page',
            array($this, 'posts_per_page_field_callback'),
            $this->settings_key,
            $this->posttype . '_settings_section'
        );
    }


    public function sanitize_settings($input) {
        $sanitized = array();
        if (isset($input['plural_name'])) {
            $sanitized['plural_name'] = sanitize_text_field($input['plural_name']);
        }
        if (isset($input['singular_name'])) {
            $sanitized['singular_name'] = sanitize_text_field($input['singular_name']);
        }
        if (isset($input['slug'])) {
            $sanitized['slug'] = sanitize_title($input['slug']);
        }
        if (isset($input['slug_cat'])) {
            $sanitized['slug_cat'] = sanitize_title($input['slug_cat']);
        }
        if (isset($input['posts_per_page'])) {
            $sanitized['posts_per_page'] = sanitize_title($input['posts_per_page']);
        }
        if (isset($input['layout'])) {
            $sanitized['layout'] = sanitize_title($input['layout']);
        }
        apply_filters('razox_posttype_sanitize_settings', $sanitized);
        return $sanitized;
    }

    public function name_field_callback() {
        echo '<input type="text" name="' . $this->settings_key . '[plural_name]" value="' . esc_attr($this->args['plural_name']) . '" />';
    }

    public function singular_name_field_callback() {
        echo '<input type="text" name="' . $this->settings_key . '[singular_name]" value="' . esc_attr($this->args['singular_name']) . '" />';
    }

    public function slug_field_callback() {
        echo '<input type="text" name="' . $this->settings_key . '[slug]" value="' . esc_attr($this->args['slug']) . '" />';
    }

    public function slug_cat_field_callback() {
        echo '<input type="text" name="' . $this->settings_key . '[slug_cat]" value="' . esc_attr($this->args['slug_cat']) . '" />';
    }

    public function posts_per_page_field_callback() {
        echo '<input type="number" name="' . $this->settings_key . '[posts_per_page]" value="' . esc_attr($this->args['posts_per_page']) . '" />';
    }

}

new Razox_Custom_Post_Type();
