<?php

class Razox_WP_Widget_Category_Classe extends WP_Widget {
    public function __construct() {
        $widget_ops = array(
            'classname'                   => 'razox_widget_class_category widget_categories',
            'description'                 => __('Display Class Category', 'razox'),
            'customize_selective_refresh' => true,
        );
        parent::__construct('razox_widget_class_category', __('Razox Class Category', 'razox'), $widget_ops);
        $this->alt_option_name = 'razox_widget_class_category';
    }

    function form($instance) {
        $instance = wp_parse_args(
            (array)$instance,
            array(
                'title' => '',
                'count' => 0,
            )
        );

        if ($instance && isset($instance['title'])) {
            $title = $instance['title'];
        } else {
            $title = esc_html__('Categories', 'razox');
        }
        ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php esc_html_e('Title:', 'razox'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>"/>
        </p>
        <p>
            <input class="checkbox" type="checkbox"<?php checked($instance['count']); ?> id="<?php echo $this->get_field_id('count'); ?>" name="<?php echo $this->get_field_name('count'); ?>"/>
            <label for="<?php echo $this->get_field_id('count'); ?>"><?php _e('Show post counts', 'razox'); ?></label>
        </p>

        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance          = $old_instance;
        $new_instance      = wp_parse_args(
            (array)$new_instance,
            array(
                'title' => '',
                'count' => 0,
            )
        );
        $instance['title'] = sanitize_text_field($new_instance['title']);
        $instance['count'] = $new_instance['count'] ? 1 : 0;

        return $instance;
    }

    public function widget($args, $instance) {
        $title = !empty($instance['title']) ? $instance['title'] : esc_html__('Categories', 'razox');
        $count = !empty($instance['count']) ? '1' : '0';
        /** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
        $title = apply_filters('widget_title', $title, $instance, $this->id_base);

        echo $args['before_widget'];
        if ($title) {
            echo $args['before_title'] . $title . $args['after_title'];
        }

        echo '<ul>';
        wp_list_categories([
            'taxonomy'   => 'razox_class_cat',
            'title_li'   => '',
            'show_count' => $count,
        ]);
        echo '</ul>';

        echo $args['after_widget'];
    }
}