(function ($) {
    'use strict';
    var $razox_apply = $('#razox_apply');
    razox_terms_select();
    razox_conditional_init();
    razox_conditional_select();
    razox_labels_select();

    $('.color-picker').wpColorPicker();

    $razox_apply.on('change', function() {
        var apply = $(this).val();
        var $terms = $('#razox_terms');

        $('#razox_configuration_combination').hide();
        $('#razox_configuration_terms').hide();

        if (apply === '' || apply === 'none' || apply === 'all' || apply ===
            'sale' || apply === 'featured' || apply === 'bestselling' || apply ===
            'instock' || apply === 'outofstock' || apply === 'backorder') {
            return;
        }

        if (apply === 'combination') {
            $('#razox_configuration_combination').show();
            return;
        }

        $('#razox_configuration_terms').show();

        if ((typeof $terms.data(apply) === 'string' || $terms.data(apply) instanceof
            String) && $terms.data(apply) !== '') {
            $terms.val($terms.data(apply).split(',')).change();
        } else {
            $terms.val([]).change();
        }

        razox_terms_select();
    });

    function razox_terms_select() {
        var apply = $razox_apply.val();
        var label = $razox_apply.find(':selected').text().trim();

        $('#razox_configuration_terms_label').html(label);

        $('#razox_terms').selectWoo({
            ajax: {
                url: ajaxurl, dataType: 'json', delay: 250, data: function(params) {
                    return {
                        q: params.term,
                        action: 'razox_search_term',
                        nonce: razox_vars.nonce,
                        taxonomy: apply,
                    };
                }, processResults: function(data) {
                    var options = [];
                    if (data) {
                        $.each(data, function(index, text) {
                            options.push({id: text[0], text: text[1]});
                        });
                    }
                    return {
                        results: options,
                    };
                }, cache: true,
            }, minimumInputLength: 1,
        });
    }

    $(document).on('click touch', '.razox_add_conditional', function(e) {
        e.preventDefault();

        var $this = $(this);

        $this.addClass('disabled');

        var data = {
            action: 'razox_add_conditional', nonce: razox_vars.nonce,
        };

        $.post(ajaxurl, data, function(response) {
            $('.razox_conditionals').append(response);
            razox_conditional_init();
            $this.removeClass('disabled');
        });
    });

    function razox_conditional_init() {
        $('.razox_conditional_apply').each(function() {
            var $this = $(this);
            var $value = $this.closest('.razox_conditional').
            find('.razox_conditional_value');
            var $select_wrap = $this.closest('.razox_conditional').
            find('.razox_conditional_select_wrap');
            var $select = $this.closest('.razox_conditional').
            find('.razox_conditional_select');
            var $compare = $this.closest('.razox_conditional').
            find('.razox_conditional_compare');
            var apply = $this.val();
            var compare = $compare.val();

            if (apply === 'sale' || apply === 'featured' || apply === 'bestselling' ||
                apply === 'instock' || apply === 'outofstock' || apply ===
                'backorder') {
                $compare.hide();
                $value.hide();
                $select_wrap.hide();
            } else {
                $compare.show();

                if (apply === 'price' || apply === 'rating' || apply === 'release') {
                    $select_wrap.hide();
                    $value.show();
                    $compare.find('.razox_conditional_compare_price option').
                    prop('disabled', false);
                    $compare.find('.razox_conditional_compare_terms option').
                    prop('disabled', true);

                    if (compare === 'is' || compare === 'is_not') {
                        $compare.val('equal').trigger('change');
                    }
                } else {
                    $select_wrap.show();
                    $value.hide();
                    $compare.find('.razox_conditional_compare_price option').
                    prop('disabled', true);
                    $compare.find('.razox_conditional_compare_terms option').
                    prop('disabled', false);

                    if (compare !== 'is' && compare !== 'is_not') {
                        $compare.val('is').trigger('change');
                    }
                }
            }

            if ($value.data(apply) !== '') {
                $value.val($value.data(apply));
            }

            if ((typeof $select.data(apply) === 'string' ||
                $select.data(apply) instanceof String) && $select.data(apply) !==
                '') {
                $select.val($select.data(apply).split(',')).change();
            } else {
                $select.val([]).change();
            }
        });
    }

    function razox_conditional_select() {
        $('.razox_conditional_select').each(function() {
            var $this = $(this);
            var apply = $this.closest('.razox_conditional').
            find('.razox_conditional_apply').
            val();

            $this.selectWoo({
                ajax: {
                    url: ajaxurl, dataType: 'json', delay: 250, data: function(params) {
                        return {
                            action: 'razox_search_term',
                            nonce: razox_vars.nonce,
                            q: params.term,
                            taxonomy: apply,
                        };
                    }, processResults: function(data) {
                        var options = [];
                        if (data) {
                            $.each(data, function(index, text) {
                                options.push({id: text[0], text: text[1]});
                            });
                        }
                        return {
                            results: options,
                        };
                    }, cache: true,
                }, minimumInputLength: 1,
            });
        });
    }

    function razox_labels_select() {
        $('#razox_labels').selectWoo({
            ajax: {
                url: ajaxurl, dataType: 'json', delay: 250, data: function(params) {
                    return {
                        action: 'razox_search_labels',
                        nonce: razox_vars.nonce,
                        q: params.term,
                    };
                }, processResults: function(data) {
                    var options = [];
                    if (data) {
                        $.each(data, function(index, text) {
                            options.push({id: text[0], text: text[1]});
                        });
                    }
                    return {
                        results: options,
                    };
                }, cache: true,
            }, minimumInputLength: 1, select: function(e) {
                var element = e.params.data.element;
                var $element = $(element);

                $(this).append($element);
                $(this).trigger('change');
            },
        });
    }

    $(document).on('change', '.razox_conditional_apply', function() {
        razox_conditional_init();
        razox_conditional_select();
    });

    $(document).on('click touch', '.razox_conditional_remove', function(e) {
        e.preventDefault();

        $(this).closest('.razox_conditional').remove();
    });

})(jQuery);