<?php
/**
 * Razox WooCommerce Settings Class
 *
 * @package  aro
 * @since    2.4.3
 */

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Razox_WooCommerce_Settings')) :

    /**
     * The Razox WooCommerce Settings Class
     */
    class Razox_WooCommerce_Settings {
        protected static $sizechart = array();

        public function __construct() {
            if (razox_is_elementor_activated()) {
                self::getsizechart();
                add_action('add_meta_boxes', [$this, 'create_product_meta_box']);

                add_filter('woocommerce_product_data_tabs', array($this, 'settings_product_tabs'));
                add_filter('woocommerce_product_data_panels', array($this, 'settings_options_product_tab_content'));
                add_action('woocommerce_process_product_meta', array($this, 'save_settings_option_fields'));

                add_action('woocommerce_single_product_summary', array($this, 'render_sizechart_button'), 25);
                add_action('wp_footer', array($this, 'render_sizechart_template'), 1);
                add_action('wp_enqueue_scripts', [$this, 'add_css']);

                add_filter('woocommerce_product_tabs', [$this, 'add_technical_specs_product_tab'], 20, 1);
            }
        }


        function add_technical_specs_product_tab($tabs) {
            global $product;
            if ($product->get_meta('_specifications') !== '') {

                $tabs['additional_information'] = array(
                    'title'    => esc_html__('Specifications', 'razox'),
                    'priority' => 20,
                    'callback' => [$this, 'display_technical_specs_product_tab_content']

                );
            }

            return $tabs;
        }


        public function display_technical_specs_product_tab_content() {
            global $product;
            ?>
            <div class="wrapper-technical_specs">
                <h2 class="woocommerce-additional-title"><?php echo esc_html__('Specifications', 'razox'); ?></h2>
                <?php echo razox_parse_text_editor($product->get_meta('_specifications')) ?>
            </div>

            <?php
        }


        public function content_meta_box_specifications($post) {
            $product = wc_get_product($post->ID);
            $content = $product->get_meta('_specifications');
            ?>
            <div class="product_specifications">

                <?php wp_editor(wp_specialchars_decode($content, ENT_QUOTES), '_specifications', ['textarea_rows' => 10]); ?>
            </div>

            <?php
        }

        public function create_product_meta_box() {
            add_meta_box(
                'custom_product_meta_box',
                esc_html__('Specifications', 'razox'),
                [$this, 'content_meta_box_specifications'],
                'product',
                'normal',
                'default'
            );
        }

        public function settings_product_tabs($tabs) {

            $tabs['sizechart'] = array(
                'label'    => esc_html__('Razox settings', 'razox'),
                'target'   => 'razox_options',
                'class'    => array(),
                'priority' => 80,
            );

            return $tabs;

        }

        public function settings_options_product_tab_content() {

            global $post;

            ?>
            <div id='razox_options' class='panel woocommerce_options_panel'>
                <div class='options_group'><?php

                    $value = get_post_meta($post->ID, '_sizechart_select', true);
                    if (empty($value)) {
                        $value = '';
                    }
                    $options[''] = esc_html__('Select size chart', 'razox');

                    $args = array(
                        'post_type'      => 'elementor_library',
                        'posts_per_page' => -1,
                        'orderby'        => 'title',
                        's'              => 'SizeChart ',
                        'order'          => 'ASC',
                    );

                    $query = new WP_Query($args);
                    while ($query->have_posts()) {
                        $query->the_post();
                        $options[$post->post_name] = $post->post_title;
                    }

                    wp_reset_postdata();

                    woocommerce_wp_select(array(
                        'id'      => '_sizechart_select',
                        'label'   => esc_html__('Size chart', 'razox'),
                        'options' => $options,
                        'value'   => $value,
                    ));

                    ?>
                    <p class="form-field form-field-wide wc-customer-custom"><?php echo esc_html__('Size chart will take templates name prefix is "SizeChart"', 'razox'); ?></p>

                    <?php
                    woocommerce_wp_text_input(array(
                        'id'    => '_video_select',
                        'label' => esc_html__('Url Video', 'razox'),
                    ));

                    woocommerce_wp_text_input(array(
                        'id'    => '_warranty',
                        'label' => esc_html__('Warranty', 'razox'),
                    ));

                    woocommerce_wp_textarea_input(array(
                        'id'    => '_extra_description',
                        'rows'  => 5,
                        'label' => esc_html__('Single extra description', 'razox'),
                    ));

                    woocommerce_wp_textarea_input(array(
                        'id'            => '_key_features',
                        'label'         => esc_html__('Key Features', 'razox'),
                        'rows'          => 5,
                        'wrapper_class' => 'form-row form-row-full',
                    ));

                    woocommerce_wp_textarea_input(array(
                        'id'            => '_gift',
                        'label'         => esc_html__('Gift', 'razox'),
                        'rows'          => 5,
                        'wrapper_class' => 'form-row form-row-full',
                    ));
                    ?>
                </div>

            </div>
            <?php
        }

        public function save_settings_option_fields($post_id) {
            if (isset($_POST['_sizechart_select'])) {
                update_post_meta($post_id, '_sizechart_select', esc_attr($_POST['_sizechart_select']));
            }
            if (isset($_POST['_video_select'])) {
                update_post_meta($post_id, '_video_select', esc_attr($_POST['_video_select']));
            }
            if (isset($_POST['_warranty'])) {
                update_post_meta($post_id, '_warranty', esc_attr($_POST['_warranty']));
            }
            if (isset($_POST['_extra_description'])) {
                update_post_meta($post_id, '_extra_description', wp_kses_post($_POST['_extra_description']));
            }
            if (isset($_POST['_key_features'])) {
                update_post_meta($post_id, '_key_features', wp_kses_post($_POST['_key_features']));
            }
            if (isset($_POST['_gift'])) {
                update_post_meta($post_id, '_gift', wp_kses_post($_POST['_gift']));
            }
            if (isset($_POST['_specifications'])) {
                update_post_meta($post_id, '_specifications', $_POST['_specifications']);
            }
        }

        public function add_css() {
            global $post;
            if (!is_product()) {
                return;
            }
            $slug     = get_post_meta($post->ID, '_sizechart_select', true);
            $chart_id = $this->check_chart($slug);
            if (!empty($slug) && $chart_id) {
                Elementor\Core\Files\CSS\Post::create($chart_id)->enqueue();
            }
        }

        private function check_chart($slug = '') {

            if ($slug) {

                $queried_post = get_page_by_path($slug, OBJECT, 'elementor_library');

                if (isset($queried_post->ID)) {
                    return $queried_post->ID;
                }
            }

            return false;
        }

        private function getsizechart() {
            global $post;
            self::$sizechart[] = esc_html__('Select size chart', 'razox');
            $args              = array(
                'post_type'      => 'elementor_library',
                'posts_per_page' => -1,
                'orderby'        => 'title',
                's'              => 'SizeChart ',
                'order'          => 'ASC',
            );
            //
            $query = new WP_Query($args);
            while ($query->have_posts()) {
                $query->the_post();
                self::$sizechart[$post->post_name] = $post->post_title;
            }
            wp_reset_postdata();
        }

        public function render_sizechart_button() {
            global $post;
            if (!is_product()) {
                return;
            }
            $slug     = get_post_meta($post->ID, '_sizechart_select', true);
            $chart_id = $this->check_chart($slug);
            if (!empty($slug) && $chart_id) {
                echo '<a href="#" class="sizechart-button">' . esc_html__('Size Guide', 'razox') . '</a>';
            }
        }

        public function render_sizechart_template() {
            global $post;
            if (!is_product()) {
                return;
            }
            $slug     = get_post_meta($post->ID, '_sizechart_select', true);
            $chart_id = $this->check_chart($slug);
            if (!empty($slug) && $chart_id) {
                echo '<div class="sizechart-popup"><a href="#" class="sizechart-close"><i class="razox-icon-times-circle"></i></a>' . Elementor\Plugin::instance()->frontend->get_builder_content($chart_id) . '</div><div class="sizechart-overlay"></div>';
            }
        }
    }

    return new Razox_WooCommerce_Settings();

endif;
