<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('Razox_WooCommerce')) :

    /**
     * The Razox WooCommerce Integration class
     */
    class Razox_WooCommerce {

        public $list_shortcodes;

        private $prefix = 'remove';

        /**
         * Setup class.
         *
         * @since 1.0
         */
        public function __construct() {

            $this->init_shortcodes();
            $this->remove_wvs_support();
            $this->single_product_gallery_layout();
            add_action('after_setup_theme', array($this, 'setup'));
            add_filter('body_class', array($this, 'woocommerce_body_class'));
            add_action('widgets_init', array($this, 'widgets_init'));
            add_filter('razox_theme_sidebar', array($this, 'set_sidebar'), 20);
            add_action('wp_enqueue_scripts', array($this, 'woocommerce_scripts'), 20);
            add_filter('woocommerce_enqueue_styles', '__return_empty_array');
            add_filter('woocommerce_output_related_products_args', array($this, 'related_products_args'));
            add_filter('woocommerce_upsell_display_args', array($this, 'upsell_products_args'));
            add_filter('woocommerce_product_thumbnails_columns', array($this, 'thumbnail_columns'));
            add_filter('loop_shop_per_page', array($this, 'products_per_page'));
            add_filter('woocommerce_add_to_cart_fragments', 'razox_cart_link_fragment');
            add_filter('woocommerce_cross_sells_columns', array($this, 'woocommerce_cross_sells_columns'));
            add_filter('woocommerce_get_image_size_gallery_thumbnail', function ($size) {
                return array(
                    'width'  => 90,
                    'height' => 90,
                    'crop'   => 1,
                );
            });
            add_filter('woocommerce_get_script_data', function ($params, $handle) {
                if ($handle == "wc-add-to-cart") {
                    $params['i18n_view_cart'] = '';
                }
                return $params;
            }, 10, 2);

            // Remove Shop Title
            add_filter('woocommerce_show_page_title', '__return_false');
            add_filter('wc_get_template_part', array($this, 'change_template_part'), 10, 3);
            add_filter('razox_register_nav_menus', [$this, 'add_location_menu']);
            add_filter('wp_nav_menu_items', [$this, 'add_extra_item_to_nav_menu'], 10, 2);

            add_filter('woocommerce_single_product_image_gallery_classes', function ($wrapper_classes) {
                $wrapper_classes[] = 'woocommerce-product-gallery-' . razox_get_theme_option('single_product_gallery_layout', 'horizontal');

                return $wrapper_classes;
            });

            add_action('admin_init', [$this, 'wvs_support']);
            add_filter('woosc_button_position_single', '__return_false');
            add_filter('woosw_button_position_single', '__return_false');

            add_action('admin_action_elementor', array($this, 'includes'), 1);
            add_action('load-post.php', array($this, 'includes'));
            $this->includes();
        }

        public function includes() {
            // We load frontend includes in the post editor, because they may be invoked via pre-loading of blocks.
            $in_post_editor = doing_action('load-post.php') || doing_action('load-post-new.php');
            if ($this->is_request('frontend') || $in_post_editor) {
                require_once get_theme_file_path('inc/woocommerce/template-hooks.php');
            }
        }

        public function woocommerce_cross_sells_columns() {
            return wc_get_default_products_per_row();
        }

        public function register_elementor_wc_hook() {
            wc()->frontend_includes();
            require_once get_theme_file_path('inc/woocommerce/template-hooks.php');
        }

        public function add_extra_item_to_nav_menu($items, $args) {
            if ($args->theme_location == 'my-account') {
                $items .= '<li><a href="' . esc_url(wp_logout_url(home_url())) . '">' . esc_html__('Logout', 'razox') . '</a></li>';
            }

            return $items;
        }

        public function add_location_menu($locations) {
            $locations['my-account'] = esc_html__('My Account', 'razox');

            return $locations;
        }

        /**
         * Sets up theme defaults and registers support for various WooCommerce features.
         *
         * Note that this function is hooked into the after_setup_theme hook, which
         * runs before the init hook. The init hook is too late for some features, such
         * as indicating support for post thumbnails.
         *
         * @return void
         * @since 2.4.0
         */
        public function setup() {
            add_theme_support(
                'woocommerce', apply_filters(
                    'razox_woocommerce_args', array(
                        'product_grid' => array(
                            'default_columns' => 4,
                            'default_rows'    => 4,
                            'min_columns'     => 1,
                            'max_columns'     => 6,
                            'min_rows'        => 1,
                        ),
                    )
                )
            );
            add_image_size('woocommerce-thumbnails', 90, 90, true);


            /**
             * Add 'razox_woocommerce_setup' action.
             *
             * @since  2.4.0
             */
            do_action('razox_woocommerce_setup');
        }

        public function action_woocommerce_before_template_part($template_name, $template_path, $located, $args) {
            $product_style = razox_get_theme_option('wocommerce_block_style', 0);
            if ($product_style != 0 && ($template_name == 'single-product/up-sells.php' || $template_name == 'single-product/related.php' || $template_name == 'cart/cross-sells.php')) {
                $template_custom = 'content-product-' . $product_style . '.php';
                add_filter('wc_get_template_part', function ($template, $slug, $name) use ($template_custom) {
                    if ($slug == 'content' && $name == 'product') {
                        return get_theme_file_path('woocommerce/' . $template_custom);
                    } else {
                        return $template;
                    }
                }, 10, 3);
            }
        }

        public function action_woocommerce_after_template_part($template_name, $template_path, $located, $args) {
            $product_style = razox_get_theme_option('wocommerce_block_style', 0);
            if ($product_style != 0 && ($template_name == 'single-product/up-sells.php' || $template_name == 'single-product/related.php' || $template_name == 'cart/cross-sells.php')) {
                add_filter('wc_get_template_part', function ($template, $slug, $name) {
                    if ($slug == 'content' && $name == 'product') {
                        return get_theme_file_path('woocommerce/content-product.php');
                    } else {
                        return $template;
                    }
                }, 10, 3);
            }
        }

        private function init_shortcodes() {
            $this->list_shortcodes = array(
                'recent_products',
                'sale_products',
                'best_selling_products',
                'top_rated_products',
                'featured_products',
                'related_products',
                'product_category',
                'products',
            );

            foreach ($this->list_shortcodes as $shortcode) {
                add_filter('shortcode_atts_' . $shortcode, array($this, 'set_shortcode_attributes'), 10, 3);
                add_action('woocommerce_shortcode_before_' . $shortcode . '_loop', array($this, 'shortcode_loop_start'));
                add_action('woocommerce_shortcode_after_' . $shortcode . '_loop', array($this, 'shortcode_loop_end'));
            }
        }

        public function shortcode_loop_end($atts = array()) {
            $function_to_call = $this->prefix . '_filter';
            if (isset($atts['style']) && $atts['style'] !== '') {
                $function_to_call('wc_get_template_part', array($this, 'woocommerce_change_path_shortcode'), 10, 3);
                if (isset($atts['show_time_sale']) && $atts['show_time_sale'] == true) {
                    $function_to_call('razox_woocommerce_list_item_content', 'razox_woocommerce_time_sale', 45);
                }
                if (isset($atts['show_gift']) && $atts['show_gift'] == true) {
                    $function_to_call('razox_woocommerce_list_item_title', 'razox_single_product_gift_label', 10);
                }

                if (isset($atts['show_category']) && $atts['show_category'] == true) {
                    $function_to_call('razox_woocommerce_list_item_content', 'razox_display_product_category', 5);
                }
                if (isset($atts['show_deal_sold']) && $atts['show_deal_sold'] == true) {
                    $function_to_call('razox_woocommerce_list_item_content', 'razox_woocommerce_deal_progress', 70);
                }
                if (isset($atts['show_button']) && $atts['show_button'] == true) {
                    $function_to_call('razox_woocommerce_list_item_content', 'razox_woocommerce_product_button_start', 25);
                    $function_to_call('razox_woocommerce_list_item_content', 'razox_stock_label', 30);
                    $function_to_call('razox_woocommerce_list_item_content', 'woocommerce_template_loop_add_to_cart', 35);
                    $function_to_call('razox_woocommerce_list_item_content', 'razox_woocommerce_product_button_close', 40);
                }
            } else {
                if (isset($atts['hidden_action']) && $atts['hidden_action'] == true) {
                    add_action('woocommerce_before_shop_loop_item', 'razox_product_action_start', 5);
                    add_action('woocommerce_before_shop_loop_item', 'razox_display_product_category', 10);
                    add_action('woocommerce_before_shop_loop_item', 'razox_woocommerce_product_loop_action_start', 15);
                    add_action('woocommerce_before_shop_loop_item', 'razox_wishlist_button', 20);
                    add_action('woocommerce_before_shop_loop_item', 'razox_compare_button', 25);
                    add_action('woocommerce_before_shop_loop_item', 'razox_quickview_button', 30);
                    add_action('woocommerce_before_shop_loop_item', 'razox_woocommerce_product_loop_action_close', 35);
                    add_action('woocommerce_before_shop_loop_item', 'razox_product_action_close', 40);
                }
            }

            if (isset($atts['enable_carousel']) && $atts['enable_carousel'] === 'yes') {
                wc_set_loop_prop('enable_carousel', false);
                if (isset($atts['carousel_settings']) && $atts['carousel_settings'] != '') {
                    echo wp_kses_post($atts['carousel_settings']);
                }

                echo '</div>';
            }
        }

        public function shortcode_loop_start($atts = array()) {
            $function_to_call = $this->prefix . '_filter';
            if (isset($atts['style']) && $atts['style'] !== '') {
                add_filter('wc_get_template_part', array($this, 'woocommerce_change_path_shortcode'), 10, 3);
                if (isset($atts['show_time_sale']) && $atts['show_time_sale'] == true) {
                    add_action('razox_woocommerce_list_item_content', 'razox_woocommerce_time_sale', 45);
                }
                if (isset($atts['show_deal_sold']) && $atts['show_deal_sold'] == true) {
                    add_action('razox_woocommerce_list_item_content', 'razox_woocommerce_deal_progress', 70);
                }

                if (isset($atts['show_gift']) && $atts['show_gift'] == true) {
                    add_action('razox_woocommerce_list_item_title', 'razox_single_product_gift_label', 10);
                }

                if (isset($atts['show_category']) && $atts['show_category'] == true) {
                    add_action('razox_woocommerce_list_item_content', 'razox_display_product_category', 5);
                }

                if (isset($atts['show_button']) && $atts['show_button'] == true) {
                    add_action('razox_woocommerce_list_item_content', 'razox_woocommerce_product_button_start', 25);
                    add_action('razox_woocommerce_list_item_content', 'razox_stock_label', 30);
                    add_action('razox_woocommerce_list_item_content', 'woocommerce_template_loop_add_to_cart', 35);
                    add_action('razox_woocommerce_list_item_content', 'razox_woocommerce_product_button_close', 40);
                }

            } else {
                if (isset($atts['hidden_action']) && $atts['hidden_action'] == true) {
                    $function_to_call('woocommerce_before_shop_loop_item', 'razox_product_action_start', 5);
                    $function_to_call('woocommerce_before_shop_loop_item', 'razox_display_product_category', 10);
                    $function_to_call('woocommerce_before_shop_loop_item', 'razox_woocommerce_product_loop_action_start', 15);
                    $function_to_call('woocommerce_before_shop_loop_item', 'razox_wishlist_button', 20);
                    $function_to_call('woocommerce_before_shop_loop_item', 'razox_compare_button', 25);
                    $function_to_call('woocommerce_before_shop_loop_item', 'razox_quickview_button', 30);
                    $function_to_call('woocommerce_before_shop_loop_item', 'razox_woocommerce_product_loop_action_close', 35);
                    $function_to_call('woocommerce_before_shop_loop_item', 'razox_product_action_close', 40);
                }
            }

            if (isset($atts['enable_carousel']) && $atts['enable_carousel'] === 'yes') {
                wc_set_loop_prop('enable_carousel', true);

                echo '<div class="razox-swiper swiper">';
            }
        }

        public function set_shortcode_attributes($out, $pairs, $atts) {
            $out = wp_parse_args($atts, $out);

            return $out;
        }

        public function change_template_part($template, $slug, $name) {

            $layout = isset($_GET['layout']) ? $_GET['layout'] : razox_get_theme_option('woocommerce_product_layout', 'grid');
            if ($layout == 'list') {
                if ($slug == 'content' && $name == 'product') {
                    return get_theme_file_path('woocommerce/content-product-list.php');
                }
            }

            return $template;
        }

        public function woocommerce_change_path_shortcode() {
            $path_shortcode = apply_filters('woocommerce-path-shortcode-list', 'list-shortcode');
            wc_get_template("content-product-{$path_shortcode}.php");
        }

        /**
         * Assign styles to individual theme mod.
         *
         * @return void
         * @since 2.1.0
         * @deprecated 2.3.1
         */
        public function set_razox_style_theme_mods() {
            if (function_exists('wc_deprecated_function')) {
                wc_deprecated_function(__FUNCTION__, '2.3.1');
            } else {
                _deprecated_function(__FUNCTION__, '2.3.1');
            }
        }

        /**
         * Add WooCommerce specific classes to the body tag
         *
         * @param array $classes css classes applied to the body tag.
         *
         * @return array $classes modified to include 'woocommerce-active' class
         */
        public function woocommerce_body_class($classes) {
            $classes[] = 'woocommerce-active';

            // Remove `no-wc-breadcrumb` body class.
            $key = array_search('no-wc-breadcrumb', $classes, true);

            if (false !== $key) {
                unset($classes[$key]);
            }

            $style   = razox_get_theme_option('wocommerce_block_style', 1);
            $layout  = razox_get_theme_option('woocommerce_archive_layout', 'default');
            $sidebar = razox_get_theme_option('woocommerce_archive_sidebar', 'left');
            $width   = razox_get_theme_option('woocommerce_archive_content_width', 'default');

            $classes[] = 'product-block-style-' . $style;


            if (razox_is_product_archive()) {
                $classes   = array_diff($classes, array(
                    'razox-sidebar-', 'razox-sidebar-left', 'razox-sidebar-right', 'razox-full-width-content', 'razox-content-width-wide'
                ));
                $classes[] = 'razox-archive-product';
                $classes[] = 'razox-content-width-' . $width;

                if (is_active_sidebar('sidebar-woocommerce-shop')) {
                    if ($layout == 'default') {

                        if ($sidebar == 'left') {
                            $classes[] = 'razox-sidebar-left';
                        } else {
                            $classes[] = 'razox-sidebar-right';
                        }
                    } else {
                        $classes[] = 'razox-full-width-content';
                        $classes[] = 'shop_filter_' . $layout;
                    }

                } else {
                    $classes[] = 'razox-full-width-content';
                }
            }

            if (is_product()) {
                $classes[] = 'razox-full-width-content';
                $classes[] = 'single-product-' . razox_get_theme_option('single_product_gallery_layout', 'horizontal');
                $classes[] = 'single-product-tabs-layout-' . razox_get_theme_option('single_product_tabs_layout', 'below');
            }

            return $classes;
        }

        public function wvs_support() {
            $function_to_call = $this->prefix . '_filter';
            $function_to_call('pre_update_option_woocommerce_thumbnail_image_width', 'wvs_clear_transient');
            $function_to_call('pre_update_option_woocommerce_thumbnail_cropping', 'wvs_clear_transient');
        }

        /**
         * WooCommerce specific scripts & stylesheets
         *
         * @since 1.0.0
         */
        public function woocommerce_scripts() {
            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';
            //register_style
            wp_register_style('razox-woocommerce-style', get_template_directory_uri() . '/assets/css/woocommerce.css', array(), RAZOX_VERSION);
            wp_register_style('razox-woocommerce-legacy', get_template_directory_uri() . '/assets/css/woocommerce-legacy.css', array(), RAZOX_VERSION);
            //register_script
            wp_register_script('razox-header-cart', get_template_directory_uri() . '/assets/js/woocommerce/header-cart' . $suffix . '.js', array(), RAZOX_VERSION, true);
            wp_register_script('razox-products-ajax-search', get_template_directory_uri() . '/assets/js/woocommerce/product-ajax-search' . $suffix . '.js', array('jquery', 'tooltipster'), RAZOX_VERSION, true);
            wp_register_script('razox-products', get_template_directory_uri() . '/assets/js/woocommerce/main' . $suffix . '.js', array('jquery', 'waypoints'), RAZOX_VERSION, true);
            wp_register_script('razox-input-quantity', get_template_directory_uri() . '/assets/js/woocommerce/quantity' . $suffix . '.js', array('jquery'), RAZOX_VERSION, true);
            wp_register_script('razox-cart-canvas', get_template_directory_uri() . '/assets/js/woocommerce/cart-canvas' . $suffix . '.js', array(), RAZOX_VERSION, true);
            wp_register_script('razox-off-canvas', get_template_directory_uri() . '/assets/js/woocommerce/off-canvas' . $suffix . '.js', array(), RAZOX_VERSION, true);
            wp_register_script('razox-sticky-add-to-cart', get_template_directory_uri() . '/assets/js/sticky-add-to-cart' . $suffix . '.js', array(), RAZOX_VERSION, true);
            wp_enqueue_script('razox-single-product', get_template_directory_uri() . '/assets/js/woocommerce/single' . $suffix . '.js', array(
                'jquery',
                'swiper',
                'sticky-kit',
                'magnific-popup'
            ), RAZOX_VERSION, true);

            //enqueue_style
            wp_enqueue_style('razox-woocommerce-style');
            wp_style_add_data('razox-woocommerce-style', 'rtl', 'replace');
            // QuickView
            wp_dequeue_style('yith-quick-view');
            wp_enqueue_script('razox-header-cart');

            //enqueue_script
            wp_enqueue_script('razox-products-ajax-search');
            wp_enqueue_script('razox-products');
            wp_enqueue_script('razox-input-quantity');
            wp_enqueue_script('razox-input-quantity');
            wp_enqueue_script('razox-cart-canvas');

            if (defined('WC_VERSION') && version_compare(WC_VERSION, '3.3', '<')) {
                wp_enqueue_style('razox-woocommerce-legacy');
                wp_style_add_data('razox-woocommerce-legacy', 'rtl', 'replace');
            }

            if (is_shop() || is_product() || is_product_taxonomy() || razox_elementor_check_type('razox-products')) {
                wp_enqueue_script('tooltipster');
                wp_enqueue_style('tooltipster');
                wp_enqueue_script('magnific-popup');
                wp_enqueue_style('magnific-popup');
            }

            if (is_active_sidebar('sidebar-woocommerce-shop')) {
                wp_enqueue_script('razox-off-canvas');
            }

            if (is_product() || is_cart()) {
                wp_enqueue_script('razox-countdown');
                wp_enqueue_style('razox-sticky-add-to-cart');
                wp_enqueue_style('magnific-popup');
                wp_enqueue_script('magnific-popup');
                wp_enqueue_script('spritespin');
                wp_enqueue_script('swiper');
                wp_enqueue_script('razox-swiper');
                wp_enqueue_script('sticky-kit');
                wp_enqueue_script('razox-single-product');
            }
        }

        /**
         * Related Products Args
         *
         * @param array $args related products args.
         *
         * @return  array $args related products args
         * @since 1.0.0
         */
        public function related_products_args($args) {
            $product_items = 4;

            $args = apply_filters(
                'razox_related_products_args', array(
                    'posts_per_page' => $product_items,
                    'columns'        => $product_items,
                )
            );
            return $args;
        }

        /**
         * Upsells
         * Replace the default upsell function with our own which displays the correct number product columns
         *
         * @return  void
         * @since   1.0.0
         * @uses    woocommerce_upsell_display()
         */
        public function upsell_products_args() {
            $args = apply_filters(
                'razox_upsell_products_args', array(
                    'columns' => 4,
                )
            );
            return $args;
        }

        /**
         * Product gallery thumbnail columns
         *
         * @return integer number of columns
         * @since  1.0.0
         */
        public function thumbnail_columns() {
            $columns = razox_get_theme_option('single_product_gallery_column', 3);

            if (razox_get_theme_option('single_product_gallery_layout', 'horizontal') == 'vertical') {
                $columns = 1;
            }

            return intval(apply_filters('razox_product_thumbnail_columns', $columns));
        }

        /**
         * Products per page
         *
         * @return integer number of products
         * @since  1.0.0
         */
        public function products_per_page() {
            return intval(apply_filters('razox_products_per_page', 12));
        }

        public function widgets_init() {
            register_sidebar(array(
                'name'          => esc_html__('WooCommerce Shop', 'razox'),
                'id'            => 'sidebar-woocommerce-shop',
                'description'   => esc_html__('Add widgets here to appear in your sidebar on blog posts and archive pages.', 'razox'),
                'before_widget' => '<div id="%1$s" class="widget %2$s razox-widget-woocommerce">',
                'after_widget'  => '</div>',
            ));
        }

        public function set_sidebar($name) {
            $layout = razox_get_theme_option('woocommerce_archive_layout', 'default');
            if (razox_is_product_archive()) {
                if (is_active_sidebar('sidebar-woocommerce-shop') && $layout == 'default') {
                    $name = 'sidebar-woocommerce-shop';
                } else {
                    $name = '';
                }
            }
            if (is_product()) {
                $name = '';
            }
            return $name;
        }

        public function grouped_product_column_image($grouped_product_child) {
            echo '<td class="woocommerce-grouped-product-image">' . $grouped_product_child->get_image('thumbnail') . '</td>';
        }

        public function remove_wvs_support() {
            $function_to_call = $this->prefix . '_filter';
            $function_to_call('pre_update_option_woocommerce_thumbnail_image_width', 'wvs_clear_transient');
            $function_to_call('pre_update_option_woocommerce_thumbnail_cropping', 'wvs_clear_transient');
        }

        public function single_product_gallery_layout() {
            $tabs_position = razox_get_theme_option('single_product_tabs_layout', 'tabs');
            $style         = razox_get_theme_option('single_product_gallery_layout', 'horizontal');

            add_theme_support('wc-product-gallery-lightbox');
            if ($style === 'gallery') {
                add_filter('woocommerce_single_product_image_thumbnail_html', 'razox_woocommerce_single_product_image_thumbnail_html', 10, 2);
            } elseif ($style === 'sticky') {
                add_filter('woocommerce_single_product_image_thumbnail_html', 'razox_woocommerce_single_product_image_thumbnail_html', 10, 2);
            } else {
                add_theme_support('wc-product-gallery-zoom');
                add_theme_support('wc-product-gallery-slider');
            }

            if ($tabs_position === 'sticky') {
                remove_action('woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
                add_action('woocommerce_before_single_product_summary', 'woocommerce_output_product_data_tabs_full_content', 80);
            }
        }

        /**
         * What type of request is this?
         *
         * @param string $type admin, ajax, cron or frontend.
         * @return bool
         */
        private function is_request($type) {
            switch ($type) {
                case 'admin':
                    return is_admin();
                case 'ajax':
                    return defined('DOING_AJAX');
                case 'cron':
                    return defined('DOING_CRON');
                case 'frontend':
                    return (!is_admin() || defined('DOING_AJAX')) && !defined('DOING_CRON');
            }
        }
    }

endif;

return new Razox_WooCommerce();
