<?php
if (!function_exists('woocommerce_output_product_data_tabs')) {

    /**
     * Output the product tabs.
     */
    function woocommerce_output_product_data_tabs() {
        $tabs = razox_get_theme_option('single_product_tabs_layout', 'tabs');
        if ($tabs === 'accordion') {
            wc_get_template('single-product/tabs/accordion.php');
        } elseif ($tabs === 'full-content') {
            wc_get_template('single-product/tabs/full-content.php');
        } else {
            wc_get_template('single-product/tabs/tabs.php');
        }
    }
}
if (!function_exists('woocommerce_output_product_data_tabs_full_content')) {

    /**
     * Output the product tabs.
     */
    function woocommerce_output_product_data_tabs_full_content() {

        wc_get_template('single-product/tabs/full-content.php');

    }
}
if (!function_exists('razox_get_settings_product_caroseul')) {
    function razox_get_settings_product_caroseul() {
        $items       = wc_get_loop_prop('columns', 3);
        $laptop      = razox_get_theme_option('wocommerce_row_laptop', 3);
        $tablet      = razox_get_theme_option('wocommerce_row_tablet', 2);
        $mobile      = razox_get_theme_option('wocommerce_row_mobile', 1);
        $breakpoints = [
            'desktop' => [
                'value'  => 1366,
                'column' => $items,
            ],
            'laptop'  => [
                'value'  => 1024,
                'column' => $laptop,
            ],
            'tablet'  => [
                'value'  => 568,
                'column' => $tablet,
            ],
            'mobile'  => [
                'value'  => 0,
                'column' => $mobile,
            ],
        ];

        if (razox_is_elementor_activated()) {
            $elementor_breakpoints = \Elementor\Plugin::$instance->breakpoints->get_breakpoints();
            foreach (array_reverse($elementor_breakpoints) as $breakpoint) {
                if ($breakpoint->is_enabled()) {
                    if ($breakpoint->get_name() == 'laptop') {
                        $breakpoints['desktop']['value'] = $breakpoint->get_value();
                    }
                    if ($breakpoint->get_name() == 'tablet') {
                        $breakpoints['laptop']['value'] = $breakpoint->get_value();
                    }
                    if ($breakpoint->get_name() == 'mobile') {
                        $breakpoints['tablet']['value'] = $breakpoint->get_value();
                    }
                }
            }
        }

        $settings = array(
            'breakpoints'          => $breakpoints,
            "column"               => $items,
            "navigation"           => "arrows",
            "column_spacing"       => 30,
            "swiper_overflow"      => "none",
            "autoplay"             => "no",
            "pause_on_hover"       => "yes",
            "pause_on_interaction" => "yes",
            "autoplay_speed"       => 5000,
            "infinite"             => "no",
            "speed"                => 500,
            "prevEl"               => ".elementor-swiper-button-prev",
            "nextEl"               => ".elementor-swiper-button-next",
            "paginationEl"         => ".swiper-pagination",
        );

        return $settings;
    }
}
if (!function_exists('razox_woocommerce_before_shop_loop')) {
    /**
     * woocommerce_before_shop_loop
     */
    function razox_woocommerce_before_shop_loop() {
        $layout = isset($_GET['layout']) ? $_GET['layout'] : razox_get_theme_option('woocommerce_product_layout', 'grid');
        $class  = 'razox-products-grid';
        $class  .= ' elementor-grid-' . ($layout == 'list' ? 1 : wc_get_loop_prop('columns', 3));
        $class  .= ' elementor-grid-laptop-' . ($layout == 'list' ? 1 : razox_get_theme_option('wocommerce_row_laptop', 3));
        $class  .= ' elementor-grid-tablet-' . ($layout == 'list' ? 1 : razox_get_theme_option('wocommerce_row_tablet', 2));
        $class  .= ' elementor-grid-mobile-' . ($layout == 'list' ? 1 : razox_get_theme_option('wocommerce_row_mobile', 1));

        echo '<div class="' . esc_attr($class) . '">';
    }
}


if (!function_exists('razox_woocommerce_product_loop_end')) {
    /**
     * woocommerce_product_loop_end
     */
    function razox_woocommerce_product_loop_end() {
        echo '</div>';
    }
}

/**
 * Checks if the current page is a product archive
 *
 * @return boolean
 */
function razox_is_product_archive() {
    if (is_shop() || is_product_taxonomy() || is_product_category() || is_product_tag()) {
        return true;
    } else {
        return false;
    }
}

/**
 * @param $product WC_Product
 */
function razox_product_get_image($product) {
    return $product->get_image();
}

/**
 * @param $product WC_Product
 */
function razox_product_get_price_html($product) {
    return $product->get_price_html();
}

/**
 * Retrieves the previous product.
 *
 * @param bool $in_same_term Optional. Whether post should be in a same taxonomy term. Default false.
 * @param array|string $excluded_terms Optional. Comma-separated list of excluded term IDs. Default empty.
 * @param string $taxonomy Optional. Taxonomy, if $in_same_term is true. Default 'product_cat'.
 * @return WC_Product|false Product object if successful. False if no valid product is found.
 * @since 2.4.3
 *
 */
function razox_get_previous_product($in_same_term = false, $excluded_terms = '', $taxonomy = 'product_cat') {
    $product = new Razox_WooCommerce_Adjacent_Products($in_same_term, $excluded_terms, $taxonomy, true);
    return $product->get_product();
}

/**
 * Retrieves the next product.
 *
 * @param bool $in_same_term Optional. Whether post should be in a same taxonomy term. Default false.
 * @param array|string $excluded_terms Optional. Comma-separated list of excluded term IDs. Default empty.
 * @param string $taxonomy Optional. Taxonomy, if $in_same_term is true. Default 'product_cat'.
 * @return WC_Product|false Product object if successful. False if no valid product is found.
 * @since 2.4.3
 *
 */
function razox_get_next_product($in_same_term = false, $excluded_terms = '', $taxonomy = 'product_cat') {
    $product = new Razox_WooCommerce_Adjacent_Products($in_same_term, $excluded_terms, $taxonomy);
    return $product->get_product();
}


function razox_is_woocommerce_extension_activated($extension = 'WC_Bookings') {
    if ($extension == 'YITH_WCQV') {
        return class_exists($extension) && class_exists('YITH_WCQV_Frontend') ? true : false;
    }

    return class_exists($extension) ? true : false;
}

function razox_woocommerce_pagination_args($args) {
    $args['prev_text'] = '<span>' . esc_html__('Previous2', 'razox') . '</span><i class="razox-icon razox-icon-long-arrow-left"></i>';
    $args['next_text'] = '<span>' . esc_html__('Next1', 'razox') . '</span><i class="razox-icon razox-icon-long-arrow-right"></i>';
    return $args;
}

add_filter('woocommerce_pagination_args', 'razox_woocommerce_pagination_args', 10, 1);


function razox_unsupported_theme_remove_review_tab($tabs) {
    unset($tabs['reviews']);
    return $tabs;
}

/**
 * Check if a product is a deal
 *
 * @param int|object $product
 *
 * @return bool
 */
function razox_woocommerce_is_deal_product($product) {
    $product = is_numeric($product) ? wc_get_product($product) : $product;

    // It must be a sale product first
    if (!$product->is_on_sale()) {
        return false;
    }

    if (!$product->is_in_stock()) {
        return false;
    }

    // Only support product type "simple" and "external"
    if (!$product->is_type('simple') && !$product->is_type('external')) {
        return false;
    }

    $deal_quantity = get_post_meta($product->get_id(), '_deal_quantity', true);

    if ($deal_quantity > 0) {
        return true;
    }

    return false;
}

if (!function_exists('razox_display_product_category')) {
    function razox_display_product_category() {
        global $product;

        $categories = get_the_terms($product->get_id(), 'product_cat');

        if ($categories && !is_wp_error($categories)) {
            echo '<div class="product-category">';
            $category      = $categories[0];
            $category_link = get_term_link($category->term_id, 'product_cat');
            echo '<a class="product-category-item" href="' . esc_url($category_link) . '">' . esc_html($category->name) . '</a>';
            echo '</div>';
        }


    }
}

if (!function_exists('razox_template_loop_product_thumbnail')) {
    function razox_template_loop_product_thumbnail($size = 'woocommerce_thumbnail', $deprecated1 = 0, $deprecated2 = 0) {
        echo razox_get_loop_product_thumbnail();

    }
}

if (!function_exists('razox_get_loop_product_thumbnail')) {
    function razox_get_loop_product_thumbnail($size = 'woocommerce_thumbnail', $attr = array(), $placeholder = true) {
        global $product;
        if (!$product) {
            return '';
        }
        $gallery    = $product->get_gallery_image_ids();
        $hover_skin = apply_filters('single_product_archive_thumbnail_hover', 'fade');
        $image_size = apply_filters('single_product_archive_thumbnail_size', $size);

        if ($hover_skin == '0' || count($gallery) <= 0) {
            echo '<div class="product-image">' . $product->get_image($image_size, $attr, $placeholder) . '</div>';
            return '';
        }
        $image_featured = '<div class="product-image">' . $product->get_image($image_size, $attr, $placeholder) . '</div>';
        $image_featured .= '<div class="product-image second-image">' . wp_get_attachment_image($gallery[0], $image_size) . '</div>';

        echo <<<HTML
<div class="product-img-wrap {$hover_skin}">
    <div class="inner">
        {$image_featured}
    </div>
</div>
HTML;
    }
}


function woocommerce_template_loop_rating() {
    global $product;
    $count = $product->get_review_count();

    if (!wc_review_ratings_enabled()) {
        return;
    }
    $text = esc_html(_nx(' review', ' reviews', $count, ' review count', 'razox'));
    if ($rating_html = wc_get_rating_html($product->get_average_rating())) {
        echo apply_filters('razox_woocommerce_rating_html', '<div class="count-review">' . $rating_html . '<span>' . $count . ' reviews</span></div>');
    } else {
        echo '<div class="count-review"><div class="star-rating"></div><span>(' . $text . ')</span></div>';
    }
}

if (!function_exists('razox_check_quantity_product')) {
    function razox_check_quantity_product() {
        global $product;
        $quantity = get_post_meta($product->get_id(), '_sold_individually', true);
        if ($quantity == 'yes' || $product->get_stock_status() == 'outofstock' || $product->is_type('variable') || $product->is_type('grouped')) {
            return true;
        } else {
            return false;
        }
    }
}

if (!function_exists('razox_ajax_search_products')) {
    function razox_ajax_search_products() {
        global $woocommerce;
        $search_keyword = $_REQUEST['query'];

        $ordering_args = $woocommerce->query->get_catalog_ordering_args('date', 'desc');
        $suggestions   = array();

        $args = array(
            's'                   => apply_filters('razox_ajax_search_products_search_query', $search_keyword),
            'post_type'           => 'product',
            'post_status'         => 'publish',
            'ignore_sticky_posts' => 1,
            'orderby'             => $ordering_args['orderby'],
            'order'               => $ordering_args['order'],
            'posts_per_page'      => apply_filters('razox_ajax_search_products_posts_per_page', 8),

        );

        $args['tax_query']['relation'] = 'AND';

        if (!empty($_REQUEST['product_cat'])) {
            $args['tax_query'][] = array(
                'taxonomy' => 'product_cat',
                'field'    => 'slug',
                'terms'    => strip_tags($_REQUEST['product_cat']),
                'operator' => 'IN'
            );
        }

        $products = get_posts($args);

        if (!empty($products)) {
            foreach ($products as $post) {
                $product       = wc_get_product($post);
                $product_image = wp_get_attachment_image_src(get_post_thumbnail_id($product->get_id()));

                $suggestions[] = apply_filters('razox_suggestion', array(
                    'id'    => $product->get_id(),
                    'value' => strip_tags($product->get_title()),
                    'url'   => $product->get_permalink(),
                    'img'   => esc_url($product_image[0]),
                    'price' => $product->get_price_html(),
                ), $product);
            }
        } else {
            $suggestions[] = array(
                'id'    => -1,
                'value' => esc_html__('No results', 'razox'),
                'url'   => '',
            );
        }
        wp_reset_postdata();

        echo json_encode($suggestions);
        die();
    }
}

add_action('wp_ajax_razox_ajax_search_products', 'razox_ajax_search_products');
add_action('wp_ajax_nopriv_razox_ajax_search_products', 'razox_ajax_search_products');

function razox_wc_track_product_view() {
    if (!is_singular('product') || is_active_widget(false, false, 'woocommerce_recently_viewed_products', true)) {
        return;
    }

    global $post;

    if (empty($_COOKIE['woocommerce_recently_viewed'])) { // @codingStandardsIgnoreLine.
        $viewed_products = array();
    } else {
        $viewed_products = wp_parse_id_list((array)explode('|', wp_unslash($_COOKIE['woocommerce_recently_viewed']))); // @codingStandardsIgnoreLine.
    }

    // Unset if already in viewed products list.
    $keys = array_flip($viewed_products);

    if (isset($keys[$post->ID])) {
        unset($viewed_products[$keys[$post->ID]]);
    }

    $viewed_products[] = $post->ID;

    if (count($viewed_products) > 15) {
        array_shift($viewed_products);
    }

    // Store for session only.
    wc_setcookie('woocommerce_recently_viewed', implode('|', $viewed_products));
}

add_action('template_redirect', 'razox_wc_track_product_view', 20);


if (!function_exists('razox_before_content')) {
    /**
     * Before Content
     * Wraps all WooCommerce content in wrappers which match the theme markup
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_before_content() {
        echo <<<HTML
<div id="primary" class="content-area">
    <main id="main" class="site-main">
HTML;

    }
}


if (!function_exists('razox_after_content')) {
    /**
     * After Content
     * Closes the wrapping divs
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_after_content() {

        echo <<<HTML
	</main><!-- #main -->
</div><!-- #primary -->
HTML;


        do_action('razox_sidebar');
    }
}

if (!function_exists('razox_cart_link_fragment')) {
    /**
     * Cart Fragments
     * Ensure cart contents update when products are added to the cart via AJAX
     *
     * @param array $fragments Fragments to refresh via AJAX.
     *
     * @return array            Fragments to refresh via AJAX
     */
    function razox_cart_link_fragment($fragments) {
        ob_start();
        razox_cart_link();
        $fragments['a.cart-contents'] = ob_get_clean();

        ob_start();

        return $fragments;
    }
}

if (!function_exists('razox_cart_link')) {
    /**
     * Cart Link
     * Displayed a link to the cart including the number of items present and the cart total
     *
     * @return void
     * @since  1.0.0
     */
    function razox_cart_link() {
        $cart = WC()->cart;
        ?>
        <a class="cart-contents" href="<?php echo esc_url(wc_get_cart_url()); ?>"
           title="<?php esc_attr_e('View your shopping cart', 'razox'); ?>">
            <?php if ($cart): ?>
                <span class="count"><?php echo wp_kses_data(sprintf(_n('%d', '%d', WC()->cart->get_cart_contents_count(), 'razox'), WC()->cart->get_cart_contents_count())); ?></span>
                <?php echo WC()->cart->get_cart_subtotal(); ?>
            <?php endif; ?>
        </a>
        <?php
    }
}


if (!function_exists('razox_show_categories_dropdown')) {
    function razox_show_categories_dropdown() {
        static $id = 0;
        $args  = array(
            'hide_empty' => 1,
            'parent'     => 0
        );
        $terms = get_terms('product_cat', $args);
        if (!empty($terms) && !is_wp_error($terms)) {
            ?>
            <div class="search-by-category input-dropdown">
                <div class="input-dropdown-inner razox-scroll-content">
                    <!--                    <input type="hidden" name="product_cat" value="0">-->
                    <a href="#" data-val="0"><span><?php esc_html_e('Categories', 'razox'); ?></span></a>
                    <?php
                    $args_dropdown = array(
                        'id'               => 'product_cat' . $id++,
                        'show_count'       => 0,
                        'class'            => 'dropdown_product_cat_ajax',
                        'show_option_none' => esc_html__('All category', 'razox'),
                    );
                    wc_product_dropdown_categories($args_dropdown);
                    ?>
                    <div class="list-wrapper razox-scroll">
                        <ul class="razox-scroll-content">
                            <li class="d-none">
                                <a href="#" data-val="0"><?php esc_html_e('All category', 'razox'); ?></a></li>
                            <?php
                            if (!apply_filters('razox_show_only_parent_categories_dropdown', false)) {
                                $args_list = array(
                                    'title_li'           => false,
                                    'taxonomy'           => 'product_cat',
                                    'use_desc_for_title' => false,
                                    'walker'             => new Razox_Product_Category_Walker(),
                                );
                                wp_list_categories($args_list);
                            } else {
                                foreach ($terms as $term) {
                                    ?>
                                    <li>
                                        <a href="#"
                                           data-val="<?php echo esc_attr($term->slug); ?>"><?php echo esc_attr($term->name); ?></a>
                                    </li>
                                    <?php
                                }
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php
        }
    }
}

if (!function_exists('razox_product_search')) {
    /**
     * Display Product Search
     *
     * @return void
     * @uses  razox_is_woocommerce_activated() check if WooCommerce is activated
     * @since  1.0.0
     */
    function razox_product_search() {
        if (razox_is_woocommerce_activated()) {
            static $index = 0;
            $index++;
            ?>
            <div class="site-search ajax-search">
                <div class="widget woocommerce widget_product_search">
                    <div class="ajax-search-result d-none"></div>
                    <form role="search" method="get" class="woocommerce-product-search"
                          action="<?php echo esc_url(home_url('/')); ?>">
                        <label class="screen-reader-text"
                               for="woocommerce-product-search-field-<?php echo isset($index) ? absint($index) : 0; ?>"><?php esc_html_e('Search for:', 'razox'); ?></label>
                        <input type="search"
                               id="woocommerce-product-search-field-<?php echo isset($index) ? absint($index) : 0; ?>"
                               class="search-field"
                               placeholder="<?php echo esc_attr__('What are you looking for? ', 'razox'); ?>"
                               autocomplete="off" value="<?php echo get_search_query(); ?>" name="s"/>
                        <button type="submit"
                                value="<?php echo esc_attr_x('Search', 'submit button', 'razox'); ?>"><?php echo esc_html_x('Search', 'submit button', 'razox'); ?></button>
                        <input type="hidden" name="post_type" value="product"/>
                        <?php razox_show_categories_dropdown(); ?>
                    </form>
                </div>
            </div>
            <?php
        }
    }
}

if (!function_exists('razox_header_cart')) {
    /**
     * Display Header Cart
     *
     * @return void
     * @uses  razox_is_woocommerce_activated() check if WooCommerce is activated
     * @since  1.0.0
     */
    function razox_header_cart() {
        if (razox_is_woocommerce_activated()) {
            if (!razox_get_theme_option('show_header_cart', true)) {
                return;
            }
            ?>
            <div class="site-header-cart menu">
                <?php razox_cart_link(); ?>
                <?php

                if (!apply_filters('woocommerce_widget_cart_is_hidden', is_cart() || is_checkout())) {

                    if (razox_get_theme_option('header_cart_dropdown', 'side') == 'side') {
                        add_action('wp_footer', 'razox_header_cart_side');
                    } else {
                        the_widget('WC_Widget_Cart', 'title=');
                    }
                }
                ?>
            </div>
            <?php
        }
    }
}

if (!function_exists('razox_header_cart_side')) {
    function razox_header_cart_side() {
        if (razox_is_woocommerce_activated()) {
            ?>
            <div class="site-header-cart-side">
                <div class="cart-side-heading">
                    <span class="cart-side-title"><?php echo esc_html__('Shopping cart', 'razox'); ?></span>
                    <a href="#" class="close-cart-side"><?php echo esc_html__('close', 'razox') ?></a></div>
                <?php the_widget('WC_Widget_Cart', 'title='); ?>
            </div>
            <div class="cart-side-overlay"></div>
            <?php
        }
    }
}

if (!function_exists('razox_widget_shopping_cart_button_view_cart')) {

    /**
     * Output the view cart button.
     */
    function razox_widget_shopping_cart_button_view_cart() {
        $wp_button_class = wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : '';
        echo '<a href="' . esc_url(wc_get_cart_url()) . '" class="button wc-forward' . esc_attr($wp_button_class) . '"><span>' . esc_html__('View cart', 'razox') . '</span></a>';
    }
}

if (!function_exists('razox_widget_shopping_cart_proceed_to_checkout')) {

    /**
     * Output the proceed to checkout button.
     */
    function razox_widget_shopping_cart_proceed_to_checkout() {
        $wp_button_class = wc_wp_theme_get_element_class_name('button') ? ' ' . wc_wp_theme_get_element_class_name('button') : '';
        echo '<a href="' . esc_url(wc_get_checkout_url()) . '" class="button checkout wc-forward' . esc_attr($wp_button_class) . '"><span>' . esc_html__('Checkout', 'razox') . '</span></a>';
    }
}

if (!function_exists('razox_sorting_wrapper_start')) {
    /**
     * Sorting wrapper
     *
     * @return  void
     * @since   1.4.3
     */
    function razox_sorting_wrapper_start() {
        echo <<<HTML
<div class="razox-sorting-wrapper">
    <div class="col-full">
        <div class="razox-sorting">
        
HTML;

    }
}

if (!function_exists('razox_sorting_wrapper_close')) {
    /**
     * Sorting wrapper close
     *
     * @return  void
     * @since   1.4.3
     */
    function razox_sorting_wrapper_close() {
        echo <<<HTML
        </div>
    </div>

</div>
HTML;
    }
}

if (!function_exists('razox_product_columns_wrapper')) {
    /**
     * Product columns wrapper
     *
     * @return  void
     * @since   2.2.0
     */
    function razox_product_columns_wrapper() {
        $columns = razox_loop_columns();
        echo '<div class="columns-' . absint($columns) . '">';
    }
}

if (!function_exists('razox_loop_columns')) {
    /**
     * Default loop columns on product archives
     *
     * @return integer products per row
     * @since  1.0.0
     */
    function razox_loop_columns() {
        $columns = 3; // 3 products per row

        if (function_exists('wc_get_default_products_per_row')) {
            $columns = wc_get_default_products_per_row();
        }

        return apply_filters('razox_loop_columns', $columns);
    }
}

if (!function_exists('razox_product_columns_wrapper_close')) {
    /**
     * Product columns wrapper close
     *
     * @return  void
     * @since   2.2.0
     */
    function razox_product_columns_wrapper_close() {
        echo '</div>';
    }
}

if (!function_exists('razox_product_block_wrapper_start')) {
    /**
     * Product Block wrapper Start
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_block_wrapper_start() {
        echo '<div class="product-block">';
    }
}

if (!function_exists('razox_product_block_wrapper_close')) {
    /**
     * Product Block wrapper close
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_block_wrapper_close() {
        echo '</div>';
    }
}

if (!function_exists('razox_product_transition_wrapper_start')) {
    /**
     * Product transition wrapper Start
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_transition_wrapper_start() {
        echo '<div class="product-transition">';
    }
}

if (!function_exists('razox_product_transition_wrapper_close')) {
    /**
     * Product Block transition close
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_transition_wrapper_close() {
        echo '</div>';
    }
}

if (!function_exists('razox_product_caption_wrapper_start')) {
    /**
     * Product caption wrapper Start
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_caption_wrapper_start() {
        echo '<div class="product-caption">';
    }
}

if (!function_exists('razox_product_caption_wrapper_close')) {
    /**
     * Product caption wrapper close
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_caption_wrapper_close() {
        echo '</div>';
    }
}

if (!function_exists('razox_product_caption_bottom_wrapper_start')) {
    /**
     * Product caption wrapper Start
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_caption_bottom_wrapper_start() {
        echo '<div class="product-caption-bottom">';
    }
}

if (!function_exists('razox_product_woobt_extra_above_wrapper')) {
    /**
     * Product woobt_extra_above wrapper Start
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_woobt_extra_above_wrapper() {
        echo '<div class="product-woobt-bottom">';
    }
}

if (!function_exists('razox_product_woobt_extra_below_wrapper')) {
    /**
     * Product woobt_extra_below End
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_woobt_extra_below_wrapper() {
        echo '</div>';
    }
}


if (!function_exists('razox_product_woobt_wrap_above_wrapper')) {
    /**
     * Product woobt_extra_above wrapper Start
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_woobt_wrap_above_wrapper() {
        echo '<div class="razox-woobt-wrap">';
    }
}

if (!function_exists('razox_product_woobt_wrap_below_wrapper')) {
    /**
     * Product woobt_extra_below End
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_woobt_wrap_below_wrapper() {
        echo '</div>';
    }
}
if (!function_exists('razox_product_woobt_title')) {
    function razox_product_woobt_title() {
        echo '<h2 class="razox_product_woobt_title">' . apply_filters('razox_product_woobt_title', esc_html__('Frequently Bought Together', 'razox')) . '</h2>';
    }
}


if (!function_exists('razox_product_caption_bottom_wrapper_close')) {
    /**
     * Product caption wrapper close
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_product_caption_bottom_wrapper_close() {
        echo '</div>';
    }
}

if (!function_exists('razox_product_action_start')) {
    function razox_product_action_start() {
        echo '<div class="product-action">';
    }
}

if (!function_exists('razox_product_action_close')) {
    function razox_product_action_close() {
        echo '</div>';
    }
}

if (!function_exists('razox_woocommerce_product_loop_action_start')) {
    /**
     * Product group action wrapper start
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_woocommerce_product_loop_action_start() {
        ?>
        <div class="group-action">
        <div class="shop-action">
        <?php
    }
}
if (!function_exists('razox_woocommerce_product_loop_action_close')) {
    /**
     * Product group action wrapper close
     *
     * @return  void
     * @since   1.0.0
     */
    function razox_woocommerce_product_loop_action_close() {
        ?>
        </div>
        </div>
        <?php
    }
}

if (!function_exists('razox_woocommerce_product_loop_action')) {
    function razox_woocommerce_product_loop_action() {
        ?>
        <div class="group-action">
            <div class="shop-action">
                <?php do_action('razox_woocommerce_product_loop_action'); ?>
            </div>
        </div>
        <?php
    }
}

if (!function_exists('razox_shop_messages')) {
    /**
     * ThemeBase shop messages
     *
     * @since   1.4.4
     * @uses    razox_do_shortcode
     */
    function razox_shop_messages() {
        if (!is_checkout()) {
            echo razox_do_shortcode('woocommerce_messages');
        }
    }
}


if (!function_exists('razox_woocommerce_pagination')) {
    /**
     * ThemeBase WooCommerce Pagination
     * WooCommerce disables the product pagination inside the woocommerce_product_subcategories() function
     * but since ThemeBase adds pagination before that function is excuted we need a separate function to
     * determine whether or not to display the pagination.
     *
     * @since 1.4.4
     */
    function razox_woocommerce_pagination() {
        if (woocommerce_products_will_display()) {
            woocommerce_pagination();
        }
    }
}


if (!function_exists('razox_single_product_pagination')) {
    /**
     * Single Product Pagination
     *
     * @since 2.3.0
     */
    function razox_single_product_pagination() {

        // Show only products in the same category?
        $in_same_term   = apply_filters('razox_single_product_pagination_same_category', true);
        $excluded_terms = apply_filters('razox_single_product_pagination_excluded_terms', '');
        $taxonomy       = apply_filters('razox_single_product_pagination_taxonomy', 'product_cat');

        $previous_product = razox_get_previous_product($in_same_term, $excluded_terms, $taxonomy);
        $next_product     = razox_get_next_product($in_same_term, $excluded_terms, $taxonomy);

        if ((!$previous_product && !$next_product) || !is_product()) {
            return;
        }

        ?>
        <div class="razox-product-pagination-wrap">
            <nav class="razox-product-pagination" aria-label="<?php esc_attr_e('More products', 'razox'); ?>">
                <?php if ($previous_product) : ?>
                    <a href="<?php echo esc_url($previous_product->get_permalink()); ?>" rel="prev">
                        <span class="pagination-prev "><i
                                    class="razox-icon-angle-left"></i><?php echo esc_html__('Prev', 'razox'); ?></span>
                        <div class="product-item">
                            <?php echo sprintf('%s', $previous_product->get_image()); ?>
                            <div class="razox-product-pagination-content">
                                <span class="razox-product-pagination__title"><?php echo sprintf('%s', $previous_product->get_name()); ?></span>
                                <?php if ($price_html = $previous_product->get_price_html()) :
                                    printf('<span class="price">%s</span>', $price_html);
                                endif; ?>
                            </div>
                        </div>
                    </a>
                <?php endif; ?>

                <?php if ($next_product) : ?>
                    <a href="<?php echo esc_url($next_product->get_permalink()); ?>" rel="next">
                        <span class="pagination-next"><?php echo esc_html__('Next', 'razox'); ?><i
                                    class="razox-icon-angle-right"></i></span>
                        <div class="product-item">
                            <?php echo sprintf('%s', $next_product->get_image()); ?>
                            <div class="razox-product-pagination-content">
                                <span class="razox-product-pagination__title"><?php echo sprintf('%s', $next_product->get_name()); ?></span>
                                <?php if ($price_html = $next_product->get_price_html()) :
                                    printf('<span class="price">%s</span>', $price_html);
                                endif; ?>
                            </div>
                        </div>
                    </a>
                <?php endif; ?>
            </nav><!-- .razox-product-pagination -->
        </div>
        <?php

    }
}

if (!function_exists('razox_sticky_single_add_to_cart')) {
    /**
     * Sticky Add to Cart
     *
     * @since 2.3.0
     */
    function razox_sticky_single_add_to_cart() {
        global $product;

        if (!is_product() || get_option('woocommerce_coming_soon') == 'yes') {
            return;
        }

        $show = false;

        if ($product->is_purchasable() && $product->is_in_stock()) {
            $show = true;
        } else if ($product->is_type('external')) {
            $show = true;
        }

        if (!$show) {
            return;
        }

        $params = apply_filters(
            'razox_sticky_add_to_cart_params', array(
                'trigger_class' => 'entry-summary',
            )
        );

        wp_localize_script('razox-sticky-add-to-cart', 'razox_sticky_add_to_cart_params', $params);
        ?>

        <section class="razox-sticky-add-to-cart">
            <div class="col-full">
                <div class="razox-sticky-add-to-cart__content">
                    <?php echo woocommerce_get_product_thumbnail(); ?>
                    <div class="razox-sticky-add-to-cart__content-product-info">
						<span class="razox-sticky-add-to-cart__content-title"><?php esc_attr_e('You\'re viewing:', 'razox'); ?>
							<strong><?php the_title(); ?></strong></span>
                        <span class="razox-sticky-add-to-cart__content-price"><?php echo sprintf('%s', $product->get_price_html()); ?></span>
                        <?php echo wc_get_rating_html($product->get_average_rating()); ?>
                    </div>
                    <a href="<?php echo esc_url($product->add_to_cart_url()); ?>"
                       class="razox-sticky-add-to-cart__content-button button alt">
                        <?php echo esc_attr($product->add_to_cart_text()); ?>
                    </a>
                </div>
            </div>
        </section><!-- .razox-sticky-add-to-cart -->
        <?php
    }
}

if (!function_exists('razox_woocommerce_product_loop_unit')) {
    function razox_woocommerce_product_loop_unit() {
        global $product;
        $unit = get_post_meta($product->get_id(), '_deal_unit', true);
        if (empty($unit)) {
            return;
        }
        ?>
        <div class="product-unit">
            <span class="title"><?php echo esc_html__('Unit:', 'razox'); ?></span>
            <span class="value"><?php echo esc_html($unit); ?></span>
        </div>
        <?php
    }
}

if (!function_exists('razox_add_quantity_field')) {
    function razox_add_quantity_field() {
        global $product;

        if (!$product->is_sold_individually() && 'variable' != $product->get_type() && $product->is_in_stock()) {
            ?>
            <div class="product-input-quantity">
                <?php
                woocommerce_quantity_input(array('min_value' => 1, 'max_value' => $product->backorders_allowed() ? '' : $product->get_stock_quantity()));
                razox_woocommerce_product_loop_unit();
                ?>
            </div>
            <?php
        }
    }
}

if (!function_exists('razox_woocommerce_product_button_start')) {
    function razox_woocommerce_product_button_start() {
        echo '<div class="product-button">';
    }
}

if (!function_exists('razox_woocommerce_product_button_close')) {
    function razox_woocommerce_product_button_close() {
        echo '</div>';
    }
}

if (!function_exists('razox_product_stock_start')) {
    function razox_product_stock_start() {
        echo '<div class="product-price-stock">';
    }
}

if (!function_exists('razox_product_stock_close')) {
    function razox_product_stock_close() {
        echo '</div>';
    }
}

if (!function_exists('razox_product_caption_footer_start')) {
    function razox_product_caption_footer_start() {
        echo '<div class="product-caption-footer">';
    }
}

if (!function_exists('razox_product_caption_footer_close')) {
    function razox_product_caption_footer_close() {
        echo '</div>';
    }
}

if (!function_exists('razox_stock_label')) {
    function razox_stock_label() {
        global $product;
        if ($product->is_in_stock()) {
            echo '<span class="inventory_status"><span class="stock-title screen-reader-text">' . esc_html__('Availability:', 'razox') . '</span> ' . esc_html__('In Stock', 'razox') . '</span>';
        } else {
            echo '<span class="inventory_status out-stock"><span class="stock-title screen-reader-text">' . esc_html__('Availability:', 'razox') . '</span> ' . esc_html__('Out of Stock', 'razox') . '</span>';
        }
    }
}
if (!function_exists('razox_woocommerce_content_product_imagin')) {
    function razox_woocommerce_content_product_imagin() {
        echo '<div class="content-product-imagin"></div>';
    }
}

if (!function_exists('razox_single_product_summary_top')) {
    function razox_single_product_summary_top() {
        ?>
        <div class="entry-summary-top">
            <?php
            razox_woocommerce_single_brand();
            woocommerce_template_single_rating();
            razox_stock_label();
            ?>
        </div>
        <?php
    }
}

if (!function_exists('razox_single_rating_brands')) {
    function razox_single_rating_brands() {
        ?>
        <div class="rating_brands">
            <?php
            razox_woocommerce_single_brand();
            woocommerce_template_single_rating();
            ?>
        </div>
        <?php
    }
}

if (!function_exists('razox_product_label_rating')) {
    function razox_product_label_rating() {
        ?>
        <div class="label_rating">
            <?php
            razox_product_label();
            woocommerce_template_loop_rating();
            ?>
        </div>
        <?php
    }
}
if (!function_exists('razox_woocommerce_render_color')) {

    function razox_woocommerce_render_color() {
        /**
         * @var $product WC_Product_Variable
         */
        global $product;

        if (!function_exists('Woo_Variation_Swatches')) {
            return;
        }

        if ($product->is_type('variable')) {
            $attr_name           = 'pa_color';
            $product_color_terms = wc_get_product_terms($product->get_id(), $attr_name, array('fields' => 'all'));
            $tax                 = Woo_Variation_Swatches_Backend::instance()->get_attribute_taxonomy($attr_name);
            $options             = $product->get_available_variations();

            if (!empty($product_color_terms)) {
                echo '<div class="product-color">';

                foreach ($product_color_terms as $term) {
                    $thumbnail = [];
                    foreach ($options as $option) {
                        foreach ($option['attributes'] as $_k => $_v) {
                            if ($_k === 'attribute_' . $attr_name && $_v === $term->slug) {
                                $thumbnail = $option['image'];
                                break;
                            }
                            if (count($thumbnail) > 0) {
                                break;
                            }
                        }
                    }

                    if (woo_variation_swatches()->get_frontend()->is_color_attribute($tax)) {
                        // Global Color
                        $color = sanitize_hex_color(woo_variation_swatches()->get_frontend()->get_product_attribute_color($term));
                        echo '<div class="item color-item" data-image="' . htmlspecialchars(wp_json_encode($thumbnail)) . '"  style="background-color:' . esc_attr($color) . '"><span class="screen-reader-text">' . esc_html($term->name) . '</span></div>';
                    } elseif (woo_variation_swatches()->get_frontend()->is_image_attribute($tax)) {
                        $attachment_id = absint(woo_variation_swatches()->get_frontend()->get_product_attribute_image($term));
                        $image_size    = woo_variation_swatches()->get_option('attribute_image_size');
                        $image         = wp_get_attachment_image_src($attachment_id, $image_size);

                        echo sprintf('<div class="item image-item" data-image="' . htmlspecialchars(wp_json_encode($thumbnail)) . '"><img aria-hidden="true" alt="%s" src="%s" width="%d" height="%d" /></div>', esc_attr($term->name), esc_url($image[0]), esc_attr($image[1]), esc_attr($image[2]));
                    }
                }
                echo '</div>';
            }
        }
    }
}

if (!function_exists('razox_single_product_after_title')) {
    function razox_single_product_after_title() {
        global $product;
        ?>
        <div class="product_after_title">
            <?php
            //            razox_woocommerce_single_brand();
            woocommerce_template_single_rating();
            if (wc_product_sku_enabled() && ($product->get_sku() || $product->is_type('variable'))) :
                $sku = $product->get_sku() ? $product->get_sku() : esc_html__('N/A', 'razox');
                ?>
                <span class="sku_wrapper"><?php esc_html_e('SKU:', 'razox'); ?> <span
                            class="sku"><?php printf('%s', $sku); ?></span></span>
            <?php endif; ?>
        </div>
        <?php
    }
}

if (!function_exists('razox_product_label')) {
    function razox_product_label() {
        global $product;

        $output = array();

        $newness_days = 30;
        $created      = strtotime($product->get_date_created());
        if ((time() - (60 * 60 * 24 * $newness_days)) < $created) {
            $output[] = '<span class="new-label">' . esc_html__('New', 'razox') . '</span>';
        } elseif ($product->is_on_sale()) {

            $percentage = '';

            if ($product->get_type() == 'variable') {

                $available_variations = $product->get_variation_prices();
                $max_percentage       = 0;

                foreach ($available_variations['regular_price'] as $key => $regular_price) {
                    $sale_price = $available_variations['sale_price'][$key];

                    if ($sale_price < $regular_price) {
                        $percentage = round((($regular_price - $sale_price) / $regular_price) * 100);

                        if ($percentage > $max_percentage) {
                            $max_percentage = $percentage;
                        }
                    }
                }
                $percentage = $max_percentage;
            } elseif (($product->get_type() == 'simple' || $product->get_type() == 'external')) {
                $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
            }
            if ($percentage) {
                $output[] = '<span class="onsale">' . esc_html__("Sale ", "razox") . $percentage . '%' . '</span>';
            } else {
                $output[] = '<span class="onsale">' . esc_html__('Sale', 'razox') . '</span>';
            }
        }

        if ($output) {
            echo '<div class="label-wrapper">' . implode('', $output) . '</div>';
        }
    }
}

if (!function_exists('razox_woocommerce_get_product_label_new')) {
    function razox_woocommerce_get_product_label_new() {
        global $product;
        $newness_days = 30;
        $created      = strtotime($product->get_date_created());
        if ((time() - (60 * 60 * 24 * $newness_days)) < $created) {
            echo '<span class="new-label">' . esc_html__('New!', 'razox') . '</span>';
        }
    }
}


if (!function_exists('razox_woocommerce_product_gallery_image')) {
    function razox_woocommerce_product_gallery_image() {
        /**
         * @var $product WC_Product
         */
        global $product;
        $gallery = $product->get_gallery_image_ids();
        if (count($gallery) > 0) {
            $size = apply_filters('woocommerce_product_loop_size', 'woocommerce_thumbnail');
            echo '<div class="product-gallery woocommerce-loop-product__gallery">';
            $url1    = wp_get_attachment_image_src($product->get_image_id(), $size);
            $srcset1 = wp_get_attachment_image_srcset($product->get_image_id(), $size);

            echo '<span class="gallery_item active" data-image="' . $url1[0] . '"  data-scrset="' . $srcset1 . '">' . $product->get_image('thumbnail') . '</span>';
            foreach ($gallery as $attachment_id) {
                $url    = wp_get_attachment_image_src($attachment_id, $size);
                $srcset = wp_get_attachment_image_srcset($attachment_id, $size);
                echo '<span class="gallery_item" data-image="' . $url[0] . '" data-scrset="' . $srcset . '">' . wp_get_attachment_image($attachment_id, 'thumbnail') . '</span>';
            }
            echo '</div>';
        }
    }
}


if (!function_exists('razox_woocommerce_product_list_image')) {
    function razox_woocommerce_product_list_image() {
        /**
         * @var $product WC_Product
         */
        global $product; ?>
        <a href="<?php echo esc_url($product->get_permalink()); ?>" class="menu-thumb">
            <?php echo wp_kses_post($product->get_image()); ?>
        </a>
        <?php
    }
}


if (!function_exists('razox_woocommerce_single_product_image_thumbnail_html')) {
    function razox_woocommerce_single_product_image_thumbnail_html($image, $attachment_id) {
        return wc_get_gallery_image_html($attachment_id, true);
    }
}

if (!function_exists('woocommerce_template_loop_product_title')) {

    /**
     * Show the product title in the product loop.
     */
    function woocommerce_template_loop_product_title() {
        echo '<h3 class="woocommerce-loop-product__title"><a href="' . esc_url_raw(get_the_permalink()) . '">' . get_the_title() . '</a></h3>';
    }
}

if (!function_exists('razox_woocommerce_get_product_category')) {
    function razox_woocommerce_get_product_category() {
        global $product;
        echo wc_get_product_category_list($product->get_id(), ', ', '<div class="posted-in">', '</div>');
    }
}

if (!function_exists('razox_woocommerce_get_product_description')) {
    function razox_woocommerce_get_product_description() {
        global $post;

        $short_description = apply_filters('woocommerce_short_description', $post->post_excerpt);

        if ($short_description) {
            ?>
            <div class="short-description">
                <?php echo sprintf('%s', $short_description); ?>
            </div>
            <?php
        }
    }
}

if (!function_exists('razox_button_grid_list_layout')) {
    function razox_button_grid_list_layout() {
        ?>
        <div class="gridlist-toggle desktop-hide-down">
            <a href="<?php echo esc_url(add_query_arg('layout', 'grid')); ?>" id="grid" class="<?php echo isset($_GET['layout']) && $_GET['layout'] == 'list' ? '' : 'active'; ?>" title="<?php echo esc_html__('Grid View', 'razox'); ?>">
                <i class="razox-icon-layout-grid"></i>
                grid
            </a>
            <a href="<?php echo esc_url(add_query_arg('layout', 'list')); ?>" id="list" class="<?php echo isset($_GET['layout']) && $_GET['layout'] == 'list' ? 'active' : ''; ?>" title="<?php echo esc_html__('List View', 'razox'); ?>">
                <i class="razox-icon-layout-list"></i>
                list
            </a>

        </div>
        <?php
    }
}

if (!function_exists('razox_woocommerce_get_product_short_description')) {
    function razox_woocommerce_get_product_short_description() {
        global $post;
        $short_description = wp_trim_words(apply_filters('woocommerce_short_description', $post->post_excerpt), 20);
        if ($short_description) {
            ?>
            <div class="short-description">
                <?php echo sprintf('%s', $short_description); ?>
            </div>
            <?php
        }
    }
}

if (!function_exists('razox_header_wishlist')) {
    function razox_header_wishlist() {
        if (function_exists('yith_wcwl_count_all_products')) {
            if (!razox_get_theme_option('show_header_wishlist', true)) {
                return;
            }
            ?>
            <div class="site-header-wishlist">
                <a class="header-wishlist"
                   href="<?php echo esc_url(get_permalink(get_option('yith_wcwl_wishlist_page_id'))); ?>">
                    <i class="razox-icon-heart"></i>
                    <span class="count"><?php echo esc_html(yith_wcwl_count_all_products()); ?></span>
                </a>
            </div>
            <?php
        } elseif (function_exists('woosw_init')) {
            if (!razox_get_theme_option('show_header_wishlist', true)) {
                return;
            }
            $key = WPCleverWoosw::get_key();

            ?>
            <div class="site-header-wishlist">
                <a class="header-wishlist" href="<?php echo esc_url(WPCleverWoosw::get_url($key, true)); ?>">
                    <i class="razox-icon-heart"></i>
                    <span class="count"><?php echo esc_html(WPCleverWoosw::get_count($key)); ?></span>
                </a>
            </div>
            <?php
        }
    }
}

if (!function_exists('woosw_ajax_update_count') && function_exists('woosw_init')) {
    function woosw_ajax_update_count() {
        $key = WPCleverWoosw::get_key();

        wp_send_json(array(
            'text' => esc_html(_nx('Item', 'Items', WPCleverWoosw::get_count($key), 'items wishlist', 'razox'))
        ));
    }

    add_action('wp_ajax_woosw_ajax_update_count', 'woosw_ajax_update_count');
    add_action('wp_ajax_nopriv_woosw_ajax_update_count', 'woosw_ajax_update_count');
}

if (!function_exists('razox_button_grid_list_layout')) {
    function razox_button_grid_list_layout() {
        ?>
        <div class="gridlist-toggle desktop-hide-down">
            <a href="<?php echo esc_url(add_query_arg('layout', 'grid')); ?>" id="grid" class="<?php echo isset($_GET['layout']) && $_GET['layout'] == 'list' ? '' : 'active'; ?>" title="<?php echo esc_html__('Grid View', 'razox'); ?>">
                <i class="razox-icon-layout-grid"></i>
            </a>
            <a href="<?php echo esc_url(add_query_arg('layout', 'list')); ?>" id="list" class="<?php echo isset($_GET['layout']) && $_GET['layout'] == 'list' ? 'active' : ''; ?>" title="<?php echo esc_html__('List View', 'razox'); ?>">
                <i class="razox-icon-layout-list"></i>
            </a>
        </div>
        <?php
    }
}


if (!function_exists('razox_woocommerce_list_get_rating')) {
    function razox_woocommerce_list_show_rating() {
        global $product;
        echo wc_get_rating_html($product->get_average_rating());
    }
}

if (!function_exists('razox_woocommerce_time_sale')) {
    function razox_woocommerce_time_sale($is_not_single = false) {
        /**
         * @var $product WC_Product
         */
        global $product;

        if (!$product->is_on_sale()) {
            return;
        }

        $time_sale = get_post_meta($product->get_id(), '_sale_price_dates_to', true);
        if ($time_sale) {
            wp_enqueue_script('razox-countdown');
            $deal_text = $is_not_single ? esc_html__('End in:', 'razox') : esc_html__('This time running out', 'razox');
            ?>
            <div class="time-sale">
                <div class="deal-text">
                    <span><?php printf('%s', $deal_text); ?></span>
                </div>
                <div class="razox-countdown" data-countdown="true" data-date="<?php echo esc_html($time_sale); ?>">
                    <div class="countdown-item">
                        <span class="countdown-digits countdown-days"></span>
                        <span class="countdown-label"><?php echo esc_html__('Days', 'razox') ?></span>
                    </div>
                    <div class="countdown-item">
                        <span class="countdown-digits countdown-hours"></span>
                        <span class="countdown-label"><?php echo esc_html__('Hrs', 'razox') ?></span>
                    </div>
                    <div class="countdown-item">
                        <span class="countdown-digits countdown-minutes"></span>
                        <span class="countdown-label"><?php echo esc_html__('Mins', 'razox') ?></span>
                    </div>
                    <div class="countdown-item">
                        <span class="countdown-digits countdown-seconds"></span>
                        <span class="countdown-label"><?php echo esc_html__('Secs', 'razox') ?></span>
                    </div>
                </div>
            </div>
            <?php
        }
    }
}

if (!function_exists('razox_woocommerce_deal_progress')) {
    function razox_woocommerce_deal_progress() {
        global $product;
        $limit = get_post_meta($product->get_id(), '_deal_quantity', true);
        $sold  = intval(get_post_meta($product->get_id(), '_deal_sales_counts', true));
        if (empty($limit)) {
            return;
        }
        ?>
        <div class="deal-sold">
            <div class="deal-progress">
                <div class="progress-bar">
                    <div class="progress-value" style="width: <?php echo trim($sold / $limit * 100) ?>%"></div>
                </div>
            </div>
            <div class="deal-sold-text">
                <span><?php echo esc_html__('Available: ', 'razox'); ?></span>
                <span class="value"><?php echo esc_html(absint($limit - $sold)); ?>/<?php echo esc_html($limit); ?></span>
            </div>
        </div>
        <?php
    }
}

if (!function_exists('razox_single_product_extra_description')) {
    function razox_single_product_extra_description() {
        global $product;

        $label = razox_get_theme_option('single_product_extra_description', '');
        $label = get_post_meta($product->get_id(), '_extra_description', true) !== '' ? get_post_meta($product->get_id(), '_extra_description', true) : $label;
        if ($label !== '') {
            echo '<div class="razox-single-product-extra-description">' . wp_kses_post(wpautop($label)) . '</div>';
        }
    }
}

if (!function_exists('razox_single_product_gift_label')) {
    function razox_single_product_gift_label() {
        global $product;
        $gift = get_post_meta($product->get_id(), '_gift', true);
        if ($gift !== ''): ?>
            <div class="razox-gift-label"><?php echo esc_html__('Free gift included', ''); ?></div>
        <?php
        else:
            razox_product_label();
        endif;
    }
}

if (!function_exists('razox_single_product_trust_seal_image')) {
    function razox_single_product_trust_seal_image() {
        $image = get_theme_mod('razox_options_single_product_trust_seal_image');
        if ($image): ?>
            <div class="razox-single-trust-seal-image">
                <h4 class="label"><?php echo esc_html__('Guarantee Safe & Secure Checkout', 'razox') ?></h4>
                <img src="<?php echo esc_url($image); ?>">
            </div>

        <?php
        endif;
    }
}


if (!function_exists('razox_button_shop_canvas')) {
    function razox_button_shop_canvas() {
        if (is_active_sidebar('sidebar-woocommerce-shop')) { ?>
            <a href="#" class="filter-toggle" aria-expanded="false">
                <span><?php esc_html_e('Filter', 'razox'); ?></span></a>
            <?php
        }
    }
}

if (!function_exists('razox_button_shop_dropdown')) {
    function razox_button_shop_dropdown() {
        if (is_active_sidebar('sidebar-woocommerce-shop')) { ?>
            <a href="#" class="filter-toggle-dropdown" aria-expanded="false">
                <i class="razox-icon-plus-o"></i><span><?php esc_html_e('Filter by', 'razox'); ?></span></a>
            <?php
        }
    }
}

if (!function_exists('razox_render_woocommerce_shop_canvas')) {
    function razox_render_woocommerce_shop_canvas() {
        if (is_active_sidebar('sidebar-woocommerce-shop') && razox_is_product_archive()) {
            ?>
            <div id="razox-canvas-filter" class="razox-canvas-filter">
                <span class="filter-close"><i class="razox-icon-close"></i></span>
                <div class="razox-canvas-filter-wrap">
                    <?php if (razox_get_theme_option('woocommerce_archive_layout') == 'canvas' || razox_get_theme_option('woocommerce_archive_layout') == 'fullwidth' || razox_get_theme_option('woocommerce_archive_layout') == 'menu') {
                        dynamic_sidebar('sidebar-woocommerce-shop');
                    }
                    ?>
                </div>
            </div>
            <div class="razox-overlay-filter"></div>
            <?php
        }
    }
}
if (!function_exists('razox_render_woocommerce_shop_dropdown')) {
    function razox_render_woocommerce_shop_dropdown() {
        ?>
        <div id="razox-dropdown-filter" class="razox-dropdown-filter">
            <div class="razox-dropdown-filter-wrap">
                <?php
                dynamic_sidebar('sidebar-woocommerce-shop');
                ?>
            </div>
        </div>
        <?php
    }
}

if (!function_exists('razox_render_woocommerce_shop_menu')) {
    function razox_render_woocommerce_shop_menu() {
        ?>
        <div id="razox-menu-filter" class="razox-menu-filter">
            <div class="razox-menu-filter-wrap">
                <?php
                dynamic_sidebar('sidebar-woocommerce-shop');
                ?>
            </div>
        </div>
        <?php
    }
}

if (!function_exists('woocommerce_checkout_order_review_start')) {

    function woocommerce_checkout_order_review_start() {
        echo '<div class="checkout-review-order-table-wrapper">';
    }
}

if (!function_exists('woocommerce_checkout_order_review_end')) {

    function woocommerce_checkout_order_review_end() {
        echo '</div>';
    }
}

if (!function_exists('razox_woocommerce_get_product_label_stock')) {
    function razox_woocommerce_get_product_label_stock() {
        /**
         * @var $product WC_Product
         */
        global $product;
        if ($product->get_stock_status() == 'outofstock') {
            echo '<span class="stock-label">' . esc_html__('Out Of Stock', 'razox') . '</span>';
        }
    }
}

if (!function_exists('razox_woocommerce_single_content_wrapper_start')) {
    function razox_woocommerce_single_content_wrapper_start() {
        echo '<div class="content-single-wrapper">';
    }
}

if (!function_exists('razox_woocommerce_single_content_wrapper_end')) {
    function razox_woocommerce_single_content_wrapper_end() {
        echo '</div>';
    }
}

if (!function_exists('razox_woocommerce_single_product_images_start')) {
    function razox_woocommerce_single_product_images_start() {
        echo '<div class="content-single-images-wrapper">';
    }
}

if (!function_exists('razox_woocommerce_single_product_images_end')) {
    function razox_woocommerce_single_product_images_end() {
        echo '</div>';
    }
}

if (!function_exists('razox_woocommerce_single_product_summary_left_start')) {
    function razox_woocommerce_single_product_summary_left_start() {
        echo '<div class="left">';
    }
}

if (!function_exists('razox_woocommerce_single_product_summary_left_end')) {
    function razox_woocommerce_single_product_summary_left_end() {
        echo '</div>';
    }
}

if (!function_exists('razox_woocommerce_single_product_summary_sidebar_left_start')) {
    function razox_woocommerce_single_product_summary_sidebar_left_start() {
        echo '<div class="single-sidebar-left">';
    }
}

if (!function_exists('razox_woocommerce_single_product_summary_sidebar_left_end')) {
    function razox_woocommerce_single_product_summary_sidebar_left_end() {
        echo '</div>';
    }
}

if (!function_exists('razox_woocommerce_single_brand')) {
    function razox_woocommerce_single_brand() {
        $id = get_the_ID();

        $terms = get_the_terms($id, 'product_brand');

        if (is_wp_error($terms)) {
            return $terms;
        }

        if (empty($terms)) {
            return false;
        }

        $links = array();

        foreach ($terms as $term) {
            $link = get_term_link($term, 'product_brand');
            if (is_wp_error($link)) {
                return $link;
            }
            $links[] = '<a href="' . esc_url($link) . '" rel="tag">' . $term->name . '</a>';
        }
        echo '<div class="product-brand">' . esc_html__('Brands: ', 'razox') . join('', $links) . '</div>';
    }
}

if (!function_exists('razox_single_product_video_360')) {
    function razox_single_product_video_360() {
        global $product;
        echo '<div class="product-video-360">';
        $images = get_post_meta($product->get_id(), '_product_360_image_gallery', true);
        $video  = get_post_meta($product->get_id(), '_video_select', true);

        if ($video && wc_is_valid_url($video)) {
            echo '<a class="product-video-360__btn btn-video" href="' . $video . '"><i class="razox-icon-video"></i><span>' . esc_html__('Video', 'razox') . '</span></a>';
        }

        if ($images) {
            $array      = explode(',', $images);
            $images_url = [];
            foreach ($array as $id) {
                $url = wp_get_attachment_image_src($id, 'full');
                if ($url)
                    $images_url[] = $url[0];
            }

            echo '<a class="product-video-360__btn btn-360" href="#view-360"><i class="razox-icon-360"></i><span>' . esc_html__('360 View', 'razox') . '</span></a>';
            ?>
            <div id="view-360" class="view-360 zoom-anim-dialog mfp-hide">
                <div id="rotateimages" class="opal-loading"
                     data-images="<?php echo implode(',', $images_url); ?>"></div>
                <div class="view-360-group">
                    <span class='view-360-button view-360-prev'><i class="razox-icon-angle-left"></i></span>
                    <i class="razox-icon-360 view-360-svg"></i>
                    <span class='view-360-button view-360-next'><i class="razox-icon-angle-right"></i></span>
                </div>
            </div>
            <?php
        }

        echo '</div>';
    }
}

if (!function_exists('razox_quickview_button')) {
    function razox_quickview_button() {
        if (function_exists('woosq_init')) {
            echo do_shortcode('[woosq]');
        }
    }
}
if (!function_exists('razox_single_product_button')) {
    function razox_single_product_button() {
        ?>
        <div class="product_button">
            <?php
            razox_wishlist_button();
            razox_compare_button();
            ?>
        </div>
        <?php
    }
}
if (!function_exists('razox_compare_button')) {
    function razox_compare_button() {
        if (function_exists('woosc_init')) {
            echo do_shortcode('[woosc]');
        }
    }
}

if (!function_exists('razox_wishlist_button')) {
    function razox_wishlist_button() {
        if (function_exists('woosw_init')) {
            echo do_shortcode('[woosw]');
        }
    }
}


if (!function_exists('razox_quick_shop')) {
    function razox_quick_shop($id = false) {
        if (isset($_GET['id'])) {
            $id = sanitize_text_field((int)$_GET['id']);
        }
        if (!$id || !razox_is_woocommerce_activated()) {
            return;
        }

        global $post;

        $args = array('post__in' => array($id), 'post_type' => 'product');

        $quick_posts = get_posts($args);

        foreach ($quick_posts as $post) :
            setup_postdata($post);
            woocommerce_template_single_add_to_cart();
        endforeach;

        wp_reset_postdata();

        die();
    }

    add_action('wp_ajax_razox_quick_shop', 'razox_quick_shop');
    add_action('wp_ajax_nopriv_razox_quick_shop', 'razox_quick_shop');
}

if (!function_exists('razox_quick_shop_wrapper')) {
    function razox_quick_shop_wrapper() {
        global $product;
        ?>
        <div class="quick-shop-wrapper">
            <div class="quick-shop-close cross-button"></div>
            <div class="quick-shop-form"></div>
        </div>
        <?php
    }
}

function razox_ajax_add_to_cart_handler() {
    WC_Form_Handler::add_to_cart_action();
    WC_AJAX::get_refreshed_fragments();
}

add_filter('woocommerce_add_to_cart_fragments', 'razox_ajax_add_to_cart_add_fragments');
function razox_ajax_add_to_cart_add_fragments($fragments) {
    $all_notices  = WC()->session->get('wc_notices', array());
    $notice_types = apply_filters('woocommerce_notice_types', array('error', 'success', 'notice'));

    ob_start();
    foreach ($notice_types as $notice_type) {
        if (wc_notice_count($notice_type) > 0) {
            wc_get_template("notices/{$notice_type}.php", array(
                'notices' => array_filter($all_notices[$notice_type]),
            ));
        }
    }
    $fragments['notices_html'] = ob_get_clean();

    wc_clear_notices();

    return $fragments;
}

add_action('pre_get_product_search_form', 'razox_ajax_search_result');
if (!function_exists('razox_ajax_search_result')) {
    function razox_ajax_search_result() {
        ?>
        <div class="ajax-search-result d-none"></div>
        <?php
    }
}

if (!function_exists('razox_ajax_live_search_template')) {
    function razox_ajax_live_search_template() {
        echo <<<HTML
        <script type="text/html" id="tmpl-ajax-live-search-template">
        <div class="product-item-search">
            <# if(data.url){ #>
            <a class="product-link" href="{{{data.url}}}" title="{{{data.title}}}">
            <# } #>
                <# if(data.img){#>
                <img src="{{{data.img}}}" alt="{{{data.title}}}">
                 <# } #>
                <div class="product-content">
                <h3 class="product-title">{{{data.title}}}</h3>
                <# if(data.price){ #>
                {{{data.price}}}
                 <# } #>
                </div>
                <# if(data.url){ #>
            </a>
            <# } #>
        </div>
        </script>
HTML;
    }
}
add_action('wp_footer', 'razox_ajax_live_search_template');

if (!function_exists('razox_single_product_review_template')) {
    function razox_single_product_review_template() {
        global $product;

        if (comments_open()) {
            ?>
            <div class="single-product-reviews-wrap">
                <?php
                echo '<h3 class="review-title">' . esc_html__('Reviews', 'razox') . '<sup class="count">' . $product->get_review_count() . '</sup></h3>';
                comments_template();
                ?>
            </div>
            <?php
        }
    }
}

if (!function_exists('razox_single_product_tabs_template')) {
    function razox_single_product_tabs_template() {
        $product_tabs = apply_filters('woocommerce_product_tabs', array());
        if (!empty($product_tabs)) : ?>
            <div class="razox-woocommerce-tabs">
                <?php foreach ($product_tabs as $key => $product_tab) : ?>
                    <div class="umimi-woocommerce-tabs-panel">
                        <?php
                        if (isset($product_tab['callback'])) {
                            call_user_func($product_tab['callback'], $key, $product_tab);
                        }
                        ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif;
    }
}

if (!function_exists('razox_woocommerce_render_color')) {

    function razox_woocommerce_render_color() {
        /**
         * @var $product WC_Product_Variable
         */
        global $product;

        if (!function_exists('Woo_Variation_Swatches')) {
            return;
        }

        if ($product->is_type('variable')) {
            $attr_name           = 'pa_color';
            $product_color_terms = wc_get_product_terms($product->get_id(), $attr_name, array('fields' => 'all'));
            $tax                 = Woo_Variation_Swatches_Backend::instance()->get_attribute_taxonomy($attr_name);
            $options             = $product->get_available_variations();

            if (!empty($product_color_terms)) {
                echo '<div class="product-color">';

                foreach ($product_color_terms as $term) {
                    $thumbnail = [];
                    foreach ($options as $option) {
                        foreach ($option['attributes'] as $_k => $_v) {
                            if ($_k === 'attribute_' . $attr_name && $_v === $term->slug) {
                                $thumbnail = $option['image'];
                                break;
                            }
                            if (count($thumbnail) > 0) {
                                break;
                            }
                        }
                    }

                    if (woo_variation_swatches()->get_frontend()->is_color_attribute($tax)) {
                        // Global Color
                        $color = sanitize_hex_color(woo_variation_swatches()->get_frontend()->get_product_attribute_color($term));
                        echo '<div class="item color-item" data-image="' . htmlspecialchars(wp_json_encode($thumbnail)) . '"  style="background-color:' . esc_attr($color) . '"><span class="screen-reader-text">' . esc_html($term->name) . '</span></div>';
                    } elseif (woo_variation_swatches()->get_frontend()->is_image_attribute($tax)) {
                        $attachment_id = absint(woo_variation_swatches()->get_frontend()->get_product_attribute_image($term));
                        $image_size    = woo_variation_swatches()->get_option('attribute_image_size');
                        $image         = wp_get_attachment_image_src($attachment_id, $image_size);

                        echo sprintf('<div class="item image-item" data-image="' . htmlspecialchars(wp_json_encode($thumbnail)) . '"><img aria-hidden="true" alt="%s" src="%s" width="%d" height="%d" /></div>', esc_attr($term->name), esc_url($image[0]), esc_attr($image[1]), esc_attr($image[2]));
                    }
                }
                echo '</div>';
            }
        }
    }
}

if (!function_exists('razox_shop_page_link')) {
    function razox_shop_page_link($keep_query = false, $taxonomy = '') {
        // Base Link decided by current page
        if (is_post_type_archive('product') || is_page(wc_get_page_id('shop')) || is_shop()) {
            $link = get_permalink(wc_get_page_id('shop'));
        } elseif (is_product_category()) {
            $link = get_term_link(get_query_var('product_cat'), 'product_cat');
        } elseif (is_product_tag()) {
            $link = get_term_link(get_query_var('product_tag'), 'product_tag');
        } else {
            $queried_object = get_queried_object();
            $link           = get_term_link($queried_object->slug, $queried_object->taxonomy);
        }

        if ($keep_query) {

            // Min/Max
            if (isset($_GET['min_price'])) {
                $link = add_query_arg('min_price', wc_clean($_GET['min_price']), $link);
            }

            if (isset($_GET['max_price'])) {
                $link = add_query_arg('max_price', wc_clean($_GET['max_price']), $link);
            }

            // Orderby
            if (isset($_GET['orderby'])) {
                $link = add_query_arg('orderby', wc_clean($_GET['orderby']), $link);
            }

            if (isset($_GET['woocommerce_catalog_columns'])) {
                $link = add_query_arg('woocommerce_catalog_columns', wc_clean($_GET['woocommerce_catalog_columns']), $link);
            }

            if (isset($_GET['woocommerce_archive_layout'])) {
                $link = add_query_arg('woocommerce_archive_layout', wc_clean($_GET['woocommerce_archive_layout']), $link);
            }

            if (isset($_GET['layout'])) {
                $link = add_query_arg('layout', wc_clean($_GET['layout']), $link);
            }

            if (isset($_GET['wocommerce_block_style'])) {
                $link = add_query_arg('wocommerce_block_style', wc_clean($_GET['wocommerce_block_style']), $link);
            }

            /**
             * Search Arg.
             * To support quote characters, first they are decoded from &quot; entities, then URL encoded.
             */
            if (get_search_query()) {
                $link = add_query_arg('s', rawurlencode(wp_specialchars_decode(get_search_query())), $link);
            }

            // Post Type Arg
            if (isset($_GET['post_type'])) {
                $link = add_query_arg('post_type', wc_clean($_GET['post_type']), $link);
            }

            // Min Rating Arg
            if (isset($_GET['min_rating'])) {
                $link = add_query_arg('min_rating', wc_clean($_GET['min_rating']), $link);
            }

            // All current filters
            if ($_chosen_attributes = WC_Query::get_layered_nav_chosen_attributes()) {
                foreach ($_chosen_attributes as $name => $data) {
                    if ($name === $taxonomy) {
                        continue;
                    }
                    $filter_name = sanitize_title(str_replace('pa_', '', $name));
                    if (!empty($data['terms'])) {
                        $link = add_query_arg('filter_' . $filter_name, implode(',', $data['terms']), $link);
                    }
                    if ('or' == $data['query_type']) {
                        $link = add_query_arg('query_type_' . $filter_name, 'or', $link);
                    }
                }
            }
        }

        if (is_string($link)) {
            return $link;
        } else {
            return '';
        }
    }
}

if (!function_exists('razox_products_per_page_select')) {

    function razox_products_per_page_select() {
        if ((wc_get_loop_prop('is_shortcode') || !wc_get_loop_prop('is_paginated') || !woocommerce_products_will_display())) return;

        $row          = wc_get_default_products_per_row();
        $max_col      = apply_filters('razox_products_row_step_max', 6);
        $array_option = [];
        if ($max_col > 2) {
            for ($i = 2; $i <= $max_col; $i++) {
                $array_option[] = $row * $i;
            }
        } else {
            return;
        }

        $col = wc_get_default_product_rows_per_page();

        $products_per_page_options = apply_filters('razox_products_per_page_options', $array_option);

        $current_variation = isset($_GET['per_page']) ? $_GET['per_page'] : $col * $row;
        ?>

        <div class="razox-products-per-page">

            <label for="per_page" class="per-page-title"><?php esc_html_e('Show ', 'razox'); ?></label>
            <select name="per_page" id="per_page">
                <?php
                foreach ($products_per_page_options as $key => $value) :

                    ?>
                    <option value="<?php echo add_query_arg('per_page', $value, razox_shop_page_link(true)); ?>" <?php echo esc_attr($current_variation == $value ? 'selected' : ''); ?>>
                        <?php echo esc_html($value); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <?php
    }
}

if (isset($_GET['per_page'])) {
    add_filter('loop_shop_per_page', 'razox_loop_shop_per_page', 20);
}

function razox_loop_shop_per_page($cols) {

    $cols = isset($_GET['per_page']) ? $_GET['per_page'] : $cols;

    return $cols;
}

if (!function_exists('razox_get_shop_banner')) {

    function razox_get_shop_banner() {
        if (!razox_is_elementor_activated() || is_singular('product') || !razox_is_product_archive()) {
            return;
        }
        $slug = razox_get_theme_option('shop_banner');

        $queried_post = get_page_by_path($slug, OBJECT, 'elementor_library');
        if (isset($queried_post->ID)) {
            // Scripts and styles.

            echo Elementor\Plugin::instance()->frontend->get_builder_content_for_display($queried_post->ID);
        }
    }
}
if (!function_exists('razox_get_shop_banner_scripts')) {
    function razox_get_shop_banner_scripts() {
        $slug = razox_get_theme_option('shop_banner');

        $queried_post = get_page_by_path($slug, OBJECT, 'elementor_library');
        if (isset($queried_post->ID)) {

            if (class_exists('\Elementor\Core\Files\CSS\Post')) {
                $css_file = new \Elementor\Core\Files\CSS\Post($queried_post->ID);
            } elseif (class_exists('\Elementor\Post_CSS_File')) {
                $css_file = new \Elementor\Post_CSS_File($queried_post->ID);
            }

            $css_file->enqueue();
        }
    }
}
add_action('wp_footer', 'razox_get_tooltip_global_product');
add_action('woocommerce_before_shop_loop_item_title', 'razox_get_tooltip_product', 10);

if (!function_exists('razox_get_tooltip_global_product')) {
    function razox_get_tooltip_global_product() { ?>
        <div id="global-tooltip" class="global-tooltip"></div>
        <?php
    }
}
if (!function_exists('razox_get_tooltip_product')) {
    function razox_get_tooltip_product() {
        global $product;
        $warranty     = get_post_meta($product->get_id(), '_warranty', true);
        $key_features = get_post_meta($product->get_id(), '_key_features', true);
        $gift         = get_post_meta($product->get_id(), '_gift', true);
        if ($gift !== '' || $key_features !== ''):
            ?>
            <div class="tooltip p-tooltip tippy-box">
                <div class="tooltip-inner">
                    <div class="tooltip-name">
                        <?php woocommerce_template_loop_product_title() ?>
                    </div>

                    <div class="tooltip-desc">
                        <div class="tooltip-info">
                            <table class="table-info">
                                <tr>
                                    <th class="label"><?php echo esc_html__('Price', 'razox') ?>:</th>
                                    <td class="info"><?php woocommerce_template_loop_price(); ?></td>
                                </tr>

                                <?php
                                if (!empty($warranty)): ?>
                                    <tr>
                                        <th class="label"><?php echo esc_html__('Warranty', 'razox') ?>:</th>
                                        <td class="info"><?php echo sprintf('%s', $warranty); // PHPCS: XSS ok. ?></td>
                                    </tr>
                                <?php endif; ?>

                                <tr>
                                    <th class="label"><?php echo esc_html__('Status', 'razox') ?>:</th>
                                    <td class="info"><?php razox_stock_label(); ?></td>
                                </tr>
                            </table>

                        </div>

                        <?php
                        if ($key_features !== ''): ?>
                            <div class="tooltip-features">
                                <h3 class="label-features"><?php echo esc_html__('Key Features', 'razox') ?></h3>
                                <?php echo wp_kses_post(wpautop($key_features)); ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($gift !== ''): ?>
                            <div class="tooltip-gift">
                                <h3 class="label-gift"><?php echo esc_html__('Free gift included', 'razox') ?></h3>
                                <?php echo wp_kses_post(wpautop($gift)); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php
        endif;
    }
}

if (!function_exists('razox_get_review_counting')) {
    function razox_get_review_counting() {

        global $post;
        $output = array();

        for ($i = 1; $i <= 5; $i++) {
            $args       = array(
                'post_id'    => ($post->ID),
                'meta_query' => array(
                    array(
                        'key'   => 'rating',
                        'value' => $i
                    )
                ),
                'count'      => true
            );
            $output[$i] = get_comments($args);
        }

        return $output;
    }
}

