<?php
/**
 * Razox WooCommerce hooks
 *
 * @package razox
 */


/**
 * Functions hooked in to woocommerce_before_main_content action
 *
 * @removed woocommerce_breadcrumb - 20
 * @removed woocommerce_output_content_wrapper - 10
 *
 * @see razox_get_shop_banner - 5
 * @see razox_before_content - 10
 */

/**
 * Functions hooked in to wp_enqueue_scripts action
 *
 * @see razox_get_shop_banner_scripts - 00 -woo
 */

/**
 * Functions hooked in to woocommerce_before_shop_loop action
 *
 * @removed woocommerce_result_count - 20
 * @removed woocommerce_catalog_ordering - 30
 *
 * @see razox_sorting_wrapper_start - 10
 * @see razox_button_shop_canvas - 15
 * @see woocommerce_result_count - 20
 * @see razox_button_grid_list_layout - 30
 * @see woocommerce_catalog_ordering - 40
 * @see razox_sorting_wrapper_close - 60
 * @see razox_woocommerce_before_shop_loop - 99
 *
 */

if (razox_get_theme_option('woocommerce_archive_layout') == 'menu') {
    add_action('woocommerce_before_shop_loop', 'razox_render_woocommerce_shop_menu', 15);
    remove_action('woocommerce_before_shop_loop', 'razox_button_shop_canvas', 15);
    remove_action('woocommerce_before_shop_loop', 'razox_button_grid_list_layout', 30);
    remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
} elseif (razox_get_theme_option('woocommerce_archive_layout') == 'dropdown') {
    add_action('woocommerce_before_shop_loop', 'razox_render_woocommerce_shop_dropdown', 55);
}
add_action('woocommerce_before_shop_loop', 'razox_products_per_page_select', 45);

/**
 * Functions hooked in to woocommerce_after_main_content action
 *
 * @removed woocommerce_output_content_wrapper_end - 10
 * @see razox_after_content - 10
 */


/**
 * Functions hooked in to woocommerce_sidebar action
 *
 * @see woocommerce_get_sidebar - 10
 */

/**
 * Functions hooked in to woocommerce_after_shop_loop action
 *
 * @see razox_woocommerce_product_loop_end - 0
 */


/**
 * Layout Single
 *
 */


//Wrapper content single


/**
 * Functions hooked in to woobt_extra_above action
 *
 * @see razox_product_woobt_extra_above_wrapper - 0
 */

/**
 * Functions hooked in to woobt_extra_below action
 *
 * @see razox_product_woobt_extra_below_wrapper - 99
 */

/**
 * Functions hooked in to woobt_wrap_above action
 *
 * @see razox_product_woobt_wrap_above_wrapper - 95
 * @see razox_product_woobt_title - 10
 */

/**
 * Functions hooked in to woobt_wrap_below action
 *
 * @see razox_product_woobt_wrap_below_wrapper - 99
 */


/**
 * Functions hooked in to woocommerce_after_add_to_cart_button action
 *
 * @see razox_single_product_button - 31
 */


/**
 * Functions hooked in to razox_single_product_video_360 action
 *
 * @removed woocommerce_show_product_sale_flash - 30
 * @see razox_single_product_video_360 - 10
 */

/**
 * Functions hooked in to woocommerce_cart_collaterals action
 *
 * @removed  woocommerce_cross_sell_display - 00
 */


/**
 * Functions hooked in to woocommerce_after_cart action
 *
 * @see woocommerce_cross_sell_display - 00
 */

/**
 * Functions hooked in to woocommerce_checkout_order_review action
 *
 * @see woocommerce_checkout_order_review_start - 5
 * @see woocommerce_checkout_order_review_end - 15
 */


/**
 * Functions hooked in to woosc_button_position_archive action
 *
 * @see __return_false - 00
 */

/**
 * Functions hooked in to woosq_button_position action
 *
 * @see __return_false - 00
 */

/**
 * Functions hooked in to woosw_button_position_archive action
 *
 * @see __return_false - 00
 */

/**
 * =================================================
 * Hook woosc_button_position_archive
 * =================================================
 */
add_action('woosc_button_position_archive', '__return_false');

/**
 * =================================================
 * Hook woosq_button_position
 * =================================================
 */
add_action('woosq_button_position', '__return_false');

/**
 * =================================================
 * Hook woosw_button_position_archive
 * =================================================
 */
add_action('woosw_button_position_archive', '__return_false');

//style product single

