<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined('ABSPATH') || exit;

global $product;

// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if ( ! is_a( $product, WC_Product::class ) || ! $product->is_visible() ) {
    return;
}
$class = '';
if (wc_get_loop_prop('enable_carousel', false) == true) {
    $class = 'swiper-slide';
}
?>
<li <?php wc_product_class($class, $product); ?>>
    <?php
    /**
     * Functions hooked in to woocommerce_before_shop_loop_item action
     *
     * These are the default hooks.
     * @hooked woocommerce_template_loop_product_link_open - 10
     *
     * New hooks are written here
     * @removed woocommerce_template_loop_product_link_open - 10
     * @see  razox_product_block_wrapper_start - 0
     * @see  razox_product_action_start - 5
     * @see  razox_display_product_category - 10
     * @see  razox_woocommerce_product_loop_action_start - 15
     * @see  razox_wishlist_button - 20
     * @see  razox_compare_button - 25
     * @see  razox_quickview_button - 30
     * @see  razox_woocommerce_product_loop_action_close - 35
     * @see  razox_product_action_close - 40
     */
    do_action('woocommerce_before_shop_loop_item');


    /**
     * Functions hooked in to woocommerce_before_shop_loop_item_title action
     *
     * These are the default hooks.
     * @hooked woocommerce_show_product_loop_sale_flash - 10
     * @hooked woocommerce_template_loop_product_thumbnail - 10
     *
     * New hooks are written here
     * @see  razox_product_transition_wrapper_start - 5
     * @removed woocommerce_show_product_loop_sale_flash - 10
     * @removed woocommerce_template_loop_product_thumbnail - 10
     * @see  razox_template_loop_product_thumbnail - 10
     * @nosee  razox_product_label - 10
     * @see  razox_single_product_gift_label - 10
     * @see  woocommerce_template_loop_product_link_open - 50
     * @see  woocommerce_template_loop_product_link_close - 50
     * @see  razox_product_transition_wrapper_close - 99
     */
    do_action('woocommerce_before_shop_loop_item_title');

    /**
     * Functions hooked in to woocommerce_shop_loop_item_title action
     *
     * These are the default hooks.
     * @hooked woocommerce_template_loop_product_title - 10
     *
     * New hooks are written here
     * @see razox_product_caption_wrapper_start - 0
     *
     */
    do_action('woocommerce_shop_loop_item_title');

    /**
     * Functions hooked in to woocommerce_after_shop_loop_item_title action
     *
     * @hooked woocommerce_template_loop_rating - 5
     * @hooked woocommerce_template_loop_price - 10
     *
     * New hooks are written here
     * @see razox_product_caption_footer_start - 5
     * @see razox_product_stock_start - 15
     * @see razox_stock_label - 20
     * @see woocommerce_template_loop_add_to_cart - 25
     * @see razox_product_stock_close - 30
     * @see razox_product_caption_footer_close - 35
     *
     */
    do_action('woocommerce_after_shop_loop_item_title');

    /**
     * Functions hooked in to woocommerce_after_shop_loop_item action
     *
     * These are the default hooks.
     * @hooked woocommerce_template_loop_product_link_close - 5
     * @hooked woocommerce_template_loop_add_to_cart - 10
     *
     *
     * New hooks are written here
     * @removed woocommerce_template_loop_product_link_close - 5
     * @removed woocommerce_template_loop_add_to_cart - 10
     * @nosee razox_woocommerce_render_color - 90
     * @see razox_product_caption_wrapper_close - 90
     * @see razox_product_block_wrapper_close - 95
     */
    do_action('woocommerce_after_shop_loop_item');
    ?>
</li>
