<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action('woocommerce_before_single_product');

if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}

$gallery_style = razox_get_theme_option('single_product_gallery_layout', 'horizontal');
$tabs_layout = razox_get_theme_option('single_product_tabs_layout', 'tabs');
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class('single-product-type-' . $gallery_style, $product); ?>>

    <?php
    /**
     * Functions hooked in to woocommerce_before_single_product_summary action
     *
     * @hooked woocommerce_show_product_sale_flash - 10
     * @hooked woocommerce_show_product_images - 20
     *
     * @removed woocommerce_show_product_sale_flash - 10
     * @see razox_woocommerce_single_content_wrapper_start - 2
     * @see razox_woocommerce_single_product_images_start - 2
     * @see razox_woocommerce_single_product_images_end - 99
     *
     *
     */
    do_action('woocommerce_before_single_product_summary');

    ?>

    <div class="summary entry-summary <?php if ($tabs_layout === 'sticky' || $gallery_style === 'sticky' || $gallery_style === 'horizontal') echo 'product-sticky-layout'; ?>">
        <?php
        /**
         * Functions hooked in to woocommerce_single_product_summary action
         *
         * @hooked woocommerce_template_single_title - 5
         * @hooked woocommerce_template_single_rating - 10
         * @hooked woocommerce_template_single_price - 10
         * @hooked woocommerce_template_single_excerpt - 20
         * @hooked woocommerce_template_single_add_to_cart - 30
         * @hooked woocommerce_template_single_meta - 40
         * @hooked woocommerce_template_single_sharing - 50
         * @hooked WC_Structured_Data::generate_product_data() - 60
         *
         * @removed woocommerce_template_single_rating - 10
         * @removed woocommerce_template_single_price - 10
         *
         * @see razox_woocommerce_single_product_summary_left_start - 0
         * @see woocommerce_show_product_sale_flash - 1
         * @see razox_single_product_summary_top - 10
         * @see woocommerce_template_single_price - 20
         * @see razox_woocommerce_time_sale - 25
         * @see razox_woocommerce_deal_progress - 25
         * @see razox_single_product_extra_description - 35
         * @see razox_single_product_trust_seal_image - 35
         * @see razox_woocommerce_single_product_summary_left_end - 99
         * @see razox_woocommerce_single_content_wrapper_end - 99
         */
        do_action('woocommerce_single_product_summary');
        ?>
    </div>

    <?php
    /**
     * Functions hooked in to woocommerce_after_single_product_summary action
     *
     * @hooked woocommerce_output_product_data_tabs - 10
     * @hooked woocommerce_upsell_display - 15
     * @hooked woocommerce_output_related_products - 20
     */
    do_action('woocommerce_after_single_product_summary');
    ?>
</div>

<?php
/**
 * Functions hooked in to woocommerce_after_single_product action
 *
 */
do_action('woocommerce_after_single_product');
?>
